/* $Id: TspSimpleSampleSymbolInfo.java,v 1.2 2005/04/09 03:35:04 sgalles Exp $
 * -----------------------------------------------------------------------
 * 
 * TSP Library - core components for a generic Transport Sampling Protocol.
 * 
 * Copyright (c) 2002 Yves DUFRENNE, Stephane GALLES, Eric NOULARD and Robert PAGNOT 
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * -----------------------------------------------------------------------
 * 
 * Project    : TSP
 * SubProject : jTSP
 * Maintainer : tsp@astrium-space.com
 * Component  : Consumer
 * 
 * -----------------------------------------------------------------------
 * 
 * Purpose   : 
 * 
 * -----------------------------------------------------------------------
 */
package tsp.core.consumer.simple;

import java.util.List;
import java.util.LinkedList;

import tsp.core.rpc.TSP_sample_symbol_info_t;

public class TspSimpleSampleSymbolInfo {

	// TODO : get ride of protocol dependent struct
	private String name;
	private int phase;
	private int period;
	private int index;
		
	TspSimpleSampleSymbolInfo(TSP_sample_symbol_info_t si) {
		this(si.name, si.period, si.phase, si.provider_global_index);
	}
	
	public TspSimpleSampleSymbolInfo(String name, int period, int phase) {		
		this(name, period, phase, -1);		
	}
	
	public TspSimpleSampleSymbolInfo(TspSimpleSampleSymbolInfo si) {		
		this(si.name, si.period, si.phase, si.index);		
	}
	
	public TspSimpleSampleSymbolInfo(String name, int period, int phase, int index) {
		super();
		this.name = name;
		this.period = period;
		this.phase = phase;		
		this.index = index;
	}
	
	public String getName(){
		return name;
	}
		
	
	public int getPhase(){
		return phase;
	}
	
	public int getPeriod(){
		return period;
	}
		
		
	/**
	 * @return Returns the index.
	 */
	public int getIndex() {
		return index;
	}
	/**
	 * @param index The index to set.
	 */
	public void setIndex(int index) {
		this.index = index;
	}
	/**
	 * @param name The name to set.
	 */
	public void setName(String name) {
		this.name = name;
	}
	/**
	 * @param period The period to set.
	 */
	public void setPeriod(int period) {
		this.period = period;
	}
	/**
	 * @param phase The phase to set.
	 */
	public void setPhase(int phase) {
		this.phase = phase;
	}
	TSP_sample_symbol_info_t createInfo_t(){
		TSP_sample_symbol_info_t info = new TSP_sample_symbol_info_t();
		info.name = name;
		info.period = period;
		info.phase = phase;
		info.provider_global_index = index;
		info.provider_group_index = -1;
		info.provider_group_rank = -1;
		info.xdr_tsp_t = new byte[4];
		info.dimension = 0;
		return info;
	}
	
	static TspSimpleSampleSymbolInfo[] createArray(TSP_sample_symbol_info_t[] infos){
		List l = new LinkedList();
		for(int i=0 ; i < infos.length ; i++){
			l.add(new TspSimpleSampleSymbolInfo(infos[i]));
		}
		return (TspSimpleSampleSymbolInfo[])l.toArray(new TspSimpleSampleSymbolInfo[0]);
	}
	
	static TSP_sample_symbol_info_t[] createArrayOfInfo_t(TspSimpleSampleSymbolInfo[] infos){
		List l = new LinkedList();
		for(int i=0 ; i < infos.length ; i++){
			l.add(infos[i].createInfo_t());
		}
		return (TSP_sample_symbol_info_t[])l.toArray(new TSP_sample_symbol_info_t[0]);
	}
	
	
			
}
