/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.text;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jfree.text.TextBlockAnchor;
import org.jfree.text.TextLine;
import org.jfree.ui.TextAnchor;

public class TextBlock {
    private List lines = new ArrayList();

    public void addLine(String string, Font font) {
        this.addLine(new TextLine(string, font));
    }

    public void addLine(TextLine textLine) {
        this.lines.add(textLine);
    }

    public TextLine getLastLine() {
        TextLine textLine = null;
        int n = this.lines.size() - 1;
        if (n >= 0) {
            textLine = (TextLine)this.lines.get(n);
        }
        return textLine;
    }

    public Dimension calculateDimensions(Graphics2D graphics2D) {
        Dimension dimension = new Dimension();
        double d = 0.0;
        double d2 = 0.0;
        Iterator iterator = this.lines.iterator();
        while (iterator.hasNext()) {
            TextLine textLine = (TextLine)iterator.next();
            Dimension dimension2 = textLine.calculateDimensions(graphics2D);
            d = Math.max(d, dimension2.getWidth());
            d2 += dimension2.getHeight();
        }
        dimension.setSize((int)Math.ceil(d), (int)Math.ceil(d2));
        return dimension;
    }

    public void draw(Graphics2D graphics2D, float f, float f2, TextBlockAnchor textBlockAnchor) {
        this.draw(graphics2D, f, f2, textBlockAnchor, 0.0f, 0.0f, 0.0);
    }

    public void draw(Graphics2D graphics2D, float f, float f2, TextBlockAnchor textBlockAnchor, float f3, float f4, double d) {
        Dimension dimension = this.calculateDimensions(graphics2D);
        float[] fArray = this.calculateOffsets(textBlockAnchor, dimension.getWidth(), dimension.getHeight());
        Iterator iterator = this.lines.iterator();
        float f5 = 0.0f;
        while (iterator.hasNext()) {
            TextLine textLine = (TextLine)iterator.next();
            textLine.draw(graphics2D, f + fArray[0], f2 + fArray[1] + f5, TextAnchor.TOP_LEFT, f3, f4, d);
            Dimension dimension2 = textLine.calculateDimensions(graphics2D);
            f5 += (float)dimension2.getHeight();
        }
    }

    private float[] calculateOffsets(TextBlockAnchor textBlockAnchor, double d, double d2) {
        float[] fArray = new float[2];
        float f = 0.0f;
        float f2 = 0.0f;
        if (textBlockAnchor == TextBlockAnchor.TOP_CENTER || textBlockAnchor == TextBlockAnchor.CENTER || textBlockAnchor == TextBlockAnchor.BOTTOM_CENTER) {
            f = (float)(-d) / 2.0f;
        } else if (textBlockAnchor == TextBlockAnchor.TOP_RIGHT || textBlockAnchor == TextBlockAnchor.CENTER_RIGHT || textBlockAnchor == TextBlockAnchor.BOTTOM_RIGHT) {
            f = (float)(-d);
        }
        if (textBlockAnchor == TextBlockAnchor.TOP_LEFT || textBlockAnchor == TextBlockAnchor.TOP_CENTER || textBlockAnchor == TextBlockAnchor.TOP_RIGHT) {
            f2 = 0.0f;
        } else if (textBlockAnchor == TextBlockAnchor.CENTER_LEFT || textBlockAnchor == TextBlockAnchor.CENTER || textBlockAnchor == TextBlockAnchor.CENTER_RIGHT) {
            f2 = (float)(-d2) / 2.0f;
        } else if (textBlockAnchor == TextBlockAnchor.BOTTOM_LEFT || textBlockAnchor == TextBlockAnchor.BOTTOM_CENTER || textBlockAnchor == TextBlockAnchor.BOTTOM_RIGHT) {
            f2 = (float)(-d2);
        }
        fArray[0] = f;
        fArray[1] = f2;
        return fArray;
    }
}

