/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.renderer.AbstractCategoryItemRenderer;
import org.jfree.chart.renderer.CategoryItemRendererState;
import org.jfree.chart.renderer.Outlier;
import org.jfree.chart.renderer.OutlierList;
import org.jfree.chart.renderer.OutlierListCollection;
import org.jfree.data.CategoryDataset;
import org.jfree.data.statistics.BoxAndWhiskerCategoryDataset;
import org.jfree.ui.RectangleEdge;

public class BoxAndWhiskerRenderer
extends AbstractCategoryItemRenderer {
    private Paint artifactPaint = Color.black;
    private double boxWidth = 0.0;
    private double itemMargin = 0.2;

    public Paint getArtifactPaint() {
        return this.artifactPaint;
    }

    public void setArtifactPaint(Paint paint) {
        this.artifactPaint = paint;
    }

    public double getBoxWidth() {
        return this.boxWidth;
    }

    public void setBoxWidth(double d) {
        this.boxWidth = d;
    }

    public double getItemMargin() {
        return this.itemMargin;
    }

    public void setItemMargin(double d) {
        this.itemMargin = d;
    }

    public CategoryItemRendererState initialise(Graphics2D graphics2D, Rectangle2D rectangle2D, CategoryPlot categoryPlot, Integer n, PlotRenderingInfo plotRenderingInfo) {
        CategoryItemRendererState categoryItemRendererState = super.initialise(graphics2D, rectangle2D, categoryPlot, n, plotRenderingInfo);
        CategoryAxis categoryAxis = this.getDomainAxis(categoryPlot, n);
        CategoryDataset categoryDataset = this.getDataset(categoryPlot, n);
        if (categoryDataset != null) {
            int n2 = categoryDataset.getColumnCount();
            int n3 = categoryDataset.getRowCount();
            double d = 0.0;
            PlotOrientation plotOrientation = categoryPlot.getOrientation();
            if (plotOrientation == PlotOrientation.HORIZONTAL) {
                d = rectangle2D.getHeight();
            } else if (plotOrientation == PlotOrientation.VERTICAL) {
                d = rectangle2D.getWidth();
            }
            double d2 = 0.0;
            double d3 = 0.0;
            if (n2 > 1) {
                d2 = categoryAxis.getCategoryMargin();
            }
            if (n3 > 1) {
                d3 = this.getItemMargin();
            }
            double d4 = d * (1.0 - categoryAxis.getLowerMargin() - categoryAxis.getUpperMargin() - d2 - d3);
            if (n3 * n2 > 0) {
                this.setBoxWidth(d4 / (double)(categoryDataset.getColumnCount() * categoryDataset.getRowCount()));
            } else {
                this.setBoxWidth(d4);
            }
        }
        return categoryItemRendererState;
    }

    public void drawItem(Graphics2D graphics2D, CategoryItemRendererState categoryItemRendererState, Rectangle2D rectangle2D, CategoryPlot categoryPlot, CategoryAxis categoryAxis, ValueAxis valueAxis, CategoryDataset categoryDataset, int n, int n2) {
        if (!(categoryDataset instanceof BoxAndWhiskerCategoryDataset)) {
            throw new IllegalArgumentException("BoxAndWhiskerRenderer.drawItem() : the data should be of type BoxAndWhiskerCategoryDataset only.");
        }
        PlotOrientation plotOrientation = categoryPlot.getOrientation();
        if (plotOrientation == PlotOrientation.HORIZONTAL) {
            this.drawHorizontalItem(graphics2D, rectangle2D, categoryPlot, categoryAxis, valueAxis, categoryDataset, n, n2);
        } else if (plotOrientation == PlotOrientation.VERTICAL) {
            this.drawVerticalItem(graphics2D, rectangle2D, categoryPlot, categoryAxis, valueAxis, categoryDataset, n, n2);
        }
    }

    public void drawHorizontalItem(Graphics2D graphics2D, Rectangle2D rectangle2D, CategoryPlot categoryPlot, CategoryAxis categoryAxis, ValueAxis valueAxis, CategoryDataset categoryDataset, int n, int n2) {
        Number number;
        double d;
        double d2;
        double d3;
        BoxAndWhiskerCategoryDataset boxAndWhiskerCategoryDataset = (BoxAndWhiskerCategoryDataset)categoryDataset;
        double d4 = categoryAxis.getCategoryEnd(n2, this.getColumnCount(), rectangle2D, categoryPlot.getDomainAxisEdge());
        double d5 = categoryAxis.getCategoryStart(n2, this.getColumnCount(), rectangle2D, categoryPlot.getDomainAxisEdge());
        double d6 = Math.abs(d4 - d5);
        double d7 = d5;
        int n3 = this.getRowCount();
        int n4 = this.getColumnCount();
        if (n3 > 1) {
            d3 = rectangle2D.getWidth() * this.getItemMargin() / (double)(n4 * (n3 - 1));
            double d8 = this.getBoxWidth() * (double)n3 + d3 * (double)(n3 - 1);
            double d9 = (d6 - d8) / 2.0;
            d7 = d7 + d9 + (double)n * (this.getBoxWidth() + d3);
        } else {
            d3 = (d6 - this.boxWidth) / 2.0;
            d7 += d3;
        }
        Paint paint = this.getItemPaint(n, n2);
        if (paint != null) {
            graphics2D.setPaint(paint);
        }
        Stroke stroke = this.getItemStroke(n, n2);
        graphics2D.setStroke(stroke);
        RectangleEdge rectangleEdge = categoryPlot.getRangeAxisEdge();
        Number number2 = boxAndWhiskerCategoryDataset.getQ1Value(n, n2);
        Number number3 = boxAndWhiskerCategoryDataset.getQ3Value(n, n2);
        Number number4 = boxAndWhiskerCategoryDataset.getMaxRegularValue(n, n2);
        Number number5 = boxAndWhiskerCategoryDataset.getMinRegularValue(n, n2);
        if (number2 != null && number3 != null && number4 != null && number5 != null) {
            d2 = valueAxis.translateValueToJava2D(number2.doubleValue(), rectangle2D, rectangleEdge);
            double d10 = valueAxis.translateValueToJava2D(number3.doubleValue(), rectangle2D, rectangleEdge);
            d = valueAxis.translateValueToJava2D(number4.doubleValue(), rectangle2D, rectangleEdge);
            double d11 = valueAxis.translateValueToJava2D(number5.doubleValue(), rectangle2D, rectangleEdge);
            if (d > d2 && d > d10) {
                graphics2D.draw(new Line2D.Double(d, d7 + this.boxWidth / 2.0, Math.max(d2, d10), d7 + this.boxWidth / 2.0));
                graphics2D.draw(new Line2D.Double(d, d7, d, d7 + this.boxWidth));
            }
            if (d11 < d2 && d11 < d10) {
                graphics2D.draw(new Line2D.Double(d11, d7 + this.boxWidth / 2.0, Math.min(d2, d10), d7 + this.boxWidth / 2.0));
                graphics2D.draw(new Line2D.Double(d11, d7, d11, d7 + this.boxWidth));
            }
            Rectangle2D.Double double_ = new Rectangle2D.Double(Math.min(d2, d10), d7, Math.abs(d2 - d10), this.boxWidth);
            graphics2D.fill(double_);
            graphics2D.draw(double_);
        }
        graphics2D.setPaint(this.artifactPaint);
        d2 = 0.0;
        Number number6 = boxAndWhiskerCategoryDataset.getMeanValue(n, n2);
        if (number6 != null) {
            double d12 = valueAxis.translateValueToJava2D(number6.doubleValue(), rectangle2D, rectangleEdge);
            d2 = this.boxWidth / 4.0;
            Ellipse2D.Double double_ = new Ellipse2D.Double(d12 - d2, d7 + d2, d2 * 2.0, d2 * 2.0);
            graphics2D.fill(double_);
            graphics2D.draw(double_);
        }
        if ((number = boxAndWhiskerCategoryDataset.getMedianValue(n, n2)) != null) {
            d = valueAxis.translateValueToJava2D(number.doubleValue(), rectangle2D, rectangleEdge);
            graphics2D.draw(new Line2D.Double(d, d7, d, d7 + this.boxWidth));
        }
    }

    public void drawVerticalItem(Graphics2D graphics2D, Rectangle2D rectangle2D, CategoryPlot categoryPlot, CategoryAxis categoryAxis, ValueAxis valueAxis, CategoryDataset categoryDataset, int n, int n2) {
        Serializable serializable;
        Cloneable cloneable;
        double d;
        double d2;
        double d3;
        double d4;
        double d5;
        BoxAndWhiskerCategoryDataset boxAndWhiskerCategoryDataset = (BoxAndWhiskerCategoryDataset)categoryDataset;
        double d6 = categoryAxis.getCategoryEnd(n2, this.getColumnCount(), rectangle2D, categoryPlot.getDomainAxisEdge());
        double d7 = categoryAxis.getCategoryStart(n2, this.getColumnCount(), rectangle2D, categoryPlot.getDomainAxisEdge());
        double d8 = d6 - d7;
        double d9 = d7;
        int n3 = this.getRowCount();
        int n4 = this.getColumnCount();
        if (n3 > 1) {
            d5 = rectangle2D.getWidth() * this.getItemMargin() / (double)(n4 * (n3 - 1));
            d4 = this.getBoxWidth() * (double)n3 + d5 * (double)(n3 - 1);
            double d10 = (d8 - d4) / 2.0;
            d9 = d9 + d10 + (double)n * (this.getBoxWidth() + d5);
        } else {
            d5 = (d8 - this.boxWidth) / 2.0;
            d9 += d5;
        }
        d5 = 0.0;
        Paint paint = this.getItemPaint(n, n2);
        if (paint != null) {
            graphics2D.setPaint(paint);
        }
        Stroke stroke = this.getItemStroke(n, n2);
        graphics2D.setStroke(stroke);
        double d11 = 0.0;
        RectangleEdge rectangleEdge = categoryPlot.getRangeAxisEdge();
        Number number = boxAndWhiskerCategoryDataset.getQ1Value(n, n2);
        Number number2 = boxAndWhiskerCategoryDataset.getQ3Value(n, n2);
        Number number3 = boxAndWhiskerCategoryDataset.getMaxRegularValue(n, n2);
        Number number4 = boxAndWhiskerCategoryDataset.getMinRegularValue(n, n2);
        if (number != null && number2 != null && number3 != null && number4 != null) {
            double d12 = valueAxis.translateValueToJava2D(number.doubleValue(), rectangle2D, rectangleEdge);
            d3 = valueAxis.translateValueToJava2D(number2.doubleValue(), rectangle2D, rectangleEdge);
            d2 = valueAxis.translateValueToJava2D(number3.doubleValue(), rectangle2D, rectangleEdge);
            d = valueAxis.translateValueToJava2D(number4.doubleValue(), rectangle2D, rectangleEdge);
            if (d2 < d12 && d2 < d3) {
                graphics2D.draw(new Line2D.Double(d9 + this.boxWidth / 2.0, d2, d9 + this.boxWidth / 2.0, Math.max(d12, d3)));
                graphics2D.draw(new Line2D.Double(d9, d2, d9 + this.boxWidth, d2));
            }
            if (d > d12 && d > d3) {
                graphics2D.draw(new Line2D.Double(d9 + this.boxWidth / 2.0, d, d9 + this.boxWidth / 2.0, Math.min(d12, d3)));
                graphics2D.draw(new Line2D.Double(d9, d, d9 + this.boxWidth, d));
            }
            cloneable = new Rectangle2D.Double(d9, Math.min(d12, d3), this.boxWidth, Math.abs(d12 - d3));
            graphics2D.fill((Shape)((Object)cloneable));
            graphics2D.draw((Shape)((Object)cloneable));
        }
        graphics2D.setPaint(this.artifactPaint);
        Number number5 = boxAndWhiskerCategoryDataset.getMeanValue(n, n2);
        if (number5 != null) {
            d5 = valueAxis.translateValueToJava2D(number5.doubleValue(), rectangle2D, rectangleEdge);
            d11 = this.boxWidth / 4.0;
            serializable = new Ellipse2D.Double(d9 + d11, d5 - d11, d11 * 2.0, d11 * 2.0);
            graphics2D.fill((Shape)((Object)serializable));
            graphics2D.draw((Shape)((Object)serializable));
        }
        if ((serializable = boxAndWhiskerCategoryDataset.getMedianValue(n, n2)) != null) {
            d3 = valueAxis.translateValueToJava2D(serializable.doubleValue(), rectangle2D, rectangleEdge);
            graphics2D.draw(new Line2D.Double(d9, d3, d9 + this.boxWidth, d3));
        }
        d3 = valueAxis.translateValueToJava2D(valueAxis.getUpperBound(), rectangle2D, rectangleEdge) + d11;
        d2 = valueAxis.translateValueToJava2D(valueAxis.getLowerBound(), rectangle2D, rectangleEdge) - d11;
        graphics2D.setPaint(paint);
        d = this.boxWidth / 3.0;
        cloneable = new ArrayList();
        OutlierListCollection outlierListCollection = new OutlierListCollection();
        List list = boxAndWhiskerCategoryDataset.getOutliers(n, n2);
        for (int i = 0; i < list.size(); ++i) {
            double d13 = ((Number)list.get(i)).doubleValue();
            if (d13 > boxAndWhiskerCategoryDataset.getMaxOutlier(n, n2).doubleValue()) {
                outlierListCollection.setHighFarOut(true);
            } else if (d13 < boxAndWhiskerCategoryDataset.getMinOutlier(n, n2).doubleValue()) {
                outlierListCollection.setLowFarOut(true);
            } else if (d13 > boxAndWhiskerCategoryDataset.getMaxRegularValue(n, n2).doubleValue()) {
                d4 = valueAxis.translateValueToJava2D(d13, rectangle2D, rectangleEdge);
                cloneable.add(new Outlier(d9 + this.boxWidth / 2.0, d4, d));
            } else if (d13 < boxAndWhiskerCategoryDataset.getMinRegularValue(n, n2).doubleValue()) {
                d4 = valueAxis.translateValueToJava2D(d13, rectangle2D, rectangleEdge);
                cloneable.add(new Outlier(d9 + this.boxWidth / 2.0, d4, d));
            }
            Collections.sort(cloneable);
        }
        Iterator iterator = cloneable.iterator();
        while (iterator.hasNext()) {
            Outlier outlier = (Outlier)iterator.next();
            outlierListCollection.add(outlier);
        }
        iterator = outlierListCollection.iterator();
        while (iterator.hasNext()) {
            OutlierList outlierList = (OutlierList)iterator.next();
            Outlier outlier = outlierList.getAveragedOutlier();
            Point2D point2D = outlier.getPoint();
            if (outlierList.isMultiple()) {
                this.drawMultipleEllipse(point2D, this.boxWidth, d, graphics2D);
                continue;
            }
            this.drawEllipse(point2D, d, graphics2D);
        }
        if (outlierListCollection.isHighFarOut()) {
            this.drawHighFarOut(d11 / 2.0, graphics2D, d9 + this.boxWidth / 2.0, d3);
        }
        if (outlierListCollection.isLowFarOut()) {
            this.drawLowFarOut(d11 / 2.0, graphics2D, d9 + this.boxWidth / 2.0, d2);
        }
    }

    private void drawEllipse(Point2D point2D, double d, Graphics2D graphics2D) {
        Ellipse2D.Double double_ = new Ellipse2D.Double(point2D.getX() + d / 2.0, point2D.getY(), d, d);
        graphics2D.draw(double_);
    }

    private void drawMultipleEllipse(Point2D point2D, double d, double d2, Graphics2D graphics2D) {
        Ellipse2D.Double double_ = new Ellipse2D.Double(point2D.getX() - d / 2.0 + d2, point2D.getY(), d2, d2);
        Ellipse2D.Double double_2 = new Ellipse2D.Double(point2D.getX() + d / 2.0, point2D.getY(), d2, d2);
        graphics2D.draw(double_);
        graphics2D.draw(double_2);
    }

    private void drawHighFarOut(double d, Graphics2D graphics2D, double d2, double d3) {
        double d4 = d * 2.0;
        graphics2D.draw(new Line2D.Double(d2 - d4, d3 + d4, d2 + d4, d3 + d4));
        graphics2D.draw(new Line2D.Double(d2 - d4, d3 + d4, d2, d3));
        graphics2D.draw(new Line2D.Double(d2 + d4, d3 + d4, d2, d3));
    }

    private void drawLowFarOut(double d, Graphics2D graphics2D, double d2, double d3) {
        double d4 = d * 2.0;
        graphics2D.draw(new Line2D.Double(d2 - d4, d3 - d4, d2 + d4, d3 - d4));
        graphics2D.draw(new Line2D.Double(d2 - d4, d3 - d4, d2, d3));
        graphics2D.draw(new Line2D.Double(d2 + d4, d3 - d4, d2, d3));
    }
}

