/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import org.jfree.data.AbstractDataset;
import org.jfree.data.DefaultKeyedValues;
import org.jfree.data.KeyedValues;
import org.jfree.data.PieDataset;

public class DefaultPieDataset
extends AbstractDataset
implements PieDataset,
Cloneable,
Serializable {
    private DefaultKeyedValues data = new DefaultKeyedValues();

    public DefaultPieDataset() {
    }

    public DefaultPieDataset(KeyedValues keyedValues) {
        for (int i = 0; i < keyedValues.getItemCount(); ++i) {
            this.data.addValue(keyedValues.getKey(i), keyedValues.getValue(i));
        }
    }

    public int getItemCount() {
        return this.data.getItemCount();
    }

    public List getKeys() {
        return Collections.unmodifiableList(this.data.getKeys());
    }

    public Comparable getKey(int n) {
        Comparable comparable = null;
        if (this.getItemCount() > n) {
            comparable = this.data.getKey(n);
        }
        return comparable;
    }

    public int getIndex(Comparable comparable) {
        return this.data.getIndex(comparable);
    }

    public Number getValue(int n) {
        Number number = null;
        if (this.getItemCount() > n) {
            number = this.data.getValue(n);
        }
        return number;
    }

    public Number getValue(Comparable comparable) {
        if (comparable == null) {
            throw new IllegalArgumentException("PieDataset: null key not allowed.");
        }
        return this.data.getValue(comparable);
    }

    public void setValue(Comparable comparable, Number number) {
        this.data.setValue(comparable, number);
        this.fireDatasetChanged();
    }

    public void setValue(Comparable comparable, double d) {
        this.setValue(comparable, new Double(d));
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object instanceof PieDataset) {
            PieDataset pieDataset = (PieDataset)object;
            int n = this.getItemCount();
            for (int i = 0; i < n; ++i) {
                Comparable comparable;
                Comparable comparable2 = this.getKey(i);
                if (comparable2.equals(comparable = pieDataset.getKey(i))) {
                    Number number = this.getValue(i);
                    Number number2 = pieDataset.getValue(i);
                    if (!(number == null ? number2 != null : !number.equals(number2))) continue;
                    return false;
                }
                return false;
            }
            return true;
        }
        return false;
    }

    public Object clone() throws CloneNotSupportedException {
        DefaultPieDataset defaultPieDataset = (DefaultPieDataset)super.clone();
        defaultPieDataset.data = (DefaultKeyedValues)this.data.clone();
        return defaultPieDataset;
    }
}

