/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data;

import java.util.Comparator;
import org.jfree.data.KeyedValue;
import org.jfree.data.KeyedValueComparatorType;
import org.jfree.util.SortOrder;

public class KeyedValueComparator
implements Comparator {
    private KeyedValueComparatorType type;
    private SortOrder order;

    public KeyedValueComparator(KeyedValueComparatorType keyedValueComparatorType, SortOrder sortOrder) {
        this.type = keyedValueComparatorType;
        this.order = sortOrder;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int compare(Object object, Object object2) {
        if (object2 == null) {
            return -1;
        }
        if (object == null) {
            return 1;
        }
        int n = 0;
        KeyedValue keyedValue = (KeyedValue)object;
        KeyedValue keyedValue2 = (KeyedValue)object2;
        if (this.type == KeyedValueComparatorType.BY_KEY) {
            if (this.order.equals((Object)SortOrder.ASCENDING)) {
                return keyedValue.getKey().compareTo(keyedValue2.getKey());
            }
            if (!this.order.equals((Object)SortOrder.DESCENDING)) throw new IllegalArgumentException("KeyedValueComparator.compare(...) : unrecognised sort order.");
            return keyedValue2.getKey().compareTo(keyedValue.getKey());
        }
        if (this.type != KeyedValueComparatorType.BY_VALUE) throw new IllegalArgumentException("KeyedValueComparator.compare(...) : unrecognised type.");
        Number number = keyedValue.getValue();
        Number number2 = keyedValue2.getValue();
        if (number2 == null) {
            return -1;
        }
        if (number == null) {
            return 1;
        }
        double d = number.doubleValue();
        double d2 = number2.doubleValue();
        if (this.order.equals((Object)SortOrder.ASCENDING)) {
            if (d > d2) {
                return 1;
            }
            if (!(d < d2)) return 0;
            return -1;
        }
        if (!this.order.equals((Object)SortOrder.DESCENDING)) throw new IllegalArgumentException("KeyedValueComparator.compare(...) : unrecognised sort order.");
        if (d > d2) {
            return -1;
        }
        if (!(d < d2)) return 0;
        return 1;
    }
}

