/*
 * Decompiled with CFR 0.152.
 */
package jsynoptic.builtin;

import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.RectangularShape;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ResourceBundle;
import jsynoptic.builtin.Abstract2DShape;
import jsynoptic.builtin.ui.EllipsePropertiesPanel;
import simtools.data.DataException;
import simtools.data.DataSource;
import simtools.data.DataSourcePool;
import simtools.data.UnsupportedOperation;
import simtools.shapes.AbstractShape;
import simtools.ui.JPropertiesPanel;
import simtools.ui.ResourceFinder;

public class EllipseShape
extends Abstract2DShape {
    static final long serialVersionUID = 6256410262456113545L;
    public static ResourceBundle resources = ResourceFinder.get(class$jsynoptic$builtin$EllipseShape == null ? (class$jsynoptic$builtin$EllipseShape = EllipseShape.class$("jsynoptic.builtin.EllipseShape")) : class$jsynoptic$builtin$EllipseShape);
    public static final int ANGLE_UNIT_DEGREE = 0;
    public static final int ANGLE_UNIT_RADIAN = 1;
    public static final int TYPE_FULL = 0;
    public static final int TYPE_PIE = 1;
    public static final int TYPE_CHORD = 2;
    public static final int TYPE_OPEN = 3;
    protected int startUnit;
    protected int endUnit;
    protected transient double start;
    protected transient double end;
    protected transient Shape ellipse;
    protected transient DataSource startAngleSource;
    protected transient DataSource endAngleSource;
    protected transient long startAngleSourceIndex;
    protected transient long endAngleSourceIndex;
    protected transient boolean dirtyArc = false;
    static /* synthetic */ Class class$jsynoptic$builtin$EllipseShape;

    public EllipseShape(int n, int n2, int n3, int n4) {
        super(n, n2, n3, n4);
        this.ratio = (double)this._w / (double)this._h;
        this.allowResize = true;
        this.fixedRatio = false;
        this.ellipse = new Ellipse2D.Double(n, n2 - this._h, n3 - 1, n4 - 1);
        this.start = 0.0;
        this.end = 0.0;
    }

    protected Shape getDelegateShape() {
        return this.ellipse;
    }

    public void translate(int n, int n2) {
        super.translate(n, n2);
        if (this.ellipse instanceof Ellipse2D.Double) {
            Ellipse2D.Double double_ = (Ellipse2D.Double)this.ellipse;
            double_.x += (double)n;
            double_.y += (double)n2;
            return;
        }
        if (this.ellipse instanceof Arc2D.Double) {
            Arc2D.Double double_ = (Arc2D.Double)this.ellipse;
            double_.x += (double)n;
            double_.y += (double)n2;
            return;
        }
    }

    public void setAnchor(int n, int n2) {
        super.setAnchor(n, n2);
        if (this.ellipse instanceof Ellipse2D.Double) {
            Ellipse2D.Double double_ = (Ellipse2D.Double)this.ellipse;
            double_.x = n;
            double_.y = n2 - this._h;
            return;
        }
        if (this.ellipse instanceof Arc2D.Double) {
            Arc2D.Double double_ = (Arc2D.Double)this.ellipse;
            double_.x = n;
            double_.y = n2 - this._h;
            return;
        }
    }

    public void resize(int n, int n2) {
        RectangularShape rectangularShape;
        super.resize(n, n2);
        if (this.ellipse instanceof Ellipse2D.Double) {
            rectangularShape = (Ellipse2D.Double)this.ellipse;
            rectangularShape.x = this._ox;
            rectangularShape.y = this._oy - this._h;
            rectangularShape.height = this._h - 1;
            rectangularShape.width = this._w - 1;
        }
        if (this.ellipse instanceof Arc2D.Double) {
            rectangularShape = (Arc2D.Double)this.ellipse;
            ((Arc2D.Double)rectangularShape).x = this._ox;
            ((Arc2D.Double)rectangularShape).y = this._oy - this._h;
            ((Arc2D.Double)rectangularShape).height = this._h - 1;
            ((Arc2D.Double)rectangularShape).width = this._w - 1;
        }
    }

    public JPropertiesPanel createPanel() {
        return new EllipsePropertiesPanel();
    }

    protected boolean updateArc() {
        double d;
        double d2;
        if (!(this.ellipse instanceof Arc2D.Double)) {
            return false;
        }
        Arc2D.Double double_ = (Arc2D.Double)this.ellipse;
        if (this.startAngleSource != null) {
            try {
                d2 = this.startAngleSource.getDoubleValue(this.startAngleSourceIndex);
                if (this.startUnit == 1) {
                    d2 = Math.toDegrees(d2);
                }
            }
            catch (DataException dataException) {
                d2 = double_.start;
            }
        } else {
            d2 = double_.start;
        }
        if (this.endAngleSource != null) {
            try {
                d = this.endAngleSource.getDoubleValue(this.endAngleSourceIndex);
                if (this.endUnit == 1) {
                    d = Math.toDegrees(d);
                }
            }
            catch (DataException dataException) {
                d = double_.start + double_.extent;
            }
        } else {
            d = double_.start + double_.extent;
        }
        this.start = d2;
        if (this.startUnit == 1) {
            this.start = Math.toRadians(d2);
        }
        this.end = d;
        if (this.endUnit == 1) {
            this.end = Math.toRadians(d);
        }
        if (double_.start == d2 && d == double_.start + double_.extent) {
            return false;
        }
        this.ellipse = new Arc2D.Double(this._ox, this._oy - this._h, this._w - 1, this._h - 1, d2, d - d2, double_.getArcType());
        return true;
    }

    public void notificationEnd(Object object) {
        if (this.dirtyArc) {
            this.dirty |= this.updateArc();
            this.dirtyArc = false;
        }
        super.notificationEnd(object);
    }

    public void DataSourceValueChanged(DataSource dataSource, long l, long l2) {
        if (dataSource.equals(this.startAngleSource) && this.startAngleSourceIndex >= l && this.startAngleSourceIndex <= l2) {
            this.dirtyArc = true;
        }
        if (dataSource.equals(this.endAngleSource) && this.endAngleSourceIndex >= l && this.endAngleSourceIndex <= l2) {
            this.dirtyArc = true;
        }
        super.DataSourceValueChanged(dataSource, l, l2);
    }

    public void DataSourceIndexRangeChanged(DataSource dataSource, long l, long l2) {
        if (dataSource.equals(this.startAngleSource)) {
            this.startAngleSourceIndex = l2;
            this.dirtyArc = true;
        }
        if (dataSource.equals(this.endAngleSource)) {
            this.endAngleSourceIndex = l2;
            this.dirtyArc = true;
        }
        super.DataSourceIndexRangeChanged(dataSource, l, l2);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        if (this.ellipse instanceof Ellipse2D.Double) {
            objectOutputStream.writeInt(0);
        } else if (this.ellipse instanceof Arc2D.Double) {
            Arc2D.Double double_ = (Arc2D.Double)this.ellipse;
            objectOutputStream.writeInt(1);
            objectOutputStream.writeDouble(double_.start);
            objectOutputStream.writeDouble(double_.extent);
            objectOutputStream.writeInt(double_.getArcType());
        }
        DataSourcePool.global.writeDataSource(objectOutputStream, this.startAngleSource);
        DataSourcePool.global.writeDataSource(objectOutputStream, this.endAngleSource);
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        switch (objectInputStream.readInt()) {
            case 0: {
                this.ellipse = new Ellipse2D.Double(this._ox, this._oy - this._h, this._w - 1, this._h - 1);
                break;
            }
            case 1: {
                double d = objectInputStream.readDouble();
                double d2 = objectInputStream.readDouble();
                int n = objectInputStream.readInt();
                this.ellipse = new Arc2D.Double(this._ox, this._oy - this._h, this._w - 1, this._h - 1, d, d2, n);
                this.start = d;
                if (this.startUnit == 1) {
                    this.start = Math.toRadians(d);
                }
                this.end = d + d2;
                if (this.endUnit != 1) break;
                this.end = Math.toRadians(d + d2);
            }
        }
        this.startAngleSource = DataSourcePool.global.readDataSource(objectInputStream);
        if (this.startAngleSource != null) {
            try {
                this.startAngleSource.addListener(this);
                this.startAngleSource.addEndNotificationListener(this);
                this.startAngleSourceIndex = this.startAngleSource.getLastIndex();
            }
            catch (UnsupportedOperation unsupportedOperation) {
                this.startAngleSourceIndex = 0L;
            }
        }
        this.endAngleSource = DataSourcePool.global.readDataSource(objectInputStream);
        if (this.endAngleSource != null) {
            try {
                this.endAngleSource.addListener(this);
                this.endAngleSource.addEndNotificationListener(this);
                this.endAngleSourceIndex = this.endAngleSource.getLastIndex();
            }
            catch (UnsupportedOperation unsupportedOperation) {
                this.endAngleSourceIndex = 0L;
            }
        }
    }

    protected AbstractShape cloneShape() {
        EllipseShape ellipseShape = (EllipseShape)super.cloneShape();
        ellipseShape.ellipse = (Shape)((RectangularShape)this.ellipse).clone();
        if (ellipseShape.startAngleSource != null) {
            ellipseShape.startAngleSource.addEndNotificationListener(ellipseShape);
            ellipseShape.startAngleSource.addListener(ellipseShape);
        }
        if (ellipseShape.endAngleSource != null) {
            ellipseShape.endAngleSource.addEndNotificationListener(ellipseShape);
            ellipseShape.endAngleSource.addListener(ellipseShape);
        }
        return ellipseShape;
    }

    public void setPropertyValue(String string, Object object) {
        super.setPropertyValue(string, object);
        if (string.equalsIgnoreCase("ELLIPSE_TYPE")) {
            if (object instanceof Integer) {
                int n = (Integer)object;
                if (n == 0) {
                    this.ellipse = new Ellipse2D.Double(this._ox, this._oy - this._h, this._w - 1, this._h - 1);
                    if (this.startAngleSource != null) {
                        this.startAngleSource.removeListener(this);
                    }
                    this.startAngleSource = null;
                    if (this.endAngleSource != null) {
                        this.endAngleSource.removeListener(this);
                    }
                    this.endAngleSource = null;
                } else {
                    double d = this.start;
                    if (this.startUnit == 1) {
                        d = Math.toDegrees(this.start);
                    }
                    double d2 = this.end;
                    if (this.endUnit == 1) {
                        d2 = Math.toDegrees(this.end);
                    }
                    switch (n) {
                        case 1: {
                            this.ellipse = new Arc2D.Double(this._ox, this._oy - this._h, this._w - 1, this._h - 1, d, d2 - d, 2);
                            break;
                        }
                        case 2: {
                            this.ellipse = new Arc2D.Double(this._ox, this._oy - this._h, this._w - 1, this._h - 1, d, d2 - d, 1);
                            break;
                        }
                        case 3: {
                            this.ellipse = new Arc2D.Double(this._ox, this._oy - this._h, this._w - 1, this._h - 1, d, d2 - d, 0);
                        }
                    }
                }
            }
        } else if (string.equalsIgnoreCase("START_UNIT")) {
            if (object instanceof Integer) {
                this.startUnit = (Integer)object;
            }
        } else if (string.equalsIgnoreCase("END_UNIT")) {
            if (object instanceof Integer) {
                this.endUnit = (Integer)object;
            }
        } else if (string.equalsIgnoreCase("START_ANGLE")) {
            if (object instanceof Double) {
                this.start = (Double)object;
            }
        } else if (string.equalsIgnoreCase("END_ANGLE")) {
            if (object instanceof Double) {
                this.end = (Double)object;
            }
        } else if (string.equalsIgnoreCase("START_ANGLE_SOURCE")) {
            if (this.startAngleSource != null) {
                this.startAngleSource.removeListener(this);
                this.startAngleSource.removeEndNotificationListener(this);
                this.startAngleSource = null;
            }
            if (object instanceof DataSource) {
                this.startAngleSource = (DataSource)object;
                try {
                    this.startAngleSourceIndex = this.startAngleSource.getLastIndex();
                }
                catch (UnsupportedOperation unsupportedOperation) {
                    this.startAngleSourceIndex = 0L;
                }
                try {
                    this.start = this.startAngleSource.getDoubleValue(this.startAngleSourceIndex);
                }
                catch (DataException dataException) {
                    // empty catch block
                }
                this.startAngleSource.addListener(this);
                this.startAngleSource.addEndNotificationListener(this);
            }
        } else if (string.equalsIgnoreCase("END_ANGLE_SOURCE")) {
            if (this.endAngleSource != null) {
                this.endAngleSource.removeListener(this);
                this.endAngleSource.removeEndNotificationListener(this);
                this.endAngleSource = null;
            }
            if (object instanceof DataSource) {
                this.endAngleSource = (DataSource)object;
                try {
                    this.endAngleSourceIndex = this.endAngleSource.getLastIndex();
                }
                catch (UnsupportedOperation unsupportedOperation) {
                    this.endAngleSourceIndex = 0L;
                }
                try {
                    this.end = this.endAngleSource.getDoubleValue(this.endAngleSourceIndex);
                }
                catch (DataException dataException) {
                    // empty catch block
                }
                this.endAngleSource.addListener(this);
                this.endAngleSource.addEndNotificationListener(this);
            }
        }
    }

    public Object getPropertyValue(String string) {
        Object object = super.getPropertyValue(string);
        if (string.equalsIgnoreCase("ELLIPSE_TYPE")) {
            if (this.ellipse instanceof Ellipse2D.Double) {
                object = new Integer(0);
            } else {
                Arc2D.Double double_ = (Arc2D.Double)this.ellipse;
                switch (double_.getArcType()) {
                    case 2: {
                        object = new Integer(1);
                        break;
                    }
                    case 1: {
                        object = new Integer(2);
                        break;
                    }
                    case 0: {
                        object = new Integer(3);
                    }
                }
            }
        } else if (string.equalsIgnoreCase("START_UNIT")) {
            object = new Integer(this.startUnit);
        } else if (string.equalsIgnoreCase("END_UNIT")) {
            object = new Integer(this.endUnit);
        } else if (string.equalsIgnoreCase("START_ANGLE")) {
            try {
                Arc2D.Double double_ = (Arc2D.Double)this.ellipse;
                this.start = double_.start;
                if (this.startUnit == 1) {
                    this.start = Math.toRadians(this.start);
                }
                object = new Double(this.start);
            }
            catch (ClassCastException classCastException) {
                object = null;
            }
        } else if (string.equalsIgnoreCase("END_ANGLE")) {
            try {
                Arc2D.Double double_ = (Arc2D.Double)this.ellipse;
                this.end = double_.start + double_.extent;
                if (this.endUnit == 1) {
                    this.end = Math.toRadians(this.end);
                }
                object = new Double(this.end);
            }
            catch (ClassCastException classCastException) {
                object = null;
            }
        } else if (string.equalsIgnoreCase("START_ANGLE_SOURCE")) {
            object = this.startAngleSource;
        } else if (string.equalsIgnoreCase("END_ANGLE_SOURCE")) {
            object = this.endAngleSource;
        }
        return object;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

