/*
 * Decompiled with CFR 0.152.
 */
package jsynoptic.builtin;

import java.awt.Rectangle;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Iterator;
import java.util.ResourceBundle;
import java.util.Vector;
import jsynoptic.builtin.TextArrayShape;
import jsynoptic.builtin.TextShape;
import jsynoptic.builtin.ui.HistoryPropertiesPanel;
import jsynoptic.builtin.ui.TextPropertiesPanel;
import simtools.data.DataSource;
import simtools.shapes.AbstractShape;
import simtools.ui.JPropertiesPanel;
import simtools.ui.ResourceFinder;

public class HistoryShape
extends TextArrayShape {
    static final long serialVersionUID = 5471834643284146991L;
    public static ResourceBundle resources = ResourceFinder.get(class$jsynoptic$builtin$HistoryShape == null ? (class$jsynoptic$builtin$HistoryShape = HistoryShape.class$("jsynoptic.builtin.HistoryShape")) : class$jsynoptic$builtin$HistoryShape, TextArrayShape.resources);
    static /* synthetic */ Class class$jsynoptic$builtin$HistoryShape;

    public HistoryShape() {
        this(5);
    }

    public HistoryShape(int n) {
        this(n, 100, 50);
    }

    public HistoryShape(int n, int n2, int n3) {
        this._w = n2;
        if (this._w < 40) {
            this._w = 40;
        }
        if (n3 < 20) {
            n3 = 20;
        }
        this._y = this._h = n3 * n;
        this.cells = new Vector();
        for (int i = 0; i < n; ++i) {
            HookedTextShape hookedTextShape = new HookedTextShape(resources.getString("Text"), n2, n3, false);
            hookedTextShape.owner = this;
            hookedTextShape.setAnchor(this._ox, this._oy + (i + 1) * n3);
            this.cells.add(hookedTextShape);
        }
        if (n > 0) {
            ((HookedTextShape)this.cells.get(0)).setDelegateEndNotificationListener(this);
        }
    }

    public String[] getActions(double d, double d2, Object object, int n) {
        if (n == 3) {
            return null;
        }
        if (n == 4) {
            return null;
        }
        if (n == 5) {
            return null;
        }
        if (n == 1) {
            // empty if block
        }
        Vector<String> vector = new Vector<String>();
        vector.add(resources.getString("Properties..."));
        if (object instanceof DataSource) {
            vector.add(resources.getString("SetSource"));
        }
        return vector.toArray(new String[vector.size()]);
    }

    public JPropertiesPanel createPanel() {
        return new HistoryPropertiesPanel((TextPropertiesPanel)((HookedTextShape)this.cells.get(0)).createPanel());
    }

    public boolean doAction(double d, double d2, Object object, String string) {
        if (string.equals(resources.getString("SetSource"))) {
            HookedTextShape hookedTextShape = (HookedTextShape)this.cells.get(0);
            hookedTextShape.propagate();
            hookedTextShape.setSource((DataSource)object);
            return true;
        }
        if (string.equals(resources.getString("Properties..."))) {
            return super.doAction(d, d2, object, string);
        }
        return false;
    }

    public boolean canDoAction(double d, double d2, Object object, String string, int n) {
        return true;
    }

    public void notificationEnd(Object object) {
        if (this.cells.size() > 0) {
            ((HookedTextShape)this.cells.get(0)).notificationEnd(object);
        }
        Rectangle rectangle = null;
        if (this.forceSameFont) {
            rectangle = this.getBounds();
            if (this.autoresize) {
                this.adjustSize();
                rectangle.add(this.getBounds());
            } else {
                this.unifyFonts();
            }
        }
        this.notifyChange(rectangle);
    }

    protected AbstractShape cloneShape() {
        HistoryShape historyShape = (HistoryShape)super.cloneShape();
        Iterator iterator = historyShape.cells.iterator();
        while (iterator.hasNext()) {
            HookedTextShape hookedTextShape = (HookedTextShape)iterator.next();
            hookedTextShape.owner = historyShape;
            hookedTextShape.setDelegateEndNotificationListener(hookedTextShape);
        }
        if (historyShape.cells.size() > 0) {
            ((HookedTextShape)historyShape.cells.get(0)).setDelegateEndNotificationListener(historyShape);
        }
        return historyShape;
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        if (this.forceSameFont) {
            this.unifyFonts();
        }
        Iterator iterator = this.cells.iterator();
        while (iterator.hasNext()) {
            HookedTextShape hookedTextShape = (HookedTextShape)iterator.next();
            hookedTextShape.owner = this;
            hookedTextShape.setDelegateEndNotificationListener(hookedTextShape);
        }
        if (this.cells.size() > 0) {
            ((HookedTextShape)this.cells.get(0)).setDelegateEndNotificationListener(this);
        }
    }

    public boolean addDataSource(DataSource dataSource) {
        HookedTextShape hookedTextShape = (HookedTextShape)this.cells.get(0);
        hookedTextShape.propagate();
        hookedTextShape.setSource(dataSource);
        this.notifyChange();
        return true;
    }

    public void setPropertyValue(String string, Object object) {
        super.setPropertyValue(string, object);
        if (string.equalsIgnoreCase("HISTORY_SIZE") && object instanceof Integer) {
            int n = (Integer)object;
            int n2 = this.cells.size();
            if (n >= 0 && n != n2) {
                int n3;
                int n4 = n3 = this.cells.size() == 0 ? 20 : this._h / this.cells.size();
                if (n3 < 20) {
                    n3 = 20;
                }
                if (n2 > n) {
                    for (int i = n2; i > n; --i) {
                        this.cells.remove(i - 1);
                    }
                } else {
                    for (int i = n2; i < n; ++i) {
                        HookedTextShape hookedTextShape = new HookedTextShape(resources.getString("Text"), this._w, n3, false);
                        hookedTextShape.owner = this;
                        hookedTextShape.setAnchor(this._ox, this._oy + (i + 1) * n3);
                        this.cells.add(hookedTextShape);
                    }
                }
                if (n > 0) {
                    ((HookedTextShape)this.cells.get(0)).setDelegateEndNotificationListener(this);
                }
                this._y = this._h = n3 * n;
            }
        }
    }

    public Object getPropertyValue(String string) {
        Object object = super.getPropertyValue(string);
        if (string.equalsIgnoreCase("HISTORY_SIZE")) {
            object = new Integer(this.cells.size());
        }
        return object;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class HookedTextShape
    extends TextShape {
        static final long serialVersionUID = 1319437895774180799L;
        protected transient HistoryShape owner = null;

        public HookedTextShape(String string, int n, int n2, boolean bl) {
            super(string, n, n2, bl);
        }

        public void propagate() {
            TextShape textShape = (TextShape)this.owner.cells.lastElement();
            for (int i = this.owner.cells.size() - 1; i > 0; --i) {
                TextShape textShape2 = (TextShape)this.owner.cells.get(i - 1);
                textShape.text = textShape2.text;
                textShape.drawColor = textShape2.drawColor;
                textShape.drawDynamicColor = textShape2.drawDynamicColor;
                textShape.fillColor = textShape2.fillColor;
                textShape.fillDynamicColor = textShape2.fillDynamicColor;
                textShape.textColor = textShape2.textColor;
                textShape.textDynamicColor = textShape2.textDynamicColor;
                textShape.baseline = textShape2.baseline;
                textShape.currentFont = textShape2.currentFont;
                textShape = textShape2;
            }
        }

        public void notificationEnd(Object object) {
            this.propagate();
            super.notificationEnd(object);
        }
    }
}

