/*
 * Decompiled with CFR 0.152.
 */
package simtools.data.buffer;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import simtools.data.DataException;
import simtools.data.ValueProvider;

public abstract class Buffer
extends ValueProvider
implements Cloneable,
Serializable {
    static final long serialVersionUID = -3321655645846219948L;
    protected transient ValueProvider provider;
    protected transient ObjectManipulator objectManipulator;
    protected transient ByteManipulator byteManipulator;
    protected transient ShortManipulator shortManipulator;
    protected transient IntegerManipulator intManipulator;
    protected transient LongManipulator longManipulator;
    protected transient FloatManipulator floatManipulator;
    protected transient DoubleManipulator doubleManipulator;
    protected transient long startIndex;
    protected transient long endIndex;

    public Buffer() {
        this(null);
    }

    public Buffer(int n) {
        this(n, null);
    }

    public Buffer(ValueProvider valueProvider) {
        this(7, null);
    }

    public Buffer(int n, ValueProvider valueProvider) {
        this.setProvider(valueProvider);
        this.startIndex = -1L;
        this.endIndex = -2L;
        this.kind = n;
    }

    public void setProvider(ValueProvider valueProvider) {
        this.provider = valueProvider;
    }

    public ValueProvider getProvider() {
        return this.provider;
    }

    public boolean setValue(long l, Object object) throws DataException {
        if (this.kind != 7) {
            return false;
        }
        if (this.objectManipulator == null) {
            this.objectManipulator = (ObjectManipulator)this.createManipulator(this.kind);
        }
        if (this.objectManipulator != null) {
            return this.objectManipulator.setValue(l, object);
        }
        return false;
    }

    public void setSlice(long l, long l2) {
        switch (this.kind) {
            case 1: {
                if (this.byteManipulator == null) {
                    this.byteManipulator = (ByteManipulator)this.createManipulator(this.kind);
                }
                if (this.byteManipulator != null) {
                    this.byteManipulator.setSlice(l, l2);
                }
                return;
            }
            case 2: {
                if (this.shortManipulator == null) {
                    this.shortManipulator = (ShortManipulator)this.createManipulator(this.kind);
                }
                if (this.shortManipulator != null) {
                    this.shortManipulator.setSlice(l, l2);
                }
                return;
            }
            case 3: {
                if (this.intManipulator == null) {
                    this.intManipulator = (IntegerManipulator)this.createManipulator(this.kind);
                }
                if (this.intManipulator != null) {
                    this.intManipulator.setSlice(l, l2);
                }
                return;
            }
            case 4: {
                if (this.longManipulator == null) {
                    this.longManipulator = (LongManipulator)this.createManipulator(this.kind);
                }
                if (this.longManipulator != null) {
                    this.longManipulator.setSlice(l, l2);
                }
                return;
            }
            case 5: {
                if (this.floatManipulator == null) {
                    this.floatManipulator = (FloatManipulator)this.createManipulator(this.kind);
                }
                if (this.floatManipulator != null) {
                    this.floatManipulator.setSlice(l, l2);
                }
                return;
            }
            case 6: {
                if (this.doubleManipulator == null) {
                    this.doubleManipulator = (DoubleManipulator)this.createManipulator(this.kind);
                }
                if (this.doubleManipulator != null) {
                    this.doubleManipulator.setSlice(l, l2);
                }
                return;
            }
            case 7: {
                if (this.objectManipulator == null) {
                    this.objectManipulator = (ObjectManipulator)this.createManipulator(this.kind);
                }
                if (this.objectManipulator != null) {
                    this.objectManipulator.setSlice(l, l2);
                }
                return;
            }
        }
    }

    public Object clone() {
        try {
            Buffer buffer = (Buffer)super.clone();
            if (this.objectManipulator != null) {
                buffer.objectManipulator = (ObjectManipulator)this.objectManipulator.clone();
            }
            if (this.byteManipulator != null) {
                buffer.byteManipulator = (ByteManipulator)this.byteManipulator.clone();
            }
            if (this.shortManipulator != null) {
                buffer.shortManipulator = (ShortManipulator)this.shortManipulator.clone();
            }
            if (this.intManipulator != null) {
                buffer.intManipulator = (IntegerManipulator)this.intManipulator.clone();
            }
            if (this.longManipulator != null) {
                buffer.longManipulator = (LongManipulator)this.longManipulator.clone();
            }
            if (this.floatManipulator != null) {
                buffer.floatManipulator = (FloatManipulator)this.floatManipulator.clone();
            }
            if (this.doubleManipulator != null) {
                buffer.doubleManipulator = (DoubleManipulator)this.doubleManipulator.clone();
            }
            return buffer;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public long getEndIndex() {
        return this.endIndex;
    }

    public long getStartIndex() {
        return this.startIndex;
    }

    public Object getValue(long l) throws DataException {
        if (this.kind == 1) {
            if (this.byteManipulator == null) {
                this.byteManipulator = (ByteManipulator)this.createManipulator(this.kind);
            }
            if (this.byteManipulator != null) {
                return new Byte(this.byteManipulator.getValue(l));
            }
        } else if (this.kind == 2) {
            if (this.shortManipulator == null) {
                this.shortManipulator = (ShortManipulator)this.createManipulator(this.kind);
            }
            if (this.shortManipulator != null) {
                return new Short(this.shortManipulator.getValue(l));
            }
        } else if (this.kind == 3) {
            if (this.intManipulator == null) {
                this.intManipulator = (IntegerManipulator)this.createManipulator(this.kind);
            }
            if (this.intManipulator != null) {
                return new Integer(this.intManipulator.getValue(l));
            }
        } else if (this.kind == 4) {
            if (this.longManipulator == null) {
                this.longManipulator = (LongManipulator)this.createManipulator(this.kind);
            }
            if (this.longManipulator != null) {
                return new Long(this.longManipulator.getValue(l));
            }
        } else if (this.kind == 5) {
            if (this.floatManipulator == null) {
                this.floatManipulator = (FloatManipulator)this.createManipulator(this.kind);
            }
            if (this.floatManipulator != null) {
                return new Float(this.floatManipulator.getValue(l));
            }
        } else if (this.kind == 6) {
            if (this.doubleManipulator == null) {
                this.doubleManipulator = (DoubleManipulator)this.createManipulator(this.kind);
            }
            if (this.doubleManipulator != null) {
                return new Double(this.doubleManipulator.getValue(l));
            }
        } else if (this.kind == 7) {
            if (this.objectManipulator == null) {
                this.objectManipulator = (ObjectManipulator)this.createManipulator(this.kind);
            }
            if (this.objectManipulator != null) {
                return this.objectManipulator.getValue(l);
            }
        }
        throw new DataException();
    }

    public byte getByteValue(long l) throws DataException {
        if (this.kind != 1) {
            return super.getByteValue(l);
        }
        if (this.byteManipulator == null) {
            this.byteManipulator = (ByteManipulator)this.createManipulator(this.kind);
        }
        if (this.byteManipulator != null) {
            return this.byteManipulator.getValue(l);
        }
        return super.getByteValue(l);
    }

    public boolean setByteValue(long l, byte by) throws DataException {
        if (this.kind != 1) {
            return false;
        }
        if (this.byteManipulator == null) {
            this.byteManipulator = (ByteManipulator)this.createManipulator(this.kind);
        }
        if (this.byteManipulator != null) {
            return this.byteManipulator.setValue(l, by);
        }
        return false;
    }

    public short getShortValue(long l) throws DataException {
        if (this.kind != 2) {
            return super.getShortValue(l);
        }
        if (this.shortManipulator == null) {
            this.shortManipulator = (ShortManipulator)this.createManipulator(this.kind);
        }
        if (this.shortManipulator != null) {
            return this.shortManipulator.getValue(l);
        }
        return super.getShortValue(l);
    }

    public boolean setShortValue(long l, short s) throws DataException {
        if (this.kind != 2) {
            return false;
        }
        if (this.shortManipulator == null) {
            this.shortManipulator = (ShortManipulator)this.createManipulator(this.kind);
        }
        if (this.shortManipulator != null) {
            return this.shortManipulator.setValue(l, s);
        }
        return false;
    }

    public int getIntegerValue(long l) throws DataException {
        if (this.kind != 3) {
            return super.getIntegerValue(l);
        }
        if (this.intManipulator == null) {
            this.intManipulator = (IntegerManipulator)this.createManipulator(this.kind);
        }
        if (this.intManipulator != null) {
            return this.intManipulator.getValue(l);
        }
        return super.getIntegerValue(l);
    }

    public boolean setIntegerValue(long l, int n) throws DataException {
        if (this.kind != 3) {
            return false;
        }
        if (this.intManipulator == null) {
            this.intManipulator = (IntegerManipulator)this.createManipulator(this.kind);
        }
        if (this.intManipulator != null) {
            return this.intManipulator.setValue(l, n);
        }
        return false;
    }

    public long getLongValue(long l) throws DataException {
        if (this.kind != 4) {
            return super.getLongValue(l);
        }
        if (this.longManipulator == null) {
            this.longManipulator = (LongManipulator)this.createManipulator(this.kind);
        }
        if (this.longManipulator != null) {
            return this.longManipulator.getValue(l);
        }
        return super.getLongValue(l);
    }

    public boolean setLongValue(long l, long l2) throws DataException {
        if (this.kind != 4) {
            return false;
        }
        if (this.longManipulator == null) {
            this.longManipulator = (LongManipulator)this.createManipulator(this.kind);
        }
        if (this.longManipulator != null) {
            return this.longManipulator.setValue(l, l2);
        }
        return false;
    }

    public float getFloatValue(long l) throws DataException {
        if (this.kind != 5) {
            return super.getFloatValue(l);
        }
        if (this.floatManipulator == null) {
            this.floatManipulator = (FloatManipulator)this.createManipulator(this.kind);
        }
        if (this.floatManipulator != null) {
            return this.floatManipulator.getValue(l);
        }
        return super.getFloatValue(l);
    }

    public boolean setFloatValue(long l, float f) throws DataException {
        if (this.kind != 5) {
            return false;
        }
        if (this.floatManipulator == null) {
            this.floatManipulator = (FloatManipulator)this.createManipulator(this.kind);
        }
        if (this.floatManipulator != null) {
            return this.floatManipulator.setValue(l, f);
        }
        return false;
    }

    public double getDoubleValue(long l) throws DataException {
        if (this.kind != 6) {
            return super.getDoubleValue(l);
        }
        if (this.doubleManipulator == null) {
            this.doubleManipulator = (DoubleManipulator)this.createManipulator(this.kind);
        }
        if (this.doubleManipulator != null) {
            return this.doubleManipulator.getValue(l);
        }
        return super.getDoubleValue(l);
    }

    public boolean setDoubleValue(long l, double d) throws DataException {
        if (this.kind != 6) {
            return false;
        }
        if (this.doubleManipulator == null) {
            this.doubleManipulator = (DoubleManipulator)this.createManipulator(this.kind);
        }
        if (this.doubleManipulator != null) {
            return this.doubleManipulator.setValue(l, d);
        }
        return false;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.kind);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.kind = objectInputStream.readInt();
    }

    protected abstract Manipulator createManipulator(int var1);

    public int getKind() {
        return this.kind;
    }

    public void clear() {
        this.startIndex = -1L;
        this.endIndex = -2L;
    }

    public abstract class ObjectManipulator
    implements Cloneable,
    Manipulator {
        public abstract Object getValue(long var1) throws DataException;

        public boolean setValue(long l, Object object) throws DataException {
            return false;
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                return null;
            }
        }

        public void setSlice(long l, long l2) {
        }
    }

    public abstract class DoubleManipulator
    implements Cloneable,
    Manipulator {
        public abstract double getValue(long var1) throws DataException;

        public boolean setValue(long l, double d) throws DataException {
            return false;
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                return null;
            }
        }

        public void setSlice(long l, long l2) {
        }
    }

    public abstract class FloatManipulator
    implements Cloneable,
    Manipulator {
        public abstract float getValue(long var1) throws DataException;

        public boolean setValue(long l, float f) throws DataException {
            return false;
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                return null;
            }
        }

        public void setSlice(long l, long l2) {
        }
    }

    public abstract class LongManipulator
    implements Cloneable,
    Manipulator {
        public abstract long getValue(long var1) throws DataException;

        public boolean setValue(long l, long l2) throws DataException {
            return false;
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                return null;
            }
        }

        public void setSlice(long l, long l2) {
        }
    }

    public abstract class IntegerManipulator
    implements Cloneable,
    Manipulator {
        public abstract int getValue(long var1) throws DataException;

        public boolean setValue(long l, int n) throws DataException {
            return false;
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                return null;
            }
        }

        public void setSlice(long l, long l2) {
        }
    }

    public abstract class ShortManipulator
    implements Cloneable,
    Manipulator {
        public abstract short getValue(long var1) throws DataException;

        public boolean setValue(long l, short s) throws DataException {
            return false;
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                return null;
            }
        }

        public void setSlice(long l, long l2) {
        }
    }

    public abstract class ByteManipulator
    implements Cloneable,
    Manipulator {
        public abstract byte getValue(long var1) throws DataException;

        public boolean setValue(long l, byte by) throws DataException {
            return false;
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                return null;
            }
        }

        public void setSlice(long l, long l2) {
        }
    }

    public static interface Manipulator {
    }
}

