/*
 * Decompiled with CFR 0.152.
 */
package com.incors.plaf;

import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.WeakHashMap;

class FastGradientPaintContext
implements PaintContext {
    private static WeakHashMap gradientCache = new WeakHashMap();
    private static LinkedList recentInfos = new LinkedList();
    GradientInfo info = new GradientInfo();
    int parallelDevicePos;
    Gradient gradient;

    FastGradientPaintContext(ColorModel colorModel, Rectangle rectangle, int n, int n2, boolean bl) {
        Object object;
        this.info.model = ((n & n2) >> 24 & 0xFF) != 255 ? ColorModel.getRGBdefault() : colorModel;
        this.info.startColor = n;
        this.info.endColor = n2;
        this.info.isVertical = bl;
        if (this.info.isVertical) {
            this.parallelDevicePos = rectangle.y;
            this.info.parallelLength = rectangle.height;
        } else {
            this.parallelDevicePos = rectangle.x;
            this.info.parallelLength = rectangle.width;
        }
        recentInfos.remove(this.info);
        recentInfos.add(0, this.info);
        if (recentInfos.size() > 16) {
            recentInfos.removeLast();
        }
        if ((object = gradientCache.get(this.info)) != null) {
            object = ((WeakReference)object).get();
        }
        if (object != null) {
            this.gradient = (Gradient)object;
        } else {
            this.gradient = new Gradient(this.info);
            gradientCache.put(this.info, new WeakReference<Gradient>(this.gradient));
        }
    }

    public void dispose() {
        this.gradient.dispose();
    }

    public ColorModel getColorModel() {
        return this.info.model;
    }

    public synchronized Raster getRaster(int n, int n2, int n3, int n4) {
        if (this.info.isVertical) {
            return this.gradient.getRaster(n2 - this.parallelDevicePos, n3, n4);
        }
        return this.gradient.getRaster(n - this.parallelDevicePos, n4, n3);
    }

    private class Gradient {
        GradientInfo info;
        int perpendicularLength = 0;
        WritableRaster raster;
        HashMap childRasterCache;

        Gradient(GradientInfo gradientInfo) {
            this.info = gradientInfo;
        }

        private Raster getRaster(int n, int n2, int n3) {
            Integer n4;
            Object v;
            if (this.raster == null || this.perpendicularLength < n2) {
                this.createRaster(n2);
            }
            if ((v = this.childRasterCache.get(n4 = new Integer(n))) != null) {
                return (Raster)v;
            }
            Raster raster = this.info.isVertical ? this.raster.createChild(0, n, this.perpendicularLength, this.info.parallelLength - n, 0, 0, null) : this.raster.createChild(n, 0, this.info.parallelLength - n, this.perpendicularLength, 0, 0, null);
            this.childRasterCache.put(n4, raster);
            return raster;
        }

        public void dispose() {
        }

        private void createRaster(int n) {
            int n2;
            int n3;
            if (this.info.isVertical) {
                n3 = this.info.parallelLength;
                n2 = this.perpendicularLength = n;
            } else {
                n2 = this.info.parallelLength;
                n3 = this.perpendicularLength = n;
            }
            int n4 = this.info.startColor >> 24 & 0xFF;
            int n5 = this.info.startColor >> 16 & 0xFF;
            int n6 = this.info.startColor >> 8 & 0xFF;
            int n7 = this.info.startColor & 0xFF;
            int n8 = (this.info.endColor >> 24 & 0xFF) - n4;
            int n9 = (this.info.endColor >> 16 & 0xFF) - n5;
            int n10 = (this.info.endColor >> 8 & 0xFF) - n6;
            int n11 = (this.info.endColor & 0xFF) - n7;
            this.raster = this.info.model.createCompatibleWritableRaster(n2, n3);
            Object object = null;
            int n12 = this.info.parallelLength;
            for (int i = 0; i < n12; ++i) {
                object = this.info.model.getDataElements(n4 + i * n8 / n12 << 24 | n5 + i * n9 / n12 << 16 | n6 + i * n10 / n12 << 8 | n7 + i * n11 / n12, object);
                for (int j = 0; j < n; ++j) {
                    if (this.info.isVertical) {
                        this.raster.setDataElements(j, i, object);
                        continue;
                    }
                    this.raster.setDataElements(i, j, object);
                }
            }
            this.childRasterCache = new HashMap();
        }
    }

    private class GradientInfo {
        ColorModel model;
        int parallelLength;
        int startColor;
        int endColor;
        boolean isVertical;

        private GradientInfo() {
        }

        public boolean equals(Object object) {
            if (!(object instanceof GradientInfo)) {
                return false;
            }
            GradientInfo gradientInfo = (GradientInfo)object;
            return gradientInfo.model.equals(this.model) && gradientInfo.parallelLength == this.parallelLength && gradientInfo.startColor == this.startColor && gradientInfo.endColor == this.endColor && gradientInfo.isVertical == this.isVertical;
        }

        public int hashCode() {
            return this.parallelLength;
        }

        public String toString() {
            return "Direction:" + (this.isVertical ? "ver" : "hor") + ", Length: " + Integer.toString(this.parallelLength) + ", Color1: " + Integer.toString(this.startColor, 16) + ", Color2: " + Integer.toString(this.endColor, 16);
        }
    }
}

