/* $Id: SpecSample.java,v 1.2 2006/06/04 08:33:45 erk Exp $
 * -----------------------------------------------------------------------
 * 
 * TSP Library - core components for a generic Transport Sampling Protocol.
 * 
 * Copyright (c) 2002 Yves DUFRENNE, Stephane GALLES, Eric NOULARD and Robert PAGNOT 
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * -----------------------------------------------------------------------
 * 
 * Project    : TSP
 * SubProject : jTSP
 * Maintainer : tsp@astrium-space.com
 * Component  : 
 * 
 * -----------------------------------------------------------------------
 * 
 * Purpose   : Consumer
 * 
 * -----------------------------------------------------------------------
 */

package tsp.consumer.util.configuration;

import tsp.util.ToStringHelper;

public class SpecSample implements Consolidatable {

	private String name;

	private String reNamed;

	private VarTypeEnum type;
	
	private VarAccessEnum access;

	private String providerName;

	private SpecProvider provider;

	private SpecSampleList sampleList;

	private Integer ownPeriod;
	
	private Integer ownPhase;

	private String description;

	private final SpecSamplingConfig root;

	public SpecSample(final SpecSamplingConfig root) {
		super();
		this.root = root;			
	}

	public SpecSampleList getSampleList() {
		return sampleList;
	}

	void setSampleList(SpecSampleList sampleList) {
		this.sampleList = sampleList;
		sampleList.getSamples().add(this);
	}

	public String getName() {
		return name;
	}

	void setName(String name) {
		this.name = name;
	}

	public String getReNamed() {
		return reNamed;
	}

	void setReNamed(String reNamed) {
		this.reNamed = reNamed;
	}
	
	public VarTypeEnum getType(){
		
		if (type != null) {
			return type;
		} else {
			return sampleList.getImplicitType();
		}
	}
	
	public VarAccessEnum getAccess() {
		if (access != null) {
			return access;
		} else {
			return sampleList.getImplicitAccess();
		}
	}

	void setType(VarTypeEnum type) {
		this.type = type;
	}
	
	void setAccess(VarAccessEnum access) {
		this.access = access;
	}


	void setProviderName(String providerName) {
		if (providerName != null)
			this.providerName = providerName;
	}

	void setOwnPhase(Integer phase) {
		this.ownPhase = phase;
	}
	
	public Integer getOwnPhase() {
		return ownPhase;
	}
	
	public Integer getOwnPeriod() {
		return ownPeriod;
	}

	void setOwnPeriod(Integer period) {
		this.ownPeriod = period;
	}

	public String getDescription() {
		return description;
	}

	void setDescription(String description) {
		this.description = description;
	}

	public String getProviderName() {
		if (providerName != null)
			return providerName;
		else
			return sampleList.getImplicitProviderName();

	}

	void setProvider(SpecProvider provider) {
		this.provider = provider;
	}
	
	public SpecProvider getProvider() {
		return provider;
	}

	public String toString() {
		return ToStringHelper.toString(this);
	}

	public int getPeriod() {

		if (ownPeriod != null) {
			return ownPeriod.intValue();
		} else {
			return sampleList.getImplicitPeriod().intValue();
		}

	}

	public int getPhase() {

		if (ownPhase != null) {
			return ownPhase.intValue();
		} else {
			return sampleList.getImplicitPhase().intValue();
		}

	}
	
	public void consolidate() throws SpecException {
		setProvider(root.getProviderByName(getProviderName()));
		// get ride of duplicated data
		setProviderName(null);

		if (ownPeriod == null && sampleList.getImplicitPeriod() == null) {
			throw new SpecException("No period found for sample " + getName());
		}
		
		else if (getName() == null)
			throw new SpecException("No name found for sample ");
		
		/*else if (getType() == null)
			throw new SpecException("No type found for sample " + getName());*/
		
		else if (ownPhase == null && sampleList.getImplicitPhase() == null) 
			throw new SpecException("No phase found for sample " + getName());
		
		else if (getAccess() == null)
			throw new SpecException("No access found for sample " + getName());
		
		else if (getProvider() == null)
			throw new SpecException("No provider found for sample " + getName());
		
		else if (getProviderName() == null)
			throw new SpecException("No provider name found or sample " + getName());
		
		

	}

}