/*
 * Decompiled with CFR 0.152.
 */
package processing.app.syntax.im;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.font.TextLayout;
import processing.app.syntax.JEditTextArea;
import processing.app.syntax.TextAreaPainter;

public class CompositionTextPainter {
    private TextLayout composedTextLayout;
    private int composedBeginCaretPosition = 0;
    private JEditTextArea textArea;

    public CompositionTextPainter(JEditTextArea jEditTextArea) {
        this.textArea = jEditTextArea;
        this.composedTextLayout = null;
    }

    public boolean hasComposedTextLayout() {
        return this.composedTextLayout != null;
    }

    public void setComposedTextLayout(TextLayout textLayout, int n) {
        this.composedTextLayout = textLayout;
        this.composedBeginCaretPosition = n;
    }

    public void invalidateComposedTextLayout(int n) {
        this.composedTextLayout = null;
        this.composedBeginCaretPosition = n;
    }

    public void draw(Graphics graphics, Color color) {
        assert (this.composedTextLayout != null);
        Point point = this.getCaretLocation();
        this.refillComposedArea(color, point.x, point.y);
        this.composedTextLayout.draw((Graphics2D)graphics, point.x, point.y);
    }

    private void refillComposedArea(Color color, int n, int n2) {
        Graphics graphics = this.textArea.getPainter().getGraphics();
        graphics.setColor(color);
        FontMetrics fontMetrics = this.textArea.getPainter().getFontMetrics();
        int n3 = n2 - (fontMetrics.getHeight() - 5);
        int n4 = fontMetrics.getHeight();
        int n5 = (int)this.composedTextLayout.getBounds().getWidth();
        graphics.fillRect(n, n3, n5, n4);
    }

    private Point getCaretLocation() {
        Point point = new Point();
        TextAreaPainter textAreaPainter = this.textArea.getPainter();
        FontMetrics fontMetrics = textAreaPainter.getFontMetrics();
        int n = fontMetrics.getHeight() - 5;
        int n2 = this.textArea.getCaretLine();
        point.y = n2 * fontMetrics.getHeight() + n;
        int n3 = this.composedBeginCaretPosition - this.textArea.getLineStartOffset(n2);
        point.x = this.textArea.offsetToX(n2, n3);
        return point;
    }
}

