/*
 * Decompiled with CFR 0.152.
 */
package processing.app.tools;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import processing.app.tools.CreateFont;

class SampleComponent
extends JComponent {
    String text = "Forsaking monastic tradition, twelve jovial friars gave up their vocation for a questionable existence on the flying trapeze.";
    int high = 80;
    CreateFont parent;

    public SampleComponent(CreateFont createFont) {
        this.parent = createFont;
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                String string = (String)JOptionPane.showInputDialog(SampleComponent.this.parent, "Enter new sample text:", "Sample Text", -1, null, null, SampleComponent.this.text);
                if (string != null) {
                    SampleComponent.this.text = string;
                    SampleComponent.this.parent.repaint();
                }
            }
        });
    }

    public void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setColor(Color.WHITE);
        Dimension dimension = this.getSize();
        graphics2D.fillRect(0, 0, dimension.width, dimension.height);
        graphics2D.setColor(Color.BLACK);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, this.parent.smooth ? RenderingHints.VALUE_TEXT_ANTIALIAS_ON : RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, this.parent.smooth ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF);
        Font font = this.getFont();
        int n = graphics2D.getFontMetrics().getAscent();
        graphics2D.setFont(font);
        graphics2D.drawString(this.text, 5, dimension.height - (dimension.height - n) / 2);
    }

    public Dimension getPreferredSize() {
        return new Dimension(400, this.high);
    }

    public Dimension getMaximumSize() {
        return new Dimension(10000, this.high);
    }

    public Dimension getMinimumSize() {
        return new Dimension(100, this.high);
    }
}

