/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www.protocol.http;

import java.io.IOException;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.util.HashMap;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;
import sun.net.www.HeaderParser;
import sun.net.www.protocol.http.AuthenticationInfo;
import sun.net.www.protocol.http.HttpURLConnection;
import sun.net.www.protocol.http.Negotiator;

class NegotiateAuthentication
extends AuthenticationInfo {
    private static final long serialVersionUID = 100L;
    private String scheme = null;
    static final char NEGOTIATE_AUTH = 'S';
    static final char KERBEROS_AUTH = 'K';
    static HashMap<String, Boolean> supported = null;
    static HashMap<String, Negotiator> cache = null;
    private Negotiator negotiator = null;

    public NegotiateAuthentication(boolean bl, URL uRL, PasswordAuthentication passwordAuthentication, String string) {
        super(bl ? (char)'p' : 's', 'S', uRL, "");
        this.scheme = string;
    }

    public NegotiateAuthentication(boolean bl, String string, int n, PasswordAuthentication passwordAuthentication, String string2) {
        super(bl ? (char)'p' : 's', 'S', string, n, "");
        this.scheme = string2;
    }

    boolean supportsPreemptiveAuthorization() {
        return false;
    }

    public static synchronized boolean isSupported(String string, String string2) {
        if (supported == null) {
            supported = new HashMap();
            cache = new HashMap();
        }
        if (supported.containsKey(string = string.toLowerCase())) {
            return supported.get(string);
        }
        try {
            Negotiator negotiator = Negotiator.getSupported(string, string2);
            supported.put(string, true);
            cache.put(string, negotiator);
            return true;
        }
        catch (Exception exception) {
            supported.put(string, false);
            return false;
        }
    }

    String getHeaderName() {
        if (this.type == 's') {
            return "Authorization";
        }
        return "Proxy-Authorization";
    }

    String getHeaderValue(URL uRL, String string) {
        throw new RuntimeException("getHeaderValue not supported");
    }

    boolean isAuthorizationStale(String string) {
        return false;
    }

    synchronized boolean setHeaders(HttpURLConnection httpURLConnection, HeaderParser headerParser, String string) {
        try {
            byte[] byArray = null;
            String[] stringArray = string.split("\\s+");
            if (stringArray.length > 1) {
                byArray = new BASE64Decoder().decodeBuffer(stringArray[1]);
            }
            String string2 = this.scheme + " " + new B64Encoder().encode(byArray == null ? this.firstToken() : this.nextToken(byArray));
            httpURLConnection.setAuthenticationProperty(this.getHeaderName(), string2);
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] firstToken() throws IOException {
        if (cache != null) {
            HashMap<String, Negotiator> hashMap = cache;
            synchronized (hashMap) {
                this.negotiator = cache.get(this.getHost());
                if (this.negotiator != null) {
                    cache.remove(this.getHost());
                }
            }
        }
        if (this.negotiator == null) {
            try {
                this.negotiator = Negotiator.getSupported(this.getHost(), this.scheme);
            }
            catch (Exception exception) {
                IOException iOException = new IOException("Cannot initialize Negotiator");
                iOException.initCause(exception);
                throw iOException;
            }
        }
        try {
            return this.negotiator.firstToken();
        }
        catch (Exception exception) {
            IOException iOException = new IOException("firstToken fails");
            iOException.initCause(exception);
            throw iOException;
        }
    }

    private byte[] nextToken(byte[] byArray) throws IOException {
        try {
            return this.negotiator.nextToken(byArray);
        }
        catch (Exception exception) {
            IOException iOException = new IOException("nextToken fails");
            iOException.initCause(exception);
            throw iOException;
        }
    }

    public void checkResponse(String string, String string2, URL uRL) throws IOException {
    }

    class B64Encoder
    extends BASE64Encoder {
        B64Encoder() {
        }

        protected int bytesPerLine() {
            return 100000;
        }
    }
}

