#ifndef HardwareRadio_h
#define HardwareRadio_h

#include <string.h>
#include "radio.h"

typedef struct radio_buffer
{
    struct radio_buffer *next;
    uint8_t len;
    uint8_t frm[127];
    uint8_t idx;
}
radio_buffer_t;

# ifdef __cplusplus
    class HardwareRadio
    {
        private:
            uint8_t txbuf[127];
            uint8_t txseq;
            void txbuffer_init(void);

        public:
            /* user reads from this buffer */
            radio_buffer_t *prdbuf;
            /* user writes to this buffer */
            radio_buffer_t *pwrbuf;

            uint8_t rxlen;
            uint8_t rxidx;
            uint8_t rxbuf[127];

            volatile uint8_t tx_in_progress;

            HardwareRadio(void);
            void begin(void);
            void begin(uint8_t channel);
            void write(uint8_t byte);
            void write(char * str);

            void put(int16_t value);

            void flush(void);

            int availabe(void);
            int read(void);
            radio_buffer_t * alloc_buffer(void);
            void free_buffer(radio_buffer_t * pbuf);

   };
#  ifndef HARDWARERADIO_CPP
    extern HardwareRadio Radio;
#  endif
# endif
#endif /*#ifndef HardwareRadio_h*/
