#   Copyright (c) 2011 - 2014 Axel Wachtler
#   All rights reserved.
#
#   Redistribution and use in source and binary forms, with or without
#   modification, are permitted provided that the following conditions
#   are met:
#
#   * Redistributions of source code must retain the above copyright
#     notice, this list of conditions and the following disclaimer.
#   * Redistributions in binary form must reproduce the above copyright
#     notice, this list of conditions and the following disclaimer in the
#     documentation and/or other materials provided with the distribution.
#   * Neither the name of the authors nor the names of its contributors
#     may be used to endorse or promote products derived from this software
#     without specific prior written permission.
#
#   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
#   AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
#   IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
#   ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
#   LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
#   CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
#   SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
#   INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
#   CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
#   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
#   POSSIBILITY OF SUCH DAMAGE.

# $Id$

# === main parameters of the project =========================================
TOPDIR = ..
PROJECT = xmpl_dbg
CURRENT_MAKEFILE = xmpl_dbg.mk
BOARD = UNDEFINED
PART = UNDEFINED
APPNAME = "\"xmpl_dbg\""

OBJDIR = $(TOPDIR)/build
BINDIR = $(TOPDIR)/bin
LIBDIR = $(TOPDIR)/lib

# guessing the OS for a working (g)mkdir
ifndef MKDIR
    ifdef SystemRoot
        MKDIR=gmkdir -p
    else
        MKDIR=mkdir -p
    endif
endif

# === autogenerated board rules ========================================
help:
	@echo
	@echo "========================================================="
	@echo "Enter a board name or "all" for building the libraries.  "
	@echo "Have a look in the docu for what board you want to build."
	@echo "========================================================="
	@echo

all: any2400 any2400st any900 any900st atrcb256rfr2xpro atzb256rfr2xpro atzbx212bxpro atzbx233usb atzbx233xpro bat bitbean cbb212 cbb230 cbb230b cbb231 cbb232 cbb233 derfn128 derfn128u0 derfn256u0 derfn256u0pa derftorcbrfa1 dracula ibdt212 ibdt231 ibdt232 icm230_11 icm230_12a icm230_12b icm230_12c ics230_11 ics230_12 ict230 im240a_eval l3y lgee231 lgee231_v2 midgee mnb900 muse231 museII232 museIIrfa pinoccio radiofaro raspbee rdk212 rdk230 rdk230b rdk231 rdk232 rdk233 rose231 rzusb stb128rfa1 stb212 stb230 stb230b stb231 stb232 stb233 stb256rfr2 stkm16 stkm8 tiny230 tiny231 wdba1281 wprog xma1u233xpro xme5rz212 xme5rz230 xme5rz231 xxo zgbh212 zgbh230 zgbh231

list:
	 @echo '  any2400          : A.N. Solutions ANY Brick'
	 @echo '  any2400st        : A.N. Solutions ANY Stick'
	 @echo '  any900           : A.N. Solutions ANY Brick'
	 @echo '  any900st         : A.N. Solutions ANY Stick'
	 @echo '  atrcb256rfr2xpro : Atmel ATmega256RFR2 ZigBit Xplained Pro Extension'
	 @echo '  atzb256rfr2xpro  : Atmel ATmega256RFR2 ZigBit Xplained Pro Extension'
	 @echo '  atzbx212bxpro    : Atmel ZigBit (Module, USB Stick, Xplained Pro Extension)'
	 @echo '  atzbx233usb      : Atmel ZigBit (Module, USB Stick, Xplained Pro Extension)'
	 @echo '  atzbx233xpro     : Atmel ZigBit (Module, USB Stick, Xplained Pro Extension)'
	 @echo '  bat              : AirDMX remote node Bat, battery powered'
	 @echo '  bitbean          : Colorado Micro Devices, BitBean (ZigBit ATZB-24-A2)'
	 @echo '  cbb212           : REB Controller Base Board with REB23x/REB212 attached'
	 @echo '  cbb230           : REB Controller Base Board with REB23x/REB212 attached'
	 @echo '  cbb230b          : REB Controller Base Board with REB23x/REB212 attached'
	 @echo '  cbb231           : REB Controller Base Board with REB23x/REB212 attached'
	 @echo '  cbb232           : REB Controller Base Board with REB23x/REB212 attached'
	 @echo '  cbb233           : REB Controller Base Board with REB23x/REB212 attached'
	 @echo '  derfn128         : Dresden Elektronik Radio Module deRFmega128-22A/M{00} on deRFnode, USB'
	 @echo '  derfn128u0       : Dresden Elektronik Radio Module deRFmega128-22A/M{00} on deRFnode, USB'
	 @echo '  derfn256u0       : Dresden Elektronik Radio Module deRFmega256-23M{00,10,12} on deRFnode, UART0 (X5)'
	 @echo '  derfn256u0pa     : Dresden Elektronik Radio Module deRFmega256-23M{00,10,12} on deRFnode, UART0 (X5)'
	 @echo '  derftorcbrfa1    : Dresden Elektronik deRFtoRCB Adapter for ATmega128RFA1'
	 @echo '  dracula          : AirDMX gateway Dracula'
	 @echo '  ibdt212          : IBDT212 Hardware'
	 @echo '  ibdt231          : IBDT231 Hardware'
	 @echo '  ibdt232          : IBDT232 Hardware'
	 @echo '  icm230_11        : In-Cirquit radio module, version 1.1, 1.2, AT86RF230a/b'
	 @echo '  icm230_12a       : In-Cirquit radio module, version 1.1, 1.2, AT86RF230a/b'
	 @echo '  icm230_12b       : In-Cirquit radio module, version 1.1, 1.2, AT86RF230a/b'
	 @echo '  icm230_12c       : In-Cirquit radio stick/module, version 1.2a (RF230 RevB) [tarnished finish & AtMega128]'
	 @echo '  ics230_11        : In-Cirquit radio stick, version 1.1'
	 @echo '  ics230_12        : In-Cirquit radio stick/module, version 1.2a (RF230 RevB) [tarnished finish & AtMega128]'
	 @echo '  ict230           : In-Cirquit radio stick/module, version 1.0'
	 @echo '  im240a_eval      : IMST GmbH, WiMOD im240a Development Board'
	 @echo '  l3y              : 2564rfr2 low cost module'
	 @echo '  lgee231          : DIY Board by Daniel Thiele, w/ accelerometer, breakout board and UART.'
	 @echo '  lgee231_v2       : DIY board by Daniel Thiele, w/ accelerometer, w/o breakout board.'
	 @echo '  midgee           : IBDT Midgee'
	 @echo '  mnb900           : Meshnetics MeshBean WDB-A1281 and MNZB-900 development boards'
	 @echo '  muse231          : IBDT Multisensor Board'
	 @echo '  museII232        : IBDT MuseII ATmega88PA+AT86RF232'
	 @echo '  museIIrfa        : IBDT MuseII ATmega128RFA1'
	 @echo '  pinoccio         : Pinoccio - the ecosystem for the internet of things'
	 @echo '  radiofaro        : RadioFaro, Arduino like board with deRFmega128-22A001'
	 @echo '  raspbee          : Dresden Elektronik Raspberry Pi Module'
	 @echo '  rdk212           : Radio Controller Board by Atmel and Dresden Elektronik'
	 @echo '  rdk230           : Radio Controller Board by Atmel and Dresden Elektronik'
	 @echo '  rdk230b          : Radio Controller Board by Atmel and Dresden Elektronik'
	 @echo '  rdk231           : Radio Controller Board by Atmel and Dresden Elektronik'
	 @echo '  rdk232           : Radio Controller Board by Atmel and Dresden Elektronik'
	 @echo '  rdk233           : Radio Controller Board by Atmel and Dresden Elektronik'
	 @echo '  rose231          : IBDT Rocket Sensor Board'
	 @echo '  rzusb            : Atmel Raven USB Stick with AT86RF230 Rev. B'
	 @echo '  stb128rfa1       : Dresden Elektronik Sensor Terminal Board with RCB128RFA1'
	 @echo '  stb212           : Dresden Elektronik Sensor Terminal Board with RCB for AT86RF{212,23x}'
	 @echo '  stb230           : Dresden Elektronik Sensor Terminal Board with RCB for AT86RF{212,23x}'
	 @echo '  stb230b          : Dresden Elektronik Sensor Terminal Board with RCB for AT86RF{212,23x}'
	 @echo '  stb231           : Dresden Elektronik Sensor Terminal Board with RCB for AT86RF{212,23x}'
	 @echo '  stb232           : Dresden Elektronik Sensor Terminal Board with RCB for AT86RF{212,23x}'
	 @echo '  stb233           : Dresden Elektronik Sensor Terminal Board with RCB for AT86RF{212,23x}'
	 @echo '  stb256rfr2       : Sensor Terminal Board with Atmel RCB256RFR2 Radio Controller Board'
	 @echo '  stkm16           : STK500 with ATmega16 and AT86RF230 radio extender board'
	 @echo '  stkm8            : STK500 with ATmega8 and AT86RF230 radio extender board'
	 @echo '  tiny230          : DIY Board by Joerg Wunsch with ATtiny(44,84) and AT86RF(230,231)'
	 @echo '  tiny231          : DIY Board by Joerg Wunsch with ATtiny(44,84) and AT86RF(230,231)'
	 @echo '  wdba1281         : Meshnetics MeshBean WDB-A1281 and MNZB-900 development boards'
	 @echo '  wprog            : WProg'
	 @echo '  xma1u233xpro     : Atmel ZigBit ATZB-RF-233-1-C XPRO Extension connected to XMEGA A1U Xplained Pro'
	 @echo '  xme5rz212        : Atmel RZ600 Stick plugged on J1 of Xmega-E5 Xplained'
	 @echo '  xme5rz230        : Atmel RZ600 Stick plugged on J1 of Xmega-E5 Xplained'
	 @echo '  xme5rz231        : Atmel RZ600 Stick plugged on J1 of Xmega-E5 Xplained'
	 @echo '  xxo              : Tic-Tac-Toe Hardware for Chemnitzer Linuxtage 2012'
	 @echo '  zgbh212          : ATZGB.com evaluation board'
	 @echo '  zgbh230          : ATZGB.com evaluation board'
	 @echo '  zgbh231          : ATZGB.com evaluation board'


any2400:
	$(MAKE) -f $(CURRENT_MAKEFILE) TC=AVR8 BOARD=any2400 MCU=atmega1281 F_CPU=8000000UL $(TARGETS)

any2400st:
	$(MAKE) -f $(CURRENT_MAKEFILE) TC=AVR8 BOARD=any2400st MCU=atmega1281 F_CPU=8000000UL $(TARGETS)

any900:
	$(MAKE) -f $(CURRENT_MAKEFILE) TC=AVR8 BOARD=any900 MCU=atmega1281 F_CPU=8000000UL $(TARGETS)

any900st:
	$(MAKE) -f $(CURRENT_MAKEFILE) TC=AVR8 BOARD=any900st MCU=atmega1281 F_CPU=8000000UL $(TARGETS)

atrcb256rfr2xpro:
	$(MAKE) -f $(CURRENT_MAKEFILE) TC=AVR8 BOARD=atrcb256rfr2xpro MCU=atmega256rfr2 F_CPU=16000000UL $(TARGETS)

atzb256rfr2xpro:
	$(MAKE) -f $(CURRENT_MAKEFILE) TC=AVR8 BOARD=atzb256rfr2xpro MCU=atmega256rfr2 F_CPU=16000000UL $(TARGETS)

atzbx212bxpro:
	$(MAKE) -f $(CURRENT_MAKEFILE) TC=AVR8 BOARD=atzbx212bxpro MCU=atxmega256a3 F_CPU=8000000UL $(TARGETS)

atzbx233usb:
	$(MAKE) -f $(CURRENT_MAKEFILE) TC=AVR8 BOARD=atzbx233usb MCU=atxmega256a3u F_CPU=32000000UL $(TARGETS)

atzbx233xpro:
	$(MAKE) -f $(CURRENT_MAKEFILE) TC=AVR8 BOARD=atzbx233xpro MCU=atxmega256a3 F_CPU=8000000UL $(TARGETS)

bat:
	$(MAKE) -f $(CURRENT_MAKEFILE) TC=AVR8 BOARD=bat MCU=atmega128rfa1 F_CPU=16000000UL $(TARGETS)

bitbean:
	$(MAKE) -f $(CURRENT_MAKEFILE) TC=AVR8 BOARD=bitbean MCU=atmega1281 F_CPU=8000000UL $(TARGETS)

cbb212:
	$(MAKE) -f $(CURRENT_MAKEFILE) TC=AVR8 BOARD=cbb212 MCU=atxmega256a3 F_CPU=8000000UL $(TARGETS)

cbb230:
	$(MAKE) -f $(CURRENT_MAKEFILE) TC=AVR8 BOARD=cbb230 MCU=atxmega256a3 F_CPU=8000000UL $(TARGETS)

cbb230b:
	$(MAKE) -f $(CURRENT_MAKEFILE) TC=AVR8 BOARD=cbb230b MCU=atxmega256a3 F_CPU=8000000UL $(TARGETS)

cbb231:
	$(MAKE) -f $(CURRENT_MAKEFILE) TC=AVR8 BOARD=cbb231 MCU=atxmega256a3 F_CPU=8000000UL $(TARGETS)

cbb232:
	$(MAKE) -f $(CURRENT_MAKEFILE) TC=AVR8 BOARD=cbb232 MCU=atxmega256a3 F_CPU=8000000UL $(TARGETS)

cbb233:
	$(MAKE) -f $(CURRENT_MAKEFILE) TC=AVR8 BOARD=cbb233 MCU=atxmega256a3 F_CPU=8000000UL $(TARGETS)

derfn128:
	$(MAKE) -f $(CURRENT_MAKEFILE) TC=AVR8 BOARD=derfn128 MCU=atmega128rfa1 F_CPU=16000000UL $(TARGETS)

derfn128u0:
	$(MAKE) -f $(CURRENT_MAKEFILE) TC=AVR8 BOARD=derfn128u0 MCU=atmega128rfa1 F_CPU=16000000UL $(TARGETS)

derfn256u0:
	$(MAKE) -f $(CURRENT_MAKEFILE) TC=AVR8 BOARD=derfn256u0 MCU=atmega256rfr2 F_CPU=16000000UL $(TARGETS)

derfn256u0pa:
	$(MAKE) -f $(CURRENT_MAKEFILE) TC=AVR8 BOARD=derfn256u0pa MCU=atmega256rfr2 F_CPU=16000000UL $(TARGETS)

derftorcbrfa1:
	$(MAKE) -f $(CURRENT_MAKEFILE) TC=AVR8 BOARD=derftorcbrfa1 MCU=atmega128rfa1 F_CPU=8000000UL $(TARGETS)

dracula:
	$(MAKE) -f $(CURRENT_MAKEFILE) TC=AVR8 BOARD=dracula MCU=atmega128rfa1 F_CPU=16000000UL $(TARGETS)

ibdt212:
	$(MAKE) -f $(CURRENT_MAKEFILE) TC=AVR8 BOARD=ibdt212 MCU=atmega644 F_CPU=8000000UL $(TARGETS)

ibdt231:
	$(MAKE) -f $(CURRENT_MAKEFILE) TC=AVR8 BOARD=ibdt231 MCU=atmega644 F_CPU=8000000UL $(TARGETS)

ibdt232:
	$(MAKE) -f $(CURRENT_MAKEFILE) TC=AVR8 BOARD=ibdt232 MCU=atmega644p F_CPU=8000000UL $(TARGETS)

icm230_11:
	$(MAKE) -f $(CURRENT_MAKEFILE) TC=AVR8 BOARD=icm230_11 MCU=atmega1281 F_CPU=8000000UL $(TARGETS)

icm230_12a:
	$(MAKE) -f $(CURRENT_MAKEFILE) TC=AVR8 BOARD=icm230_12a MCU=atmega1281 F_CPU=8000000UL $(TARGETS)

icm230_12b:
	$(MAKE) -f $(CURRENT_MAKEFILE) TC=AVR8 BOARD=icm230_12b MCU=atmega1281 F_CPU=8000000UL $(TARGETS)

icm230_12c:
	$(MAKE) -f $(CURRENT_MAKEFILE) TC=AVR8 BOARD=icm230_12c MCU=atmega128 F_CPU=8000000UL $(TARGETS)

ics230_11:
	$(MAKE) -f $(CURRENT_MAKEFILE) TC=AVR8 BOARD=ics230_11 MCU=atmega1281 F_CPU=8000000UL $(TARGETS)

ics230_12:
	$(MAKE) -f $(CURRENT_MAKEFILE) TC=AVR8 BOARD=ics230_12 MCU=atmega128 F_CPU=8000000UL $(TARGETS)

ict230:
	$(MAKE) -f $(CURRENT_MAKEFILE) TC=AVR8 BOARD=ict230 MCU=atmega1281 F_CPU=8000000UL $(TARGETS)

im240a_eval:
	$(MAKE) -f $(CURRENT_MAKEFILE) TC=AVR8 BOARD=im240a_eval MCU=atmega328 F_CPU=8000000UL $(TARGETS)

l3y:
	$(MAKE) -f $(CURRENT_MAKEFILE) TC=AVR8 BOARD=l3y MCU=atmega2564rfr2 F_CPU=8000000UL $(TARGETS)

lgee231:
	$(MAKE) -f $(CURRENT_MAKEFILE) TC=AVR8 BOARD=lgee231 MCU=atmega88 F_CPU=8000000UL $(TARGETS)

lgee231_v2:
	$(MAKE) -f $(CURRENT_MAKEFILE) TC=AVR8 BOARD=lgee231_v2 MCU=atmega88 F_CPU=8000000UL $(TARGETS)

midgee:
	$(MAKE) -f $(CURRENT_MAKEFILE) TC=AVR8 BOARD=midgee MCU=atmega88p F_CPU=8000000UL $(TARGETS)

mnb900:
	$(MAKE) -f $(CURRENT_MAKEFILE) TC=AVR8 BOARD=mnb900 MCU=atmega1281 F_CPU=8000000UL $(TARGETS)

muse231:
	$(MAKE) -f $(CURRENT_MAKEFILE) TC=AVR8 BOARD=muse231 MCU=atmega88pa F_CPU=8000000UL $(TARGETS)

museII232:
	$(MAKE) -f $(CURRENT_MAKEFILE) TC=AVR8 BOARD=museII232 MCU=atmega328p F_CPU=8000000UL $(TARGETS)

museIIrfa:
	$(MAKE) -f $(CURRENT_MAKEFILE) TC=AVR8 BOARD=museIIrfa MCU=atmega128rfa1 F_CPU=8000000UL $(TARGETS)

pinoccio:
	$(MAKE) -f $(CURRENT_MAKEFILE) TC=AVR8 BOARD=pinoccio MCU=atmega256rfr2 F_CPU=16000000UL $(TARGETS)

radiofaro:
	$(MAKE) -f $(CURRENT_MAKEFILE) TC=AVR8 BOARD=radiofaro MCU=atmega128rfa1 F_CPU=16000000UL $(TARGETS)

raspbee:
	$(MAKE) -f $(CURRENT_MAKEFILE) TC=AVR8 BOARD=raspbee MCU=atmega256rfr2 F_CPU=8000000UL $(TARGETS)

rdk212:
	$(MAKE) -f $(CURRENT_MAKEFILE) TC=AVR8 BOARD=rdk212 MCU=atmega1281 F_CPU=8000000UL $(TARGETS)

rdk230:
	$(MAKE) -f $(CURRENT_MAKEFILE) TC=AVR8 BOARD=rdk230 MCU=atmega1281 F_CPU=8000000UL $(TARGETS)

rdk230b:
	$(MAKE) -f $(CURRENT_MAKEFILE) TC=AVR8 BOARD=rdk230b MCU=atmega1281 F_CPU=8000000UL $(TARGETS)

rdk231:
	$(MAKE) -f $(CURRENT_MAKEFILE) TC=AVR8 BOARD=rdk231 MCU=atmega1281 F_CPU=8000000UL $(TARGETS)

rdk232:
	$(MAKE) -f $(CURRENT_MAKEFILE) TC=AVR8 BOARD=rdk232 MCU=atmega1281 F_CPU=8000000UL $(TARGETS)

rdk233:
	$(MAKE) -f $(CURRENT_MAKEFILE) TC=AVR8 BOARD=rdk233 MCU=atmega1281 F_CPU=8000000UL $(TARGETS)

rose231:
	$(MAKE) -f $(CURRENT_MAKEFILE) TC=AVR8 BOARD=rose231 MCU=atmega328p F_CPU=8000000UL $(TARGETS)

rzusb:
	$(MAKE) -f $(CURRENT_MAKEFILE) TC=AVR8 BOARD=rzusb MCU=at90usb1287 F_CPU=8000000UL $(TARGETS)

stb128rfa1:
	$(MAKE) -f $(CURRENT_MAKEFILE) TC=AVR8 BOARD=stb128rfa1 MCU=atmega128rfa1 F_CPU=8000000UL $(TARGETS)

stb212:
	$(MAKE) -f $(CURRENT_MAKEFILE) TC=AVR8 BOARD=stb212 MCU=atmega1281 F_CPU=8000000UL $(TARGETS)

stb230:
	$(MAKE) -f $(CURRENT_MAKEFILE) TC=AVR8 BOARD=stb230 MCU=atmega1281 F_CPU=8000000UL $(TARGETS)

stb230b:
	$(MAKE) -f $(CURRENT_MAKEFILE) TC=AVR8 BOARD=stb230b MCU=atmega1281 F_CPU=8000000UL $(TARGETS)

stb231:
	$(MAKE) -f $(CURRENT_MAKEFILE) TC=AVR8 BOARD=stb231 MCU=atmega1281 F_CPU=8000000UL $(TARGETS)

stb232:
	$(MAKE) -f $(CURRENT_MAKEFILE) TC=AVR8 BOARD=stb232 MCU=atmega1281 F_CPU=8000000UL $(TARGETS)

stb233:
	$(MAKE) -f $(CURRENT_MAKEFILE) TC=AVR8 BOARD=stb233 MCU=atmega1281 F_CPU=8000000UL $(TARGETS)

stb256rfr2:
	$(MAKE) -f $(CURRENT_MAKEFILE) TC=AVR8 BOARD=stb256rfr2 MCU=atmega256rfr2 F_CPU=8000000UL $(TARGETS)

stkm16:
	$(MAKE) -f $(CURRENT_MAKEFILE) TC=AVR8 BOARD=stkm16 MCU=atmega16 F_CPU=3686400UL $(TARGETS)

stkm8:
	$(MAKE) -f $(CURRENT_MAKEFILE) TC=AVR8 BOARD=stkm8 MCU=atmega8 F_CPU=8000000UL $(TARGETS)

tiny230:
	$(MAKE) -f $(CURRENT_MAKEFILE) TC=AVR8 BOARD=tiny230 MCU=attiny84 F_CPU=8000000UL $(TARGETS)

tiny231:
	$(MAKE) -f $(CURRENT_MAKEFILE) TC=AVR8 BOARD=tiny231 MCU=attiny84 F_CPU=8000000UL $(TARGETS)

wdba1281:
	$(MAKE) -f $(CURRENT_MAKEFILE) TC=AVR8 BOARD=wdba1281 MCU=atmega1281 F_CPU=8000000UL $(TARGETS)

wprog:
	$(MAKE) -f $(CURRENT_MAKEFILE) TC=AVR8 BOARD=wprog MCU=atmega128rfa1 F_CPU=8000000UL $(TARGETS)

xma1u233xpro:
	$(MAKE) -f $(CURRENT_MAKEFILE) TC=AVR8 BOARD=xma1u233xpro MCU=atxmega128a1u F_CPU=8000000UL $(TARGETS)

xme5rz212:
	$(MAKE) -f $(CURRENT_MAKEFILE) TC=AVR8 BOARD=xme5rz212 MCU=atxmega32e5 F_CPU=8000000UL $(TARGETS)

xme5rz230:
	$(MAKE) -f $(CURRENT_MAKEFILE) TC=AVR8 BOARD=xme5rz230 MCU=atxmega32e5 F_CPU=8000000UL $(TARGETS)

xme5rz231:
	$(MAKE) -f $(CURRENT_MAKEFILE) TC=AVR8 BOARD=xme5rz231 MCU=atxmega32e5 F_CPU=8000000UL $(TARGETS)

xxo:
	$(MAKE) -f $(CURRENT_MAKEFILE) TC=AVR8 BOARD=xxo MCU=atmega128rfa1 F_CPU=1000000UL $(TARGETS)

zgbh212:
	$(MAKE) -f $(CURRENT_MAKEFILE) TC=AVR8 BOARD=zgbh212 MCU=atmega1281 F_CPU=7372800UL $(TARGETS)

zgbh230:
	$(MAKE) -f $(CURRENT_MAKEFILE) TC=AVR8 BOARD=zgbh230 MCU=atmega1281 F_CPU=7372800UL $(TARGETS)

zgbh231:
	$(MAKE) -f $(CURRENT_MAKEFILE) TC=AVR8 BOARD=zgbh231 MCU=atmega1281 F_CPU=7372800UL $(TARGETS)


clean:
	rm -rf $(OBJDIR)/*.o $(OBJDIR)/*.lst $(BINDIR)/*.elf $(BINDIR)/*.hex

# === internal rules ===================================================

# temporary output directory
$(OBJDIR):
	$(MKDIR) $@

$(BINDIR):
	$(MKDIR) $@

TARGETS=$(OBJDIR) $(BINDIR) __xmpl_dbg__
SOURCES = xmpl_dbg.c
INCDIRS = . $(TOPDIR)/inc
LIBDIRS = $(TOPDIR)/lib
# DBGFMT=stabs for Linux
# DBGFMT=dwarf-2 for Windows
DBGFMT=
# automatically derived parameters
OBJECTS = $(SOURCES:%.c=$(OBJDIR)/%_$(BOARD).o)
TARGET = $(BINDIR)/$(PROJECT)_$(BOARD)

# === tool parameters ======================================================

CCFLAGS = -Wall -Wundef -Os -g$(DBGFMT) -ffunction-sections -fdata-sections -std=c99 -mmcu=$(MCU)
CCFLAGS += -Wa,-adhlns=$(<:%.c=$(OBJDIR)/%_$(BOARD).lst)
CCFLAGS += -D$(BOARD)
CCFLAGS += -DF_CPU=$(F_CPU)
CCFLAGS += -DAPP_NAME=$(APPNAME)
ifneq ($(baudrate),)
  CCFLAGS += -DHIF_DEFAULT_BAUDRATE=$(baudrate)
endif
CCFLAGS += -I$(TOPDIR)/inc -I.
LDFLAGS = $(patsubst %,-L%,$(LIBDIRS)) -Wl,--gc-sections -luracoli_$(BOARD)
OCFLAGS=-O ihex

# === custom settings ======================================================
# --- todo ---


# hier koennte ihre toolchain stehen!
ifeq ($(TC), AVR8)
   CC=avr-gcc
   AR=avr-ar
   RANLIB=avr-ranlib
   OBJCOPY=avr-objcopy
else ifeq ($(TC), ARM)
   CC=arm-none-eabi-gcc
   AR=arm-none-eabi-ar
   RANLIB=arm-none-eabi-ranlib
   OBJCOPY=arm-none-eabi-objcopy
else 
   CC=@echo undefined cc for $(TC)
   AR=@echo undefined ar for $(TC)
   RANLIB=@echo undefined ranlib for $(TC)
   OBJCOPY=@echo undefined objcopy for $(TC)
endif


# === build rules ============================================================

__xmpl_dbg__: $(TARGET).hex

$(TARGET).hex: $(TARGET).elf
	$(OBJCOPY) $(OCFLAGS) $< $@

$(TARGET).elf: $(OBJECTS) $(LIBDIRS)/liburacoli_$(BOARD).a
	$(CC) -o $@ $(CCFLAGS) $(OBJECTS) $(LDFLAGS)

$(OBJDIR)/%_$(BOARD).o: %.c
	$(CC) $(CCFLAGS) -c -o $@ $<

$(LIBDIRS)/liburacoli_$(BOARD).a:
	cd $(TOPDIR)/uracoli && make $(BOARD)
