/*
 * Decompiled with CFR 0.152.
 */
package org.x4o.xml.eld.xsd;

import java.io.File;
import junit.framework.TestCase;
import org.x4o.xml.X4ODriver;
import org.x4o.xml.X4ODriverManager;
import org.x4o.xml.eld.xsd.X4OWriteLanguageSchemaExecutor;
import org.x4o.xml.io.X4OSchemaWriter;

public class X4OWriteLanguageSchemaExecutorTest
extends TestCase {
    private File getTempPath(String dir) throws Exception {
        File tempFile = File.createTempFile("test-path", ".tmp");
        String absolutePath = tempFile.getAbsolutePath();
        String tempPath = absolutePath.substring(0, absolutePath.lastIndexOf(File.separator) + 1);
        tempFile.delete();
        File result = new File(tempPath + File.separator + dir);
        if (!result.exists()) {
            result.mkdir();
        }
        return result;
    }

    public void testSchemaWriterDirect() throws Exception {
        X4ODriver driver = X4ODriverManager.getX4ODriver((String)"cel");
        X4OSchemaWriter xsd = driver.createSchemaWriter();
        xsd.writeSchema(this.getTempPath("junit-xsd-cel-direct"));
    }

    public void testEldSchema() throws Exception {
        X4OWriteLanguageSchemaExecutor writer = new X4OWriteLanguageSchemaExecutor();
        writer.setBasePath(this.getTempPath("junit-xsd-eld"));
        writer.setLanguageName("eld");
        writer.execute();
    }

    public void testEldCoreSchema() throws Exception {
        X4OWriteLanguageSchemaExecutor writer = new X4OWriteLanguageSchemaExecutor();
        writer.setBasePath(this.getTempPath("junit-xsd-cel"));
        writer.setLanguageName("cel");
        writer.execute();
    }

    public void testSwiXmlSchema() throws Exception {
        X4OWriteLanguageSchemaExecutor writer = new X4OWriteLanguageSchemaExecutor();
        writer.setBasePath(this.getTempPath("junit-xsd-swixml2"));
        writer.setLanguageName("swixml");
        writer.execute();
    }

    public void testEldDocMain() throws Exception {
        X4OWriteLanguageSchemaExecutor.main((String[])new String[]{"-p", this.getTempPath("junit-xsd-main").getAbsolutePath(), "-l", "eld"});
    }
}

