/*
 * Decompiled with CFR 0.152.
 */
package org.x4o.xml.io;

import java.awt.Component;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.Charset;
import junit.framework.TestCase;
import org.x4o.xml.io.X4OReader;
import org.x4o.xml.io.X4OWriter;
import org.x4o.xml.test.TestDriver;
import org.x4o.xml.test.models.TestObjectRoot;
import org.x4o.xml.test.swixml.Accelerator3;
import org.x4o.xml.test.swixml.SwiXmlDriver;
import org.x4o.xml.test.swixml.SwingEngine;

public class X4OWriterTest
extends TestCase {
    private File createOutputFile() throws IOException {
        File outputFile = File.createTempFile("test-writer", ".xml");
        outputFile.deleteOnExit();
        return outputFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFile(File file) throws IOException {
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), Charset.forName("UTF-8")));
        try {
            String out;
            StringBuilder sb = new StringBuilder();
            String line = br.readLine();
            while (line != null) {
                sb.append(line);
                sb.append('\n');
                line = br.readLine();
            }
            String string = out = sb.toString();
            return string;
        }
        finally {
            br.close();
        }
    }

    public void testWriterSwiXmlOutput() throws Exception {
        Accelerator3 ac3 = new Accelerator3(false);
        SwingEngine engine = new SwingEngine(ac3);
        File outputFile = this.createOutputFile();
        SwiXmlDriver driver = SwiXmlDriver.getInstance();
        X4OReader reader = driver.createReader();
        X4OWriter writer = driver.createWriter("3.0");
        reader.addELBeanInstance("swingEngine", (Object)engine);
        Component root = (Component)reader.readResource("tests/swixml/swixml-accelerator-3.0.xml");
        writer.writeFile((Object)root, outputFile);
        X4OWriterTest.assertTrue((String)"Debug file does not exists.", (boolean)outputFile.exists());
        outputFile.delete();
    }

    public void testWriteFile() throws Exception {
        File outputFile = this.createOutputFile();
        TestDriver driver = TestDriver.getInstance();
        X4OReader reader = driver.createReader();
        X4OWriter writer = driver.createWriter();
        TestObjectRoot root = (TestObjectRoot)reader.readResource("tests/attributes/test-bean.xml");
        writer.writeFile((Object)root, outputFile);
        String text = X4OWriterTest.readFile(outputFile);
        outputFile.delete();
        X4OWriterTest.assertTrue((boolean)text.startsWith("<?xml version=\"1.0\" encoding=\"UTF-8\"?>"));
        X4OWriterTest.assertTrue((boolean)text.contains("http://test.x4o.org/xml/ns/test-root"));
        X4OWriterTest.assertTrue((boolean)text.contains("<test-lang:parent name=\"test-bean.xml\"/>"));
        X4OWriterTest.assertTrue((boolean)text.contains("<test-lang:testBean"));
    }

    public void testWriteFileName() throws Exception {
        File outputFile = this.createOutputFile();
        TestDriver driver = TestDriver.getInstance();
        X4OReader reader = driver.createReader();
        X4OWriter writer = driver.createWriter();
        TestObjectRoot root = (TestObjectRoot)reader.readResource("tests/attributes/test-bean.xml");
        writer.writeFile((Object)root, outputFile.getAbsolutePath());
        String text = X4OWriterTest.readFile(outputFile);
        outputFile.delete();
        X4OWriterTest.assertTrue((boolean)text.startsWith("<?xml version=\"1.0\" encoding=\"UTF-8\"?>"));
        X4OWriterTest.assertTrue((boolean)text.contains("http://test.x4o.org/xml/ns/test-root"));
        X4OWriterTest.assertTrue((boolean)text.contains("<test-lang:parent name=\"test-bean.xml\"/>"));
        X4OWriterTest.assertTrue((boolean)text.contains("<test-lang:testBean"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testWriteStream() throws Exception {
        File outputFile = this.createOutputFile();
        TestDriver driver = TestDriver.getInstance();
        X4OReader reader = driver.createReader();
        X4OWriter writer = driver.createWriter();
        TestObjectRoot root = (TestObjectRoot)reader.readResource("tests/attributes/test-bean.xml");
        FileOutputStream outputStream = new FileOutputStream(outputFile);
        try {
            writer.write((Object)root, (OutputStream)outputStream);
        }
        finally {
            ((OutputStream)outputStream).close();
        }
        writer.writeFile((Object)root, outputFile.getAbsolutePath());
        String text = X4OWriterTest.readFile(outputFile);
        outputFile.delete();
        X4OWriterTest.assertTrue((boolean)text.startsWith("<?xml version=\"1.0\" encoding=\"UTF-8\"?>"));
        X4OWriterTest.assertTrue((boolean)text.contains("http://test.x4o.org/xml/ns/test-root"));
        X4OWriterTest.assertTrue((boolean)text.contains("<test-lang:parent name=\"test-bean.xml\"/>"));
        X4OWriterTest.assertTrue((boolean)text.contains("<test-lang:testBean"));
    }
}

