/*
 * Decompiled with CFR 0.152.
 */
package org.x4o.xml.test.swixml.conv;

import java.awt.Color;
import java.util.Locale;
import org.x4o.xml.conv.AbstractStringObjectConverter;
import org.x4o.xml.conv.ObjectConverter;
import org.x4o.xml.conv.ObjectConverterException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColorConverter
extends AbstractStringObjectConverter {
    private static final long serialVersionUID = 6729812931433525103L;

    public Class<?> getObjectClassTo() {
        return Color.class;
    }

    public String convertStringBack(Object obj, Locale locale) throws ObjectConverterException {
        return ((Color)obj).toString();
    }

    public Object convertStringTo(String str, Locale locale) throws ObjectConverterException {
        try {
            if (str.length() == 0) {
                throw new ObjectConverterException((ObjectConverter)this, "Can't convert empty color.");
            }
            if (Character.isDigit(str.charAt(0))) {
                return Color.decode(str);
            }
            if ("blue".equalsIgnoreCase(str)) {
                return Color.BLUE;
            }
            if ("green".equalsIgnoreCase(str)) {
                return Color.GREEN;
            }
            if ("red".equalsIgnoreCase(str)) {
                return Color.RED;
            }
            throw new ObjectConverterException((ObjectConverter)this, "Can't convert color: " + str);
        }
        catch (Exception e) {
            throw new ObjectConverterException((ObjectConverter)this, e.getMessage(), e);
        }
    }

    public ObjectConverter clone() throws CloneNotSupportedException {
        ColorConverter result = new ColorConverter();
        result.converters = this.cloneConverters();
        return result;
    }
}

