/*
 * Decompiled with CFR 0.152.
 */
package org.x4o.xml.conv.text;

import java.util.Locale;
import org.x4o.xml.conv.AbstractStringObjectConverter;
import org.x4o.xml.conv.ObjectConverter;
import org.x4o.xml.conv.ObjectConverterException;
import org.x4o.xml.lang.X4OLanguageClassLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnumConverter
extends AbstractStringObjectConverter {
    private static final long serialVersionUID = 8860785472427794548L;
    private String enumClass = null;
    private Class enumObjectClass = null;

    @Override
    public Class<?> getObjectClassTo() {
        return Enum.class;
    }

    @Override
    public Object convertStringTo(String str, Locale locale) throws ObjectConverterException {
        if (this.getEnumClass() == null) {
            throw new ObjectConverterException(this, "enumClass String attribute is not set.");
        }
        String v = str;
        try {
            if (this.enumObjectClass == null) {
                this.enumObjectClass = X4OLanguageClassLoader.loadClass(this.getEnumClass());
            }
            if (this.enumObjectClass == null) {
                throw new ObjectConverterException(this, "Could not load enumClass");
            }
            return Enum.valueOf(this.enumObjectClass, v);
        }
        catch (Exception e) {
            throw new ObjectConverterException(this, e.getMessage(), e);
        }
    }

    @Override
    public String convertStringBack(Object obj, Locale locale) throws ObjectConverterException {
        return ((Enum)obj).name();
    }

    public String getEnumClass() {
        return this.enumClass;
    }

    public void setEnumClass(String enumClass) {
        this.enumClass = enumClass;
    }

    @Override
    public ObjectConverter clone() throws CloneNotSupportedException {
        EnumConverter result = new EnumConverter();
        result.converters = this.cloneConverters();
        result.enumClass = this.enumClass;
        return result;
    }
}

