/*
 * Decompiled with CFR 0.152.
 */
package org.x4o.xml.el;

import javax.el.ELContext;
import javax.el.ExpressionFactory;
import org.x4o.xml.lang.X4OLanguageClassLoader;
import org.x4o.xml.lang.X4OLanguageContext;
import org.x4o.xml.lang.X4OLanguageProperty;

public class X4OExpressionFactory {
    public static final String EL_FACTORY_IMPL_APACHE = "org.apache.el.ExpressionFactoryImpl";
    public static final String EL_FACTORY_IMPL_ODYSSEUS = "de.odysseus.el.ExpressionFactoryImpl";

    public static ExpressionFactory createExpressionFactory(X4OLanguageContext languageContext) {
        ExpressionFactory result = (ExpressionFactory)languageContext.getLanguageProperty(X4OLanguageProperty.EL_FACTORY_INSTANCE);
        if (result != null) {
            return result;
        }
        try {
            Class<?> expressionFactoryClass = X4OLanguageClassLoader.loadClass(EL_FACTORY_IMPL_APACHE);
            result = (ExpressionFactory)expressionFactoryClass.newInstance();
        }
        catch (Exception e) {
            try {
                Class<?> expressionFactoryClass = X4OLanguageClassLoader.loadClass(EL_FACTORY_IMPL_ODYSSEUS);
                result = (ExpressionFactory)expressionFactoryClass.newInstance();
            }
            catch (Exception ee) {
                throw new RuntimeException("Could not load ExpressionFactory tried: org.apache.el.ExpressionFactoryImpl and de.odysseus.el.ExpressionFactoryImpl but could not load one of them.");
            }
        }
        return result;
    }

    public static ELContext createELContext(X4OLanguageContext languageContext) {
        ELContext result = (ELContext)languageContext.getLanguageProperty(X4OLanguageProperty.EL_CONTEXT_INSTANCE);
        if (result != null) {
            return result;
        }
        try {
            result = (ELContext)X4OLanguageClassLoader.newInstance(languageContext.getLanguage().getLanguageConfiguration().getDefaultExpressionLanguageContext());
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create instance of ELContext: " + e.getMessage(), e);
        }
        return result;
    }
}

