/*
 * Decompiled with CFR 0.152.
 */
package org.x4o.xml.element;

import java.util.logging.Logger;
import org.x4o.xml.element.Element;
import org.x4o.xml.element.ElementClass;
import org.x4o.xml.element.ElementNamespaceContext;
import org.x4o.xml.element.ElementNamespaceInstanceProvider;
import org.x4o.xml.element.ElementNamespaceInstanceProviderException;
import org.x4o.xml.lang.X4OLanguage;
import org.x4o.xml.lang.X4OLanguageClassLoader;
import org.x4o.xml.lang.X4OLanguageContext;

public class DefaultElementNamespaceInstanceProvider
implements ElementNamespaceInstanceProvider {
    private Logger logger = Logger.getLogger(DefaultElementNamespaceInstanceProvider.class.getName());
    private ElementNamespaceContext elementNamespaceContext = null;

    public void start(X4OLanguage language, ElementNamespaceContext elementNamespaceContext) {
        this.elementNamespaceContext = elementNamespaceContext;
        this.logger.finer("Starting DefaultElementNamespaceInstanceProvider for: " + elementNamespaceContext.getUri());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Element createElementInstance(X4OLanguageContext languageContext, String tag) throws ElementNamespaceInstanceProviderException {
        ElementClass elementClass = this.elementNamespaceContext.getElementClass(tag);
        Element element = null;
        if (elementClass == null) {
            throw new ElementNamespaceInstanceProviderException(this, "Tag: " + tag + " unknown in: " + this.elementNamespaceContext.getUri());
        }
        try {
            if (elementClass.getElementClass() != null) {
                Object obj = X4OLanguageClassLoader.newInstance(elementClass.getElementClass());
                if (!(obj instanceof Element)) throw new ElementNamespaceInstanceProviderException(this, "Provided elementClassName is not an Element: " + obj.getClass());
                element = (Element)obj;
            } else {
                element = (Element)X4OLanguageClassLoader.newInstance(languageContext.getLanguage().getLanguageConfiguration().getDefaultElement());
            }
            if (elementClass.getObjectClass() != null) {
                element.setElementObject(X4OLanguageClassLoader.newInstance(elementClass.getObjectClass()));
            }
        }
        catch (InstantiationException e) {
            throw new ElementNamespaceInstanceProviderException(this, "Error while providing Element: " + e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            throw new ElementNamespaceInstanceProviderException(this, "Error while providing Element: " + e.getMessage(), e);
        }
        element.setElementClass(elementClass);
        element.setLanguageContext(languageContext);
        return element;
    }
}

