/*
 * Decompiled with CFR 0.152.
 */
package org.x4o.xml.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.util.HashMap;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import org.x4o.xml.io.AbstractX4OReader;
import org.x4o.xml.io.X4OConnectionException;
import org.x4o.xml.io.sax.X4ODebugWriter;
import org.x4o.xml.io.sax.ext.ContentWriter;
import org.x4o.xml.io.sax.ext.ContentWriterXml;
import org.x4o.xml.lang.X4OLanguageContext;
import org.x4o.xml.lang.X4OLanguageContextLocal;
import org.x4o.xml.lang.X4OLanguageProperty;
import org.x4o.xml.lang.X4OLanguagePropertyKeys;
import org.x4o.xml.lang.phase.X4OPhaseException;
import org.x4o.xml.lang.phase.X4OPhaseType;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultX4OReader<T>
extends AbstractX4OReader<T> {
    private Logger logger = Logger.getLogger(DefaultX4OReader.class.getName());

    public DefaultX4OReader(X4OLanguageContext elementLanguage) {
        super(elementLanguage);
    }

    @Override
    public X4OLanguageContext readContext(InputStream input, String systemId, URL basePath) throws X4OConnectionException, SAXException, IOException {
        this.setProperty(X4OLanguagePropertyKeys.READER_INPUT_STREAM, input);
        this.setProperty(X4OLanguagePropertyKeys.READER_INPUT_SYSTEM_ID, systemId);
        this.setProperty(X4OLanguagePropertyKeys.READER_INPUT_BASE_PATH, basePath);
        this.read();
        return this.getLanguageContext();
    }

    @Override
    public void addELBeanInstance(String name, Object bean) {
        if (name == null) {
            throw new NullPointerException("Can't add null name.");
        }
        if (name.length() == 0) {
            throw new NullPointerException("Can't add empty name.");
        }
        if (bean == null) {
            throw new NullPointerException("Can't add null bean.");
        }
        HashMap<String, Object> map = (HashMap<String, Object>)this.getProperty(X4OLanguagePropertyKeys.EL_BEAN_INSTANCE_MAP);
        if (map == null) {
            map = new HashMap<String, Object>(20);
            this.setProperty(X4OLanguagePropertyKeys.EL_BEAN_INSTANCE_MAP, map);
        }
        this.logger.finer("Adding el bean: " + name + " type: " + bean.getClass());
        map.put(name, bean);
    }

    protected void read() throws X4OConnectionException, SAXException, IOException {
        X4OLanguageContext languageContext = this.getLanguageContext();
        if (languageContext.getLanguage() == null) {
            throw new X4OConnectionException("languageContext is broken getLanguage() returns null.");
        }
        boolean startedDebugWriter = false;
        Object debugOutputHandler = languageContext.getLanguageProperty(X4OLanguageProperty.DEBUG_OUTPUT_HANDLER);
        Object debugOutputStream = languageContext.getLanguageProperty(X4OLanguageProperty.DEBUG_OUTPUT_STREAM);
        if (languageContext.getX4ODebugWriter() == null) {
            ContentWriter xmlDebugWriter = null;
            if (debugOutputHandler instanceof ContentWriter) {
                xmlDebugWriter = (ContentWriter)debugOutputHandler;
            } else if (debugOutputStream instanceof OutputStream) {
                xmlDebugWriter = new ContentWriterXml((OutputStream)debugOutputStream);
            }
            if (xmlDebugWriter != null) {
                xmlDebugWriter.startDocument();
                xmlDebugWriter.startPrefixMapping("debug", "http://language.x4o.org/xml/ns/debug-output");
                X4ODebugWriter debugWriter = new X4ODebugWriter(xmlDebugWriter);
                X4OLanguageContextLocal local = (X4OLanguageContextLocal)languageContext;
                local.setX4ODebugWriter(debugWriter);
                startedDebugWriter = true;
            }
        }
        if (languageContext.hasX4ODebugWriter()) {
            AttributesImpl atts = new AttributesImpl();
            atts.addAttribute("", "language", "", "", languageContext.getLanguage().getLanguageName());
            atts.addAttribute("", "currentTimeMillis", "", "", System.currentTimeMillis() + "");
            languageContext.getX4ODebugWriter().getContentWriter().startElement("http://language.x4o.org/xml/ns/debug-output", "X4ODriver", "", atts);
        }
        try {
            this.getLanguageContext().getLanguage().getPhaseManager().runPhases(this.getLanguageContext(), X4OPhaseType.XML_READ);
        }
        catch (Exception e) {
            if (languageContext.hasX4ODebugWriter()) {
                try {
                    AttributesImpl atts = new AttributesImpl();
                    atts.addAttribute("", "message", "", "", e.getMessage());
                    if (e instanceof X4OPhaseException) {
                        atts.addAttribute("", "phase", "", "", ((X4OPhaseException)e).getX4OPhaseHandler().getId());
                    }
                    languageContext.getX4ODebugWriter().getContentWriter().startElement("http://language.x4o.org/xml/ns/debug-output", "exceptionStackTrace", "", atts);
                    StringWriter writer = new StringWriter();
                    PrintWriter printer = new PrintWriter(writer);
                    printer.append('\n');
                    if (e.getCause() == null) {
                        e.printStackTrace(printer);
                    } else {
                        e.getCause().printStackTrace(printer);
                    }
                    char[] stack = writer.getBuffer().toString().toCharArray();
                    languageContext.getX4ODebugWriter().getContentWriter().characters(stack, 0, stack.length);
                    languageContext.getX4ODebugWriter().getContentWriter().endElement("http://language.x4o.org/xml/ns/debug-output", "exceptionStackTrace", "");
                }
                catch (Exception ee) {
                    this.logger.warning(ee.getMessage());
                }
            }
            if (e.getCause() instanceof ParserConfigurationException) {
                throw new X4OConnectionException((ParserConfigurationException)e.getCause());
            }
            if (e.getCause() instanceof SAXException) {
                throw (SAXException)e.getCause();
            }
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            if (e.getCause() == null) {
                throw new SAXException(e);
            }
            throw new SAXException((Exception)e.getCause());
        }
        finally {
            if (languageContext.hasX4ODebugWriter()) {
                languageContext.getX4ODebugWriter().getContentWriter().endElement("http://language.x4o.org/xml/ns/debug-output", "X4ODriver", "");
            }
            if (startedDebugWriter && languageContext.hasX4ODebugWriter()) {
                languageContext.getX4ODebugWriter().getContentWriter().endPrefixMapping("debug");
                languageContext.getX4ODebugWriter().getContentWriter().endDocument();
                if (debugOutputStream instanceof OutputStream) {
                    OutputStream outputStream = (OutputStream)debugOutputStream;
                    outputStream.flush();
                    outputStream.close();
                }
            }
        }
    }

    @Override
    public void releaseContext(X4OLanguageContext context) throws X4OPhaseException {
        if (context == null) {
            return;
        }
        if (context.getLanguage() == null) {
            return;
        }
        if (context.getLanguage().getPhaseManager() == null) {
            return;
        }
        context.getLanguage().getPhaseManager().doReleasePhaseManual(context);
    }
}

