// ****************************************************************************
// * YaNuCa Version 1.0 | (c) 2003-2008 by Dominic König (nursix.org)         *
// ****************************************************************************
// * yatables.js : Daten- und Faktortabellen                                  *
// ****************************************************************************
// * This program is free software: you can redistribute it and/or modify     *
// * it under the terms of the GNU Affero General Public License as published *
// * by the Free Software Foundation, either version 3 of the License, or     *
// * (at your option) any later version.                                      *
// *                                                                          *
// * This program is distributed in the hope that it will be useful,          *
// * but WITHOUT ANY WARRANTY; without even the implied warranty of           *
// * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the            *
// * GNU Affero General Public License for more details.                      *
// *                                                                          *
// * You should have received a copy of the GNU Affero General Public License *
// * along with this program.  If not, see <http://www.gnu.org/licenses/>.    *
// *                                                                          *
// * For more information about nursix.org, please visit us at                *
// * our website at http://www.nursix.org                                     *
// ****************************************************************************

// ****************************************************************************
// yaStressFaktor: Multiplikatoren für den Grundumsatz, maximal 1.4!

var yaStressFaktor = {

  CriticalInitial         : 0.5,  // Kritische Erkrankung, Initiale Ebb-Phase
  CriticalHyperCatabolic  : 1.0,  // Kritische Erkrankung, Hyperkatabole Flow-Phase
  CriticalAnabolic        : 1.4,  // Kritische Erkrankung, Anabole Flow-Phase
  NonCriticalPassive      : 1.1,  // Nicht-kritische Erkrankung, elektive Intensivtherapie
  NonCriticalActive       : 1.2,  // Nicht-kritische Erkrankung, Mobilisationsphase
  MinorStress             : 1.3,  // Unruhezustände, Polytrauma, protrahierte Sepsis
  MajorStress             : 1.4   // Schwere Verbrennungen und Traumata, Hirntrauma

};

// ****************************************************************************
// yaProteinZufuhr: Standardwerte für die Proteinzufuhr in g/kg*d

var yaProteinZufuhr = {

  manMinimum  : 0.5,
  autoMinimum : 1.0,
  Standard    : 1.2,
  autoMaximum : 1.5,
  manMaximum  : 2.5

};

// ****************************************************************************
// yaGlucoseZufuhr: Standardwerte für die Glucosezufuhr in g/kg*d

var yaGlucoseZufuhr = {

  manMinimum  : 0.0,
  autoMinimum : 2.0,
  Standard    : 3.0,
  autoMaximum : 4.5,
  manMaximum  : 6.0

};

// ****************************************************************************
// yaFettZufuhr: Standardwerte für die Fettzufuhr in g/kg*d

var yaFettZufuhr = {

  manMinimum  : 0.0,
  autoMinimum : 0.0,
  Standard    : 1.2,
  autoMaximum : 2.1,
  manMaximum  : 3.0

};

// ****************************************************************************
// yaSpezEnergie: der spezifische Energiegehalt der Makronährstoffe (kcal/g)

var yaSpezEnergie = {

  Protein: 4.0,
  KH     : 4.0,
  Fett   : 10.0

};

// ****************************************************************************
// Protein-Utilisations-Limit:
// Der maximale Anteil von Protein-Energie an der Gesamtenergiezufuhr, bei dem
// das Protein nur unwesentlich zur Energiegewinnung benutzt wird. Dieses Limit
// ist natürlich nur dann sinnvoll, wenn auch der Gesamtenergiebedarf gedeckt
// ist

var yaProteinUtilisationsLimit = 0.25;

// ****************************************************************************
// manueller Proteinzufuhr-Bereich, Grenzwerte

var yaManProteinMin = new Array( 0.6, 0.8, 1.0, 1.2, 1.5, 2.0 );
var yaManProteinStd = new Array( 0.8, 1.0, 1.2, 1.5, 1.8, 2.2 );
var yaManProteinMax = new Array( 1.0, 1.2, 1.5, 1.8, 2.1, 2.5 );

// ****************************************************************************
// manuelle Energiezufuhr

var yaManEnergie = new Array( 10, 15, 20, 25, 30, 35, 40, 45 );

// ****************************************************************************
// manuelle GlucoseMaxima

var yaManGlucoseMin = new Array( 1.0, 1.0 );
var yaManGlucoseMax = new Array( 3.0, 2.0 );

// ****************************************************************************
// yaMaxEnteraleToleranz: relative Unterschreitung von Substratmengen bei der
//                        Sondenernährung, aber der parenteral ergänzt wird,
//                        optimaler Wert könnte 5 bis 10%, aber auch 0 sein.

var yaMaxEnteraleToleranz = 0.05;

// ****************************************************************************
// yaMaximumDefizit: Maximale Unterdeckung des Energiebedarfs in kcal

var yaMaximumDefizit = 100;

// ****************************************************************************
// yaMaximumOralDefizit: Maximale Unterdeckung durch oralen Kostaufbau in kcal

var yaMaximumOralDefizit = 250;

// ****************************************************************************
// yaReduktionsStufe: Reduktionsstufen für oralen Kostaufbau in kcal/d:

var yaReduktionsStufe = new Array ( 250, 500, 1000 );

// ****************************************************************************
// yaOraleNahrung: Nährstoffpräferenzen in der oralen Kost (in %):

var yaOraleNahrung = {

  Protein: 15,
  KH     : 60,
  Fett   : 25
}

// ****************************************************************************
// yaStandardRate: Standard-Laufraten für Sondenkost in den Aufbaustufen

var yaStandardRate = new Array( 10, 25, 50, 75, 150 );

// ****************************************************************************
// ENDE
// ****************************************************************************
