{$IFDEF WINDOWS}
{$N-,V-,W-,G+,R-}
{$ELSE}
{$N-,E-,V-,O+,F+,R-}
{$ENDIF}

Unit bibReadB;

Interface

Uses
  bibstrg,  bibtext, bibvars, bibfile, bibutil, bibwild, bibPchec, bib8bit,
  rc_strng, bibcache, lfnunit,
{$IFDEF WINDOWS}
  wbibdisp, wbibbin, wObjects, WinProcs, streams;
{$ELSE}
  objects,bibdisp;
{$ENDIF}


procedure GotoStart(S: PStream; Entry: EntryRecPtr);
procedure GetEntry(Entry: EntryRecPtr; S: PStream; ToEntry: Word;
                   WholeEntryRead: boolean;
                   Pattern: PatRecPtr; var ok: boolean);

Implementation

var
  ReadBS,ANewLine: boolean;
  IgnoreSpec: integer;
  table1,table2: string[5];

function EOF_bib(S: PStream): boolean;
begin
  if S=Nil then EOF_bib:=eof(bib)
  else EOF_Bib:=(S^.Status<>stok) or (S^.GetPos>=S^.GetSize);
end;

procedure Skip(S: PStream);
var
  ch: char;
begin
  if S=Nil then SkipOneLine(bib,UnixBib)
  else begin
    ch:=#0;
    if not ReachedEol then
      while (ch<>#10) and (not eof_bib(S)) do S^.read(ch,1);
    ReachedEol:=false;
  end;
end;            { Skip }

procedure RdString(S: PStream; var line: string);
var
  ch: char;
  i: integer;
begin
  if S=Nil then ReadString(bib,line,UnixBib)
  else begin
    if S^.Status<>stOK then Exit;
    S^.read(ch,1); if S^.Status<>stOK then Exit;
    i:=1;
    while (ch<>#10) and (not eof_bib(S)) and (i<=255) do
    begin
      line[i]:=ch; inc(i); 
      if i<=255 then S^.read(ch,1);
      if S^.Status<>stOK then Exit;
    end;
    i:=i-1;
    if (i>0) and (line[i]=#13) then line[0]:=char(i-1)
    else line[0]:=char(i);
    ReachedEol:=(ch=#10);
  end;
end;              { RdString }

procedure GetLine(S: PStream; Var line: string);
var
  i,j: word;
begin                       { GetLine }
  WinYield;
  while IsEmpty(line) and (not eof_bib(S)) do
  begin
    if ReachedEol and not AtStartOfFile then
    begin
      ReadBS:=false; Skip(S); ANewLine:=true;
    end else ANewLine:=AtStartOfFile;
    RdString(S,Line);
    AtStartOfFile:=false;
    for i:=1 to length(line) do
    begin
      if line[i]=#9 then line[i]:=' ';
      if ((i=1) and ReadBS) or ((i>1) and (line[i-1]='\')) then
      begin
        j:=Pos(line[i],table1);
        if (j>0) and (j<>IgnoreSpec) then line[i]:=table2[j];
      end;
    end;
    ReadBS:=(line<>'') and (line[length(line)]='\');
    LastReadLine^:=line;
  end;
end;                             { GetLine }

procedure GetLineNo(S: Pstream; Var line: string);
var
  i,sl: integer;
begin                       { GetLineNo }
  WinYield;
  while IsEmpty(line) and (not eof_bib(S)) do
  begin
    if ReachedEol and not AtStartOfFile then
    begin
      ReadBS:=false; Skip(S); ANewLine:=true;
    end else ANewLine:=AtStartOfFile;
    RdString(S,line);
    AtStartOfFile:=false;
    i:=length(line);
    if (i>0) and (line[i]='\') then
    begin
      sl:=i-1;
      while (sl>0) and (line[sl]='\') do dec(sl);
      ReadBS:=(sl-i) mod 2 = 1;
    end else ReadBS:=false;
    LastReadLine^:=line;
  end;
end;                             { GetLineNo }

procedure GotoStart(S: PStream; Entry: EntryRecPtr);
begin
  if S=Nil then ResetBib(Entry)
  else begin
    ZeroEntry(Entry); Entry^.EntryType:='';
    LastReadLine^:='';
    S^.reset; S^.seek(0);
    AtStartOfFile:=true; ReachedEOL:=false;
  end;
end;                     { GotoStart }

procedure ReadEntry(Entry: EntryRecPtr; S: PStream; var etype: integer;
                    WholeEntryRead: boolean; match: string; 
                    Exact,CaseSen,RegExp: Boolean; var matched,ok: Boolean);
Label
  EntryError;
var
  line,tmp: string;
  i,iii,j,k,pl,CurMaxBig,Blength: word;
  nbr,nbrl,nbrr,multiple,Ind    : integer;
  ifld,CurrentBuffer            : byte;
  ch,ch2,Delimiter,firstch,comma: char;
  enough,quote,finished,leave,NotNumber,SkipLine,FoundComma   : boolean;
  IsDelimited,IsZero,IsStringEntry,FinishedWithEntry,BareQuote: boolean;
  IsPreambleEntry,IsBinary: boolean;
  Buffer : BigTypePtr;
  SBuffer: array[1..256] of char;
{$IFDEF WINDOWS}
  BinObject: PBinObject;
  Pstr     : PStream;
  BinName  : PString;
{$ENDIF}

begin                            { ReadEntry }
  fieldlast:=DefFieldLast;
  line:=LastReadLine^; ReadBS:=false;
  IsStringEntry:=(etype>NumberOfTypes);
  IsPreambleEntry:=(Etype=PreambleTypeInd);
  if IsPreambleEntry then comma:=#0
  else if IsStringEntry then comma:='='
  else comma:=',';
  if AlwaysRead then WholeEntryRead:=true;
  matched:=(match='');
  CurMaxBig:=MaxBig;
  Buffer:=Nil; CurrentBuffer:=255;
  MaxMemAvail;
  GetLine(S,line);
  ok:=true;
  IgnoreSpec:=0;
  with Entry^ do
  begin
{$IFDEF WINDOWS}
    BinName:=Nil;
    BinList^.FreeAll;
{$ENDIF}
    EntryType:=TypeEntry^[etype];
    LastField:=DefFieldLast; nentry:=0;
    if IsPreambleEntry then
    begin
      name:=PreambleEntryName; FoundComma:=true;
    end else
    begin
      name:=''; FoundComma:=false;
      k:=Pos(comma,line);
      if k=0 then
      begin
        k:=length(line)+1; if k>1 then PStrCopy(name,line,1,k-1); line:='';
        if not ReachedEol then
        begin
          GetLine(S,line);
          k:=Pos(comma,line);
          if (k>0) then
          begin
            FoundComma:=true;
            PStrCat(name,Copy(line,1,k-1),sizeof(name)-1);
            Delete(line,1,k-1);
          end else line:='';
        end;
      end else
      begin
        FoundComma:=true;
        PStrCopy(name,line,1,k-1); Delete(line,1,k-1);
      end;
      ChrDelR(name,' '); ChrDelL(name,' ');
      if name='' then goto EntryError;
      for j:=1 to length(name) do if name[j] in NameForbid then
      begin
        tmp:=StringRC(Str_IllegalCharInName,name);
        name:=''; goto EntryError;
      end;
      if not matched then
      begin
        if Exact then matched:=(name=match)
        else if RegExp then
          matched:=PartMatch(match,name[1],length(name),CaseSen)
        else begin
          tmp:=name; if not CaseSen then StrLwr(tmp);
          matched:=(Pos(match,tmp)>0);
        end;
      end;
      if not (matched and (AlwaysRead or WholeEntryRead)) then
      begin
        Buffer:=Nil; ok:= (name<>'');
        Exit;
      end;
    end;
                            { Finished with name, now read body }
    nentry:=0;
    for ifld:=1 to maxfield+1 do
    begin
      index[ifld]:=0; BigIndex[ifld]:=0;
    end;
    for iii:=1 to MaxNumberBig do
    begin
      BigFree[iii]:=true; Blen[iii]:=0;
    end;
    ChrDelL(line,' ');
    while (not EOF_bib(S)) and (line='') do
    begin
      GetLine(S,line); ChrDelL(line,' ');
    end;
    if (line<>'') and (line[1]=comma) then
    begin
      FoundComma:=true; Delete(line,1,1);
    end;
    if (not FoundComma) and (Verbosity>2) then
      ErrorMessageRC(Str_MissingComma,entry^.name);
    repeat
      IgnoreSpec:=0;
      SkipLine:=false;
      k:=1; while (k<=length(line)) and (line[k] in [' ',',']) do inc(k);
      Delete(line,1,k-1);
      while (not EOF_bib(S)) and (line='') do
      begin
        GetLine(S,line);
        k:=1; while (k<=length(line)) and (line[k] in [' ',',']) do inc(k);
        Delete(line,1,k-1)
      end;
      if line='' then SkipLine:=true;
      FinishedWithEntry:=false;
      if (line<>'') and (line[1] in [rbrace,')']) then
      begin
        FinishedWithEntry:=true;
        delete(line,1,1);
        k:=0; nbr:=-1;
      end else if IsStringEntry then k:=0
      else begin
        k:=1;
        while (k<=length(line)) and (line[k]<>' ') and (line[k]<>'=') do inc(k);
      end;
      if (IsStringEntry and not FinishedWithEntry) or (k>0) then
      begin                         { Start reading field contents }
{        Inc(nentry); Content[nentry]:='';}
        IsBinary:=false;
{$IFDEF WINDOWS}
        BinObject:=Nil;
{$ENDIF}
        CurrentBuffer:=FindBigFree(Entry,false);
        if CurrentBuffer=0 then                  { All big fields are full }
        begin
          Buffer:=@SBuffer[1]; CurMaxBig:=255;
        end else
        begin
          Buffer:=@Entry^.Big[CurrentBuffer]^[1]; CurMaxBig:=MaxBig;
        end;
        Blength:=0;
        if IsStringEntry then
        begin
          Inc(nentry); Content[nentry]:='';
          field[nentry]:=typefield^[StringIndex];
          ifld:=StringIndex; index[StringIndex]:=nentry;
        end else
        begin
          PStrCopy(tmp,line,1,k-1); ChrDel(tmp,' ');
          if k>length(line) then
          begin
            line:='';
            GetLine(S,line);
            k:=1;
            while (k<=length(line)) and (line[k]<>' ') and (line[k]<>'=') do inc(k);
            if k>length(line) then k:=0;
            if k>0 then
            begin
              j:=k-1;
              while (j>0) and (line[j]=' ') do dec(j);
              if j>sizeof(field[1])-length(tmp)-1 then
                j:=sizeof(field[1])-length(tmp)-1;
              PStrCat(tmp,Copy(line,1,j),sizeof(field[1])-1);
              Delete(line,1,k);
            end else
            begin
              tmp:=StringRC(Str_CantFindFieldStart,''); goto EntryError;
            end;
          end else Delete(line,1,k);
          ChrDelR(tmp,' '); ChrDelL(tmp,' ');
          if tmp='' then
          begin
            tmp:=StringRC(Str_FieldNameEmpty,''); goto EntryError;
          end;
          if Pos(lbrace,tmp)+Pos(rbrace,tmp)+Pos(' ',tmp)>0 then
          begin
            tmp:=StringRC(Str_IllegalCharInFname,tmp);
            goto EntryError;
          end;
          StrLwr(tmp);
{$IFDEF WINDOWS}
                       { Look for binary fields }
          if (BinaryFields<>Nil) and (Pos(BinaryFields^,tmp)=1) then
          begin
            if BinName<>Nil then DisposeStr(BinName);
            IsBinary:=true; BinObject:=Nil;
            BinName:=NewStr(Copy(tmp,length(BinaryFields^)+1,255));
          end;
{$ENDIF}
          if not IsBinary then
          begin
            Inc(nentry); Content[nentry]:='';
            ifld:=0; enough:=false;
            field[nentry]:=tmp;
            repeat
              inc(ifld);
              if field[nentry]=TypeField^[ifld] then
              begin
                enough:=true;
                index[ifld]:=nentry;
              end;
            until enough or (ifld>=fieldlast);
            if not enough then
            begin
              if fieldlast<maxfield then   { New field }
              begin
                Inc(fieldlast);
                ifld:=fieldlast;
                with FieldParams^[ifld] do
                begin
                  authorlike:=false;
                  if AltName<>Nil then DisposeStr(AltName); AltName:=Nil;
                end;
                index[ifld]:=nentry;
                TypeField^[ifld]:=field[nentry];
                DumpFields[ifld]:=DumpUndecFields;
              end else field[nentry]:='';
            end;
          end;
        end;
        { Reach the field contents }
        repeat
          GetLine(S,line);
          k:=1;
          while (k<=length(line)) and (line[k] in [' ','=']) do inc(k);
          Delete(line,1,k-1);
        until (EOF_bib(S)) or (line<>'');
        
        { GetLine(line); ChrDelL(line,' '); }
        Delimiter:=#127;
        nbr:=0; IsDelimited:=false; IsZero:=false;
        IgnoreSpec:=0;
        firstch:=line[1];
        if firstch=lbrace then
        begin
          nbr:=1; delimiter:=rbrace; IsDelimited:=true;
        end else if firstch='"' then
        begin
          nbr:=1; delimiter:='"'; IsDelimited:=true;
{          IgnoreSpec:=QuotePlace;
          StrRepl(line,table2[QuotePlace],table1[QuotePlace],1,255,255);}
        end else if firstch<>' ' then IsZero:=true;
        if firstch in [lbrace,'"'] then
        begin
          Delete(line,1,1); ChrDelL(line,' ');
        end;
        { Read the field contents }
        repeat
          GetLine(S,line);
          finished:=false;
          i:=0;
          while (nbr>=0) and (i<length(line)) and (not finished) do
          begin
            inc(i); ch:=line[i];
            if ch<>' ' then
            begin
              if (nbr=0) then
              begin
                if ch in [lbrace,'"'] then
                begin
                  Inc(nbr); IsDelimited:=true;
                  IgnoreSpec:=0;
                  if ch='"' then
                  begin
                    Delimiter:='"';
                  end else Delimiter:=rbrace;
                end else if ch in [rbrace,')'] then
                begin
                  Dec(nbr); finished:=true;
                end else if ch=',' then finished:=true
                else IsZero:=true;
              end else if (ch=lbrace) then inc(nbr)
              else if (nbr=1) and (ch=delimiter) then
              begin
                Dec(nbr);
              end else if (ch=rbrace) then dec(nbr);
            end;
          end;
          if (nbr<0) or ((nbr=0) and (ch=',')) then
          begin
            PStrCopy(tmp,line,1,i-1); Delete(line,1,i);
          end else
          begin
            tmp:=line; line:='';
          end;
          if IsBinary then     { A binary object field }
          begin
{$IFDEF WINDOWS}
            ChrDel(tmp,' ');
            i:=Pos(Delimiter,tmp); if i>0 then tmp[0]:=Chr(i-1);
            tmp:=tmp+ZeroEncodingChar+ZeroEncodingChar+ZeroEncodingChar;
            if BinObject=Nil then
              New(BinObject,FirstCodedSegment(@tmp,BinName))
            else BinObject^.AddCodedSegment(@tmp);
{$ENDIF}
          end else
          begin
            if ReachedEol then ChrDelR(tmp,' ');
            if (Blength=0) or (Buffer^[Blength]=' ') or ANewLine
                                                 then ChrDelL(tmp,' ');
            for i:=length(tmp) downto 2 do
              if (tmp[i]=' ') and (tmp[i-1]=' ') then Delete(tmp,i,1);
            StrCut(tmp,imin(CurMaxBig-Blength,255));
            if (tmp<>'') and (tmp<>' ') then
            begin
              if ANewLine and (Blength>0) and (Blength<CurMaxBig) and
                 (Buffer^[Blength]<>' ') then
              begin
                inc(Blength); Buffer^[Blength]:=' '; Buffer^[Blength+1]:=#0;
              end;
              move(tmp[1],Buffer^[Blength+1],length(tmp));
              Blength:=Blength+length(tmp);
            end else tmp:='';
          end;
        until (EOF_bib(S)) or finished;
{$IFDEF WINDOWS}
        if IsBinary and (BinObject<>Nil) then
        begin
          if BinObject^.IsOk and BinObject^.CheckCRC and
            not BinList^.Search(BinList^.KeyOf(BinObject),Ind) then
              BinList^.AtInsert(Ind,BinObject)
          else begin          { Problems }
            if verbosity>2 then
            begin
              if (not BinObject^.IsOk) then ErrorMessageRC(Str_BadBinaryField,'')
              else ErrorMessageRC(Str_DuplicateBinary,BinObject^.Name);
            end;
            Dispose(BinObject,Done);
          end;
          BinObject:=Nil;
        end;
{$ENDIF}
        if not IsBinary then      { Post-processing }
        begin
          if (firstch in [lbrace,'"']) then
          begin
            if IsDelimited and IsZero then        { A string including Cat }
            begin
              for iii:=imin(CurMaxBig,Blength+2) downto 3 do
                Buffer^[iii]:=Buffer^[iii-2];
              Buffer^[1]:='@'; Buffer^[2]:=firstch;
              Blength:=Blength+2;
            end else
            begin
              if firstch=lbrace then firstch:=rbrace;
              iii:=Blength;
              while (iii>0) and (Buffer^[iii]<>firstch) do Dec(iii);
              if iii>0 then Blength:=iii-1;
            end;
          end else if IsZero and IsDelimited then
          begin
            for iii:=imin(CurMaxBig,Blength+1) downto 2 do
              Buffer^[iii]:=Buffer^[iii-1];
            Buffer^[1]:='@'; 
            Blength:=Blength+1;;
          end else if IsZero then
          begin
            NotNumber:=false;
            if Blength>0 then
            begin
              for iii:=1 to Blength-1 do if not (Buffer^[iii] in ['0'..'9']) then
                NotNumber:=true;
              if not (Buffer^[Blength] in ['0'..'9',' ']) then
                NotNumber:=true;
            end;
            if NotNumber then
            begin
              for iii:=imin(CurMaxBig,Blength+1) downto 2 do
                Buffer^[iii]:=Buffer^[iii-1];
              Buffer^[1]:='@';
              Inc(Blength);
            end;
          end;
          while (Blength>0) and (Buffer^[Blength]=' ') do Dec(Blength);

          for iii:=2 to Blength do             { Unescape the escaped characters }
          if buffer^[iii-1]='\' then
          begin
            i:=Pos(Buffer^[iii],table2);
            if i>0 then Buffer^[iii]:=table1[i];
          end;

          if field[nentry]='' then dec(nentry)
          else begin
            if ifld=StringIndex then
            begin
              if Prog8Bit then
              begin
                if File8Bit then
                   File8ToProg8(Buffer^,Blength,false,CurMaxBig)
                else
                  Conv28Bit(Buffer^,Blength,false)
              end else if Prog7Bit then
                Conv27BitFile(Buffer^,Blength,false,CurMaxBig,true);
            end else
            begin
              if Prog8Bit then
              begin
                if File8Bit then
                   File8ToProg8(Buffer^,Blength,FieldParams^[ifld].AuthorLike,
                                CurMaxBig)
                else
                  Conv28Bit(Buffer^,Blength,FieldParams^[ifld].AuthorLike)
              end else if Prog7Bit then
                Conv27BitFile(Buffer^,Blength,FieldParams^[ifld].AuthorLike,
                              CurMaxBig,true);
            end;
            if not okfield(Buffer^,Blength,Verbosity,
            ' Unpaired braces/quotes in entry "'+name+'", field "'+field[nentry]+'"! ',
            ' Syntax error (missing "'+lbrace+'"?) in entry "'+name+'", field "'+
                   field[nentry]+'"! ', BareQuote) then
            begin
  {            tmp:=''; Goto EntryError;}
              Blength:=0;
            end;

            { Move buffer content to entry }
        
            Content[nentry]:='';
            if Blength>255 then
            begin
              Move(Buffer^[1],Content[nentry][1],255);
              Content[nentry][0]:=#255;
              Entry^.BigFree[CurrentBuffer]:=false;
              BigIndex[ifld]:=CurrentBuffer;
              Blen[CurrentBuffer]:=Blength;
            end else
            begin
              Move(Buffer^[1],Content[nentry][1],Blength);
              Content[nentry][0]:=Chr(Blength);
              if RetainNullFields and (Content[nentry]='') then
                Content[nentry]:=EmptyFieldChar;
            end;
          end;
        end;
      end;
    until FinishedWithEntry or (nbr<0) or (EOF_bib(S)) or ((not SkipLine) and (k=0));
    LastReadLine^:=line;
    if (not RetainNullFields) then
    begin
      nentry:=0;
      for i:=1 to maxfield do
      begin
        if content[i]<>'' then
        begin
          iii:=0;
          if index[StringIndex]=i then
          begin
            Inc(nentry);
            content[nentry]:=content[i];
            index[StringIndex]:=nentry;
          end else while (iii<fieldlast) do
          begin
            Inc(iii);
            if index[iii]=i then
            begin
              Inc(nentry);
              content[nentry]:=content[i];
              index[iii]:=nentry;
              iii:=fieldlast+1;
            end;
          end;
        end else
        begin
          for iii:=1 to fieldlast do if index[iii]=i then index[iii]:=0;
          if index[StringIndex]=i then index[StringIndex]:=0;
        end;
      end;
    end;
  end;
  if S=Nil then
    entry^.ending:=TextFilePos(bib)-length(LastReadLine^)
  else
    entry^.ending:=S^.GetPos-length(LastReadLine^);
  if (length(LastReadLine^)=0) and UnixBib and (not ReachedEol)
     and (not EOF_bib(S)) then
  begin
    ReadBS:=false;
    RdString(S,LastReadLine^);
    if LastReadLine^='' then
    begin
      entry^.ending:=entry^.ending+1;
    end else
    begin
      for i:=1 to length(LastReadLine^) do
      begin
        if LastReadLine^[i]=#9 then LastReadLine^[i]:=' ';
        if ((i=1) and ReadBS) or ((i>1) and (LastReadLine^[i-1]='\')) then
        begin
          j:=Pos(LastReadLine^[i],table1);
          if j>0 then LastReadLine^[i]:=table2[j];
        end;
      end;
      ReadBS:=(LastReadLine^<>'') and (LastReadLine^[length(LastReadLine^)]='\');
    end;
  end else
  begin
    if (length(LastReadLine^)=0) and ReachedEol then
    begin
      if UnixBib then entry^.ending:=entry^.ending+1
      else begin
        Skip(S);
        if S=Nil then entry^.ending:=TextFilePos(bib)
        else Entry^.Ending:=S^.GetPos;
        ReachedEol:=false;
      end
    end;
    if UnixBib and ReachedEol and (entry^.ending>0) then dec(entry^.ending);
  end;
  if entry^.ending>0 then dec(entry^.ending);
  entry^.LastField:=FieldLast; ok:=true;
  IgnoreSpec:=0;
  if nbr>=0 then
  begin
    tmp:=''; Entry^.Name:=''; goto EntryError;
  end;
{  if IsPreambleEntry then Entry^.EntryType:=TypeEntry^[StringTypeInd];}
{$IFDEF WINDOWS}
  if BinName<>Nil then DisposeStr(BinName);
{$ENDIF}
  Exit;
  
  EntryError:

  if (Verbosity>2) and (tmp<>'') and (entry^.name<>'') then
  begin
    ErrorMessage(tmp+' in Entry "'+entry^.name+'"!');
  end;
  LastReadLine^:=line;
  entry^.nentry:=0;
  matched:=false; ok:=false;
  IgnoreSpec:=0;
{$IFDEF WINDOWS}
  if BinName<>Nil then DisposeStr(BinName);
{$ENDIF}
end;                             { ReadEntry }

procedure GetEntry(Entry: EntryRecPtr; S: PStream; toentry: Word;
                   WholeEntryRead: boolean;
                   Pattern: PatRecPtr; var ok: boolean);
var
  line,tmp: string;
  j,k,lmatch,count,QuotePlace : integer;
  i,pl: word;
  enough,leave,BeginBrace,foundit: boolean;
  CaseSen,RegExp,Exact,rok,BeyondLimit: boolean;
  ifld : byte;
  etype: integer;
  OldPlace: longint;

procedure GoForward(Entry: EntryRecPtr; pattern: PatRecPtr; S: PStream;
                    var etype: integer; var ok: boolean);
var
  orig : Word;
  count: integer;
  eofbib,leave,bt3,rok : boolean;
  atplace: longint;

procedure FindStart(var etype: integer; var atplace: longint);
var
  i,j,atindex,BraceChar,emin,emax: word;
  leave,found: boolean;
  tmp: string;

function EStartChar: byte;
var
  tmp: string;
  i,j,atindex,llen: word;
begin
  EstartChar:=0; etype:=0;
  atindex:=Pos('@',line);
  while (etype=0) and (atindex>0) and (atindex<=length(line)) do
  begin
    llen:=length(line)-atindex+1;
    if S=Nil then
      atplace:=TextFilePos(bib)-llen { !!!!!!!!!!!!!!!!!!!!!! }
    else
      atplace:=S^.GetPos-llen; { !!!!!!!!!!!!!!!!!!!!!! }
    if UnixBib and ReachedEol and (atplace>0) then atplace:=atplace-1;
    Delete(line,1,atindex);
    GetLine(S,line); ChrDelL(line,' ');    
    tmp:=line;
    i:=1;
    while (i<=length(line)) and not (line[i] in [#9,' ','@','(',lbrace]) do inc(i);
    if i<=length(line) then
    begin
      tmp[0]:=Chr(i-1); Delete(line,1,i-1);
    end else if ReachedEol then line:=''
    else begin
      RdString(S,line);
      for i:=1 to length(line) do if line[i]=#9 then line[i]:=' ';
      i:=1;
      while (i<=length(line)) and not (line[i] in [' ','@','(',lbrace]) do inc(i);
      if i<=length(line) then
      begin
        PStrCat(tmp,Copy(line,1,i-1),sizeof(tmp)-1);
        Delete(line,1,i-1);
      end else line:='';
    end;
    StrLwr(tmp);
    j:=emin;
    while (j<=emax) and (etype=0) do
    begin
      if tmp=TypeEntry^[j] then etype:=j
        else inc(j);
    end;
    if etype>0 then EstartChar:=atindex
      else atindex:=ChrPosX(line,'@',i);
  end;
end;                   { EStartChar }

begin                     { FindStart }
  BeyondLimit:=false;
  if EditOnlyStrings and StringsBeforeEntries then
  begin
    emin:=1; emax:=StringTypeInd;
    if IncludePreambles then emax:=PreambleTypeInd;
  end else if EditOnlyStrings then
  begin
    emin:=StringTypeInd; emax:=emin;
    if IncludePreambles then emax:=PreambleTypeInd
  end else
  begin
    emin:=1; emax:=NumberOfTypes;
  end;
  atplace:=0;
  etype:=0;
  line:=LastReadLine^;
  repeat
    leave:=false;

    atindex:=Pos('@',line);
    while (not eof_bib(S)) and (atindex=0) do
    begin
      line:=''; GetLineNo(S,line);
      atindex:=Pos('@',line);
    end;

    for i:=1 to length(line) do
    begin
      if line[i]=#9 then line[i]:=' ';
      if ((i=1) and ReadBS) or ((i>1) and (line[i-1]='\')) then
      begin
        j:=Pos(line[i],table1);
        if j>0 then line[i]:=table2[j];
      end;
    end;
    atindex:=EStartChar;
    if EditOnlyStrings and (etype<>0) and (etype<=NumberOfTypes) then
      BeyondLimit:=true;
    if ((etype=0) and eof_bib(S)) or BeyondLimit then leave:=true
    else if etype>0 then
    begin
      leave:=true;
      bracechar:=1;
      while (bracechar<length(line)) and (line[bracechar]=' ') do
        inc(bracechar);
      if line[bracechar]=lbrace then beginBrace:=true
      else if line[bracechar]='(' then beginBrace:=false
      else bracechar:=0;
      if (not eof_bib(S)) and (bracechar=0) then
      begin
        line:=''; GetLine(S,line);
        if line[1]=lbrace then bracechar:=1
        else if line[1]='(' then
        begin
          bracechar:=1;
          BeginBrace:=false;
        end else
        begin
          leave:=eof_bib(S); etype:=0;
        end;
      end;
      if BraceChar>0 then Delete(line,1,BraceChar);
    end;
    if (S=Nil) and Linked and (BeyondLimit or eof(bib))
       and (BibInRing<BibRingNum) then
    begin
      close(bib);
      Inc(BibInRing);
      bibname^:=BibFiles^[BibRing[BIbInRing]].name;
      BibFiles^[BibRing[BibInRing]].realstart:=entry^.realnum;
      BibFiles^[BibRing[BibInRing]].entrystart:=entry^.entrynum;
      BibReadOnly:=BibFiles^[BibRing[BIbInRing]].RO;
      LFNAssign(bib,bibname^); UnixBib:=IsUnixFile(bib,bibname^);
      ResetBibFile(bib,bibname^); SetTextBuf(bib,bibbuf^,FileBufSize);
      leave:=false; LastReadLine^:=''; line:='';
      CurrentBibFile:=BibRing[BibInRing];
      AtStartOfFile:=true; ANewLine:=true;
      BeyondLimit:=false;
    end;
  until leave;
  LastReadLine^:=line;
  if BeyondLimit then etype:=0;
end;                 { FindStart }

procedure GetNext;
begin
  etype:=0;
  FindStart(etype,atplace);
  if entry^.realnum=$ffff then ErrorMessageRC(Str_TooManyEntries,'');
  Inc(entry^.realnum);
  entry^.beginning:=atplace;
  if orig=entry^.realnum then count:=count-1;
  eofbib:=Eof_bib(S) or BeyondLimit;
  if (Pattern<>Nil) and (Pattern^.on) and (etype>0) then
  begin
    ReadEntry(Entry,S,etype,true,'',Exact,CaseSen,RegExp,bt3,rok);
    if rok then
    begin
      PatternCheck(entry,pattern,ok,true);
      if Entry^.RealNum>LastRealNum then LastRealNum:=Entry^.RealNum;
    end else
    begin
      ok:=false; entry^.nentry:=0;
      if entry^.name='' then Dec(entry^.realnum);
    end;
  end else
  begin
    ok:=(etype>0);
    if ok and (Entry^.RealNum>LastRealNum) then LastRealNum:=Entry^.RealNum;
  end;
  if ok then inc(entry^.entrynum);
end;                             { GetNext }
                                 
begin                            { GoForward }
  bt3:=false;
  etype:=0;
  BeyondLimit:=false;
  if ok then
  begin
    if AtStartofFile then ReachedEOL:=false;
    count:=0;
    if entry^.realnum>0 then orig:=entry^.realnum
    else begin
      orig:=1; count:=1;
    end;
    entry^.name:=''; entry^.nentry:=0;
    repeat
      GetNext; TrapAbort;
    until ok or Eofbib or AbortFlag;
    if Eofbib and (not ok) then
    begin
      GotoStart(S,Entry);
      BeyondLimit:=false;
      repeat
        GetNext; TrapAbort;
      until ok or (count<0) or AbortFlag;
    end;
    if AbortFlag then ok:=false;
    if not ok then GotoStart(S,entry);
  end;
end;                             { GoForward }

var
  Info: TCacheInfo;
  MakeUseOfCache: boolean;
  MaxENum: longint;

procedure NewRingNum(NewRingNum: integer);
begin
  CloseFile(bib);
  BibInRing:=NewRingNum;
  bibname^:=BibFiles^[BibRing[BibInRing]].name;
  BibReadOnly:=BibFiles^[BibRing[BIbInRing]].RO;
  LFNAssign(bib,bibname^); UnixBib:=IsUnixFile(bib,bibname^);
  ResetBibFile(bib,bibname^); SetTextBuf(bib,bibbuf^,FileBufSize);
  CurrentBibFile:=BibRing[BibInRing];
  AtStartOfFile:=true; ANewLine:=true;
  LastReadLine^:='';
end;                     { NewRingNum }

begin                            { GetEntry }
  if (S=Nil) and (not BibFileExists) then
  begin
    entry^.EntryType:=''; Entry^.name:=''; Entry^.nentry:=0;
    ok:=false; Exit;
  end;
  if (S=Nil) then
  begin
    if EntryCache^.UseCache(Pattern) and (EntryCache^.Last=0) then
    begin
      ok:=false; Exit;
    end;
    {$I-}
    ok:=eof(bib); ok:=(IoResult=0);
    {$I+}
    if not ok then Exit;
  end;
  if EscapeBraces then
    table1:= '\'+lbrace+rbrace+'%"'
  else
    table1:= '\%"';
  table2:= #1#2#3#4#5;
  QuotePlace:=Pos('"',table1); IgnoreSpec:=0;
  pl:=entry^.entrynum;
  ok:=true; line:=''; foundit:=false;
  CaseSen:=false; RegExp:=false; Exact:=false;
  BeyondLimit:=false; AbortFlag:=false;

  MakeUseOfCache:=(S=Nil) and
                  (ActivePattern(Pattern) or (ToEntry<>Entry^.EntryNum+1))
                  and EntryCache^.UseCache(Pattern);
  Info.Beg:=-1;
  if MakeUseOfCache then
  begin
    if(EntryCache^.Last>-1) and (ToEntry=EntryCache^.Last+1) then
    begin
      EntryCache^.Find(1,Pattern,false,@Info);
    end else EntryCache^.Find(ToEntry,Pattern,false,@Info);
  end;
  if Info.Beg>-1 then
  begin
    if Linked and (Info.BibInd<>BibInRing) then
      NewRingNum(Info.BibInd);
    TextSeek(bib,Info.Beg);
    LastReadLine^:='';
    ReachedEol:=false;
    entry^.realnum:=Info.RNum-1;
    entry^.entrynum:=Info.ENum-1;
    ok:=true;
    GetEntry(Entry,Nil,Info.ENum,WholeEntryRead,Nil,ok);
  end else if toentry>pl then
  begin
    i:=entry^.entrynum;
    while (entry^.entrynum<toentry) and (entry^.entrynum>=i) and ok
      and not AbortFlag do
    begin
      OldPlace:=entry^.beginning;
      GoForward(Entry,pattern,S,etype,ok);
      Inc(i);
      if ok and not ActivePattern(Pattern) then
      begin
        ReadEntry(Entry,S,etype,WholeEntryRead and (entry^.entrynum=toentry),
                  '',Exact,CaseSen,RegExp,foundit,rok);
        if not rok then
        begin
          entry^.nentry:=0;
          if entry^.name='' then
          begin
            Dec(entry^.realnum); Dec(entry^.entrynum); Dec(i);
          end;
          if PlaceCompare(entry^.beginning,OldPlace)<1 then ok:=false;
        end;
      end;
      if ok and (S=Nil) then EntryCache^.Insert(Entry,Pattern);
      TrapAbort;
    end;
    if AbortFlag then ok:=false;
  end else if toentry<pl then
  begin
    pl:=0;
    i:=entry^.entrynum;
    if (S=Nil) and Linked and (BibInRing>1) then
    begin
      while (BibInRing>1) and
            ( (BibFiles^[BibRing[BibInRing]].entrystart=0) or
              (BibFiles^[BibRing[BibInRing]].entrystart>=toentry) ) do
        dec(BibInRing);
      CurrentBibFile:=BibRing[BibInRing];
      if BibInRing=1 then ResetBib(Entry)
      else NewRingNum(BibInRing);
    end else GotoStart(S,Entry);
    TrapAbort;
    while (entry^.entrynum<toentry) and (entry^.entrynum>=i) and ok do
    begin
      OldPlace:=entry^.beginning;
      GoForward(Entry,pattern,S,etype,ok); Inc(i);
      if ok and (S=Nil) then EntryCache^.Insert(Entry,Pattern);
      if ok and not ActivePattern(Pattern) then
      begin
        ReadEntry(Entry,S,etype,WholeEntryRead and (entry^.entrynum=toentry),
                  '',Exact,CaseSen,RegExp,foundit,rok);
        if not rok then
        begin
          entry^.nentry:=0;
          if entry^.name='' then
          begin
            Dec(entry^.realnum); Dec(entry^.entrynum); Dec(i);
          end;
          if PlaceCompare(entry^.beginning,OldPlace)<1 then ok:=false;
        end;
      end;
      TrapAbort;
      if AbortFlag then ok:=false;
    end;
  end;
  foundit:=ok;

  if AbortFlag or not foundit then ok:=false;
  if (entry^.name='') then ok:=false;
  if (not ok) or (Entry^.EntryNum=0) then
  with Entry^ do
  begin
    entrynum:=0; realnum:=0; nentry:=0; entrytype:=''; name:='';
  end;
  {
  if ok then
    message('Entry "'+entry^.name+'" begins at '+num2str(entry^.beginning)
          +' and ends at '+num2str(entry^.ending));
  }
  EntryModified:=false;
end;                       { GetEntry }

end.

