/* config.h - 20:42 GMT +10:00 Wed 18 August 1993 - modifier Geoffrey Tobin */

#ifndef CONFIG_H
#define CONFIG_H

#include <ctype.h>
#include <math.h>
#include <stdio.h>

/* Word must be 32 bits.  Word is used in the PK bitmap operations. */
/* For an Architecture with 32-bit ints, Word can be int. */

typedef int Word;    /* SYSDEP:  ASSUMES exactly 32 bits in int. */

/* Intel microprocessors (eg in PCs) are little-endian.

   Motorola's cpu-s (eg in Suns and Macs), and the Risc chip in the
   IBM Risc/6000 (a common platform for Aix) are big-endian.

   Other microprocessors have to be identified and classified by
   whomever compiles DVItoVDU for them.

   LITTLE_ENDIAN and BIG_ENDIAN are used in "globals.h".  One of
   these must be defined.  In the event that both are defined,
   LITTLE_ENDIAN prevails.
*/

/* #define LITTLE_ENDIAN */	/* As God intended */
#define BIG_ENDIAN		/* Otherwise*/

/* unix directory separator(s) */
#define DIRSEP ":"

/* FILE is a #define in BSD, a typedef in SYSV (hp-ux, at least),
 * and a typedef in ANSI C.
 * A convenient, but horrible, kludge to detect BSD by its <stdio.h>
 * header file!  We want to know about the C headers and libraries.
 */
#ifdef FILE
# define BSD 1
#endif /* FILE */

/* Test for ANSI C.  Only conforming compilers may define __STDC__,
   and they must also set __STDC__ to 1. */

/* Note:  The purpose of the definition of the "__(X)" macro is to
   make it easier to write prototypes acceptable to both K&R first
   edition and ANSI C compilers.  Thus, "X" must always be
   "(something)".  For example, "__(void)" doesn't work:  it has to be
   "__((void))".  When there are two or more arguments, this error is
   caught quite promptly as a syntax error - well, it has been so far!
*/

#ifdef __STDC__
# define __(X) X
#else /* not __STDC__ */
# define __(X) ()
#endif /* __STDC__ */

#ifdef __STDC__
# define Void       void      /* Void f() = procedure */
# define VOID       void      /* f (VOID) */
#else /* not __STDC__ */
# define void int
# define Void int
# define VOID
#endif /* __STDC__ */

/* GT - Complication:  Our system, eg, has an ANSI compiler, gcc.
   However, it has a BSD library!
   And which headers does it use?  -  BSD's or gcc's or what?
   (I find this whole `arrangement' very annoying.)
   So I need to separate tests for compiler and library, somehow.
   Take this "config.h" as only a crude attempt.
*/

#ifdef BSD
# include <strings.h>
# include <sys/file.h>
# include <sys/types.h>
  extern char * getenv();
  extern char * strtok();
  extern int open();
  extern int close();
  extern int read();
  extern long lseek();
  extern char * malloc();
  extern int free();
  extern char * calloc();
  extern int bcopy();
  extern int strcspn();
  extern int access();
  extern int ioctl();
  extern int kill();
# define memcpy(a,b,n) (bcopy(b,a,n),a)
# define memcmp(a,b,n) bcmp(a,b,n)
# define strchr(s,c) index(s,c)
# define strrchr(s,c) rindex(s,c)
#else /* Not BSD - maybe System V, ANSI C library, POSIX, or other ? */
# include <memory.h>
# include <string.h>
# ifdef __STDC__
#  define HAS_STDLIB
#  include <stddef.h>
#  include <stdlib.h>
#  include <unistd.h>  /* dvgt is for unix systems */
# else /* not __STDC__, not BSD */
#  include <sys/types.h>
# endif /* __STDC__ */
#endif /* BSD */


/* GT - Do Char and Static have any advantage over char and static ? */
#define Char        char      /* Characters (not bytes) */
#define Static      static    /* Private global funcs and vars */

typedef Void (*VFP) (VOID);
typedef Void *Anyptr;
typedef unsigned char boolean;

#ifndef true
# define true    1
# define false   0
#endif /* not defined true */

/* GT - Has Extern any advantage over extern ? */
#ifndef Extern
# define Extern extern
#endif /* not defined Extern */

Extern int P_argc;
Extern char **P_argv;

/* Memory allocation */
extern int OutMem(VOID);

/* GT - Nasty, nasty, nasty! */
#ifdef __GNUC__
# ifndef BSD  /* gcc and not an inappropriate, BSD library */
#  define GNUC_LIB 1
# endif
#endif

#ifdef GNUC_LIB
#  define Malloc(n)  (malloc(n) ?: (Anyptr)OutMem())
#else /* not GNUC_LIB */
  Extern Anyptr __MallocTemp__;
# ifdef ORIGINAL
#  define Malloc(n) \
    ((__MallocTemp__ = malloc(n)) ? __MallocTemp__ : (Anyptr)OutMem())
# else /* not ORIGINAL */
#  define Malloc(n) \
    ((__MallocTemp__ = (Anyptr)malloc(n)) ? __MallocTemp__ : (Anyptr)OutMem())
# endif /* ORIGINAL */
#endif /* GNUC_LIB */

#define Free(p, T)     (free((Anyptr) (p)), (p) = (T *) NULL)

#endif /* CONFIG_H */

/* end config.h */
