/*
 *  TEX Device Driver  ver 2.02-2.36
 *  copyright(c) 1988,89 by TSG, 1990 SHIMA
 *
 *  modified for Minix-386, Linux by youchan  1992
 *  modified for X11 by M.M.U. 1993
 */

#include "config.h"
#include "dd.h"

const char* const title_comment = "";

#define ONEBYTE     8

#define ON          1
#define OFF         0
#define ESC         0x1b
#define V_SHIFT     1

extern  int  num_view;
extern  int  num_view_buf;
extern  int  unit_pages;
extern  char resume_info[16];

#define MAX_VIEW    10

struct  VIEW {
    int current;
    int total;
    int page[MAX_VIEW];
};

static struct VIEW view;

struct SCROLL {
    int  x;
    int  y;
    int  gw_act, gh_act;
    BOOL x_lock, y_lock;
    BUFFER* mptr;
    int h_spc, v_spc;
};

typedef enum {
    BackSpace, SpaceKey,    /* PreviousPage, NextPage   */
    PgUp, PgDn,             /* PreviousPage, NextPage   */
    CaridgeReturn,          /* NextPageDirection        */
    EndKey,                 /* EscapeQuit               */
    Key_Q,                  /* Same as above            */
    Key_B,                  /* Another Previous Page    */
    Key_H,                  /* HELP                     */
    Key_M,                  /* Move to a page           */
    Key_G,                  /* Same as above            */
    Key_P,                  /* PreviousPage             */
    Key_N,                  /* NextPage                 */
    Help,
    ArrowDown, ArrowUp, ArrowLeft, ArrowRight, LoopEnd
} KeyInput;

int s_max_width  = 118*8;
int s_max_height = 118*11;

static BUFFER* map_top_ptr;         /* pointer of bitmap buffer */
static PIXEL   vmax, hmax, hmaxb;   /* size to output. hmaxb is byte-size. */
static BUFFER* g_top_ptr;           /* head pointer of virtial graphic vram */
static int  f_div;
static int  f_div2;
static BUFFER* view_buf;
static BUFFER* g_top;

int x_shift;
int y_shift;

/* Proto-types */
void device_init(DIMENSION*);
void device_end(void);
void device_cont(void);
void device_pause(void);
void device_clear(OUTPUT_INFO*);
void pr_new_page(void);
NEXT_ACTION device_out(OUTPUT_INFO*);
KeyInput extra_inkey(void);

static void first_draw(struct SCROLL*, int);
static void draw_screen(struct SCROLL*, int);
static void move_screen(struct SCROLL*, KeyInput, int, int);

static void flskey(void);
static void msg_help(void);

extern int tt_flag;
extern void ttclose(void);

/* graphics driver */

#include "x11.drv"

/* end of device.c */
