/* msvcdir.c */
#include "msvcdir.h"
#include <assert.h> /* assert */
#include <time.h>
#include <sys/stat.h>


void getftime(int handle, struct ftime *ft){
	time_t Ftime;
	struct tm *tmtime;
	struct stat buffer0;

	int state=fstat(handle,&buffer0);
	assert(state==0);
	Ftime=buffer0.st_mtime;
	tmtime=localtime(&Ftime);
	ft->ft_year=tmtime->tm_year-80;
	ft->ft_month=tmtime->tm_mon+1;
	ft->ft_day=tmtime->tm_mday;
	ft->ft_hour=tmtime->tm_hour;
	ft->ft_min=tmtime->tm_min;
	ft->ft_tsec=tmtime->tm_sec/2;
}
