/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.latex;

import com.dickimawbooks.texparserlib.Declaration;
import com.dickimawbooks.texparserlib.TeXMode;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXSettings;
import com.dickimawbooks.texparserlib.latex.LaTeXParserListener;
import java.io.IOException;

public class MathDeclaration
extends Declaration {
    private TeXMode orgMode;
    private TeXMode mode = TeXMode.INLINE_MATH;
    private boolean numbered;

    public MathDeclaration() {
        this("(", TeXMode.INLINE_MATH, false);
    }

    public MathDeclaration(String string) {
        this(string, TeXMode.INLINE_MATH, false);
    }

    @Deprecated
    public MathDeclaration(String string, int n) {
        this(string, n, false);
    }

    @Deprecated
    public MathDeclaration(String string, int n, boolean bl) {
        super(string);
        this.numbered = bl;
        if (n == 1) {
            this.mode = TeXMode.INLINE_MATH;
        } else if (n == 2) {
            this.mode = TeXMode.DISPLAY_MATH;
        } else {
            throw new IllegalArgumentException("Illegal modeId argument " + n);
        }
    }

    public MathDeclaration(String string, TeXMode teXMode) {
        this(string, teXMode, false);
    }

    public MathDeclaration(String string, TeXMode teXMode, boolean bl) {
        super(string);
        this.numbered = bl;
        if (!TeXMode.isMath(teXMode)) {
            throw new IllegalArgumentException("Illegal mode argument " + (Object)((Object)teXMode));
        }
        this.mode = teXMode;
    }

    @Override
    public boolean canExpand() {
        return false;
    }

    @Override
    public TeXObjectList expandonce(TeXParser teXParser) throws IOException {
        return null;
    }

    @Override
    public TeXObjectList expandonce(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        return null;
    }

    @Override
    public TeXObjectList expandfully(TeXParser teXParser) throws IOException {
        return null;
    }

    @Override
    public TeXObjectList expandfully(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        return null;
    }

    @Override
    public Object clone() {
        return new MathDeclaration(this.getName(), this.mode, this.numbered);
    }

    public void doModeSwitch(TeXParser teXParser) {
        TeXSettings teXSettings = teXParser.getSettings();
        this.orgMode = teXSettings.getCurrentMode();
        teXSettings.setMode(this.mode);
    }

    public void revertModeSwitch(TeXParser teXParser) {
        TeXSettings teXSettings = teXParser.getSettings();
        teXSettings.setMode(this.orgMode);
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        this.doModeSwitch(teXParser);
        if (this.isNumbered()) {
            ((LaTeXParserListener)teXParser.getListener()).stepcounter("equation");
        }
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        this.doModeSwitch(teXParser);
        if (this.isNumbered()) {
            ((LaTeXParserListener)teXParser.getListener()).stepcounter("equation");
        }
    }

    @Override
    public void end(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        this.revertModeSwitch(teXParser);
    }

    public TeXMode getMode() {
        return this.mode;
    }

    public boolean isNumbered() {
        return this.numbered;
    }

    @Override
    public boolean isModeSwitcher() {
        return true;
    }
}

