/* Make this with:  lex detex.lex;  cc lex.yy.c -ll -o detex */
L [A-Za-z}{|\]\[\\]
%Start Display Normal
%%
<Normal>\'	{yyleng--; yymore(); /* ignore apostrophes */}
<Normal>{L}+!- {yyleng-=2; yymore(); /* ignore hyphens */}
<Normal>[a-z]/[^A-Za-z] ; /* ignore single letter "words" */
<Normal>[A-Z]+	; /* ignore words all in uppercase */
<Normal>{L}+('{L}*)*{L}	{printf("%s\n",yytext); /* any other letter seq is a word */} 
<Normal>!.	; /* ignore single character control sequences */
<Normal>!\n	; /* more of the same */
<Normal>"%".*	; /* ignore comments */
<Normal>!{L}+	; /* ignore other control sequences */
<Normal>[0-9]+	; /* ignore numbers */
<Normal,Display>\$([^$]|!\$)+\$	;  /* ignore things in math mode */
<Normal>\$\$		BEGIN Display; /* now in Display math mode */
<Display>[^$]|!\$|!!	; /* ignore most things in display math mode */
<Display>\$\$	BEGIN Normal; /* get out of Display math mode */
<Normal>\n|.	; /* ignore anything else, a character at a time */
%%
main(argc,argv)
	char **argv;
{
	int i;
	
	BEGIN Normal; /* Starts yylex off in the right state */
	if (argc==1) {
	    yyin = stdin;
	    yylex();
	    }
	else for (i=1; i<argc; i++) {
	    yyin = fopen(argv[i],"r");
	    if (yyin==NULL) {
		fprintf(stderr,"can't open %s\n",argv[i]);
		exit(1);
		}
	    yylex();
	    }
	exit(0);
}
