% adami.pat -- patterns for ADAMI transliteration scheme for tamil.
% Jeroen Hellingman
% Last edit: 22-DEC-1992

% a aa i ee u oo e E ai o O aw/au  q
% k/g n/NG ch n/NY t/d n/N th/dh n/nN p/b m y/Y r l v zh L R n
% j sh s x/ksh

% translates to

% a aa i ii u uu e ee ai o oo au  H
% k n" c n~ T N t n p m y r l v zh L R n_
% j S s h kS

@patterns 0
"<tamil>"		1 "<tamil>"
"</tamil>"		e "</tamil> found in roman-mode"
"\t"			p " "
"\\"			t					% copy a tex command
"%" 			s					% skip comment

@patterns 1
"<tamil>"		e "<tamil> found in tamil-mode"
"</tamil>"		0 "</tamil>"
"\\"			t					% copy a tex command
"%" 			s					% skip comment

"a" 			p "a"
"aa"			p "aa"
"i" 			p "i"
"ee"			p "ii"
"u" 			p "u"
"oo"			p "uu"
"e" 			p "e"
"E" 			p "ee"
"ai"			p "ai"
"o" 			p "o"
"O" 			p "oo"
"ow"			p "au"
"au"			p "au"

"q" 			p "H"

"k" 			p "k"
"g" 			p "g"
"NG"			p "n\""
"nk"			p "n\"k"
"ng"			p "n\"k"

"ch"			p "c"
"j" 			p "j"
"NY"			p "n~"
"nch"			p "n~c"
"nj"			p "n~j"

"t" 			p "T"
"d" 			p "T"
"N" 			p "N"
"nt"			p "NT"
"nd"			p "ND"

"th"			p "t"
"dh"			p "t"
"nN"			p "nN"
"nth"			p "nt"
"ndh"			p "nt"

"p" 			p "p"
"b" 			p "p"
"m" 			p "m"

"y" 			p "y"
"Y" 			p "y"
"r" 			p "r"
"v" 			p "v"
"l" 			p "l"
"zh"			p "zh"
"n"                     p "n_"
"L" 			p "L"
"R" 			p "R"
"sh"			p "S"
"s" 			p "s"
"x" 			p "kS"
"ksh"			p "kS"

@end
