%%=============================================================================
%% ppr-prv.cls
%% Copyright 2003 Mathieu Goutelle (INRIA, France)
%% mgoutell[at]users[dot]sourceforge[dot]net
%%
%% This program may be distributed and/or modified under the
%% conditions of the LaTeX Project Public License, either version 1.2
%% of this license or (at your option) any later version.
%% The latest version of this license is in
%%   http://www.latex-project.org/lppl.txt
%% and version 1.2 or later is part of all distributions of LaTeX 
%% version 1999/12/01 or later.
%%=============================================================================

\def\PPRPRV@Version{2003/10/09, v. 0.08}
\NeedsTeXFormat{LaTeX2e}[1995/12/01]
\ProvidesClass{ppr-prv}[\PPRPRV@Version]
\typeout{(c) 2003 Mathieu Goutelle (INRIA, France)}
\typeout{CVSId: $Id: ppr-prv.cls,v 1.9 2003/10/10 07:39:52 mgoutell Exp $}

\LoadClass[a4paper]{article}

\newif\ifDVItoPS
\DeclareOption{ps}{\global\DVItoPStrue}
\DeclareOption{pdf}{\global\DVItoPSfalse}

\newif\ifisDraft
\DeclareOption{draft}{\global\isDrafttrue}
\DeclareOption{final}{\global\isDraftfalse}

\newif\ifinColor
\DeclareOption{slideColor}{}
\DeclareOption{slideBW}{}

\newif\ifallPages
\DeclareOption{total}{}
\DeclareOption{nototal}{}

\newif\ifcolorBG
\DeclareOption{nocolorBG}{}
\DeclareOption{colorBG}{}

\newif\ifAccumulate
\DeclareOption{accumulate}{}
\DeclareOption{noaccumulate}{}

\newif\ifnoFooter
\DeclareOption{noFooter}{\global\noFootertrue}
\noFooterfalse

\newif\if@distiller
\@distillerfalse
\DeclareOption{distiller}{\global\@distillertrue}

\DeclareOption{YandY}{\gdef\@pdf@driver{dvipsone}}
\DeclareOption{ps2pdf}{\gdef\@pdf@driver{ps2pdf}}
\DeclareOption{vtex}{\gdef\@pdf@driver{vtex}}

%% Default style file = default
\def\Style@chosen{default}
\DeclareOption*{\global\let\Style@chosen=\CurrentOption}

\ExecuteOptions{final,slideBW,total,nocolorBG,noaccumulate,ps,ps2pdf}
\ProcessOptions\relax

%% Preliminary stuff
\RequirePackage{pstricks}
\RequirePackage{textcomp}
\RequirePackage{graphicx}
\RequirePackage{a4wide}
\RequirePackage[\@pdf@driver,plainpages=false,pdfpagelabels,colorlinks=true]{hyperref}

\setlength{\parindent}{0pt}
\newlength{\@size@tmp}
\newlength{\@size@overlay}
\global\@size@overlay\z@

\AtBeginDocument{% Multi-language support with Babel
  \newcommand{\slidename}{slide}
  \providecommand{\no}{\#}
  \ifx\ldf@quit\@undefined
  \else%
    \def\@test{french}
    \ifx\languagename\@test
      \renewcommand{\slidename}{transparent}
      \providecommand{\no}{n\textdegree}
    \fi
    \def\@test{english}
    \ifx\languagename\@test%
      \renewcommand{\slidename}{slide}
      \providecommand{\no}{\#}
    \fi
    \def\@test{british}
    \ifx\languagename\@test%
      \renewcommand{\slidename}{slide}
      \providecommand{\no}{\#}
    \fi
    \def\@test{canadian}
    \ifx\languagename\@test%
      \renewcommand{\slidename}{slide}
      \providecommand{\no}{\#}
    \fi
    \def\@test{USenglish}
    \ifx\languagename\@test%
      \renewcommand{\slidename}{slide}
      \providecommand{\no}{\#}
    \fi
     \def\@test{UKenglish}
    \ifx\languagename\@test%
      \renewcommand{\slidename}{slide}
      \providecommand{\no}{\#}
    \fi
   \def\@test{german}
    \ifx\languagename\@test%
      \renewcommand{\slidename}{transparent}
      \providecommand{\no}{Nr.}
    \fi
   \def\@test{germanb}
    \ifx\languagename\@test%
      \renewcommand{\slidename}{transparent}
      \providecommand{\no}{Nr.}
    \fi
   \def\@test{austrian}
    \ifx\languagename\@test%
      \renewcommand{\slidename}{transparent}
      \providecommand{\no}{Nr.}
    \fi
   \def\@test{ngerman}
    \ifx\languagename\@test%
      \renewcommand{\slidename}{transparent}
      \providecommand{\no}{Nr.}
    \fi
   \def\@test{naustrian}
    \ifx\languagename\@test%
      \renewcommand{\slidename}{transparent}
      \providecommand{\no}{Nr.}
    \fi
  \fi%
}

%% Definition of the part command to suppress the optional transition argument
\let\part=\relax
\newcommand{\part}[2][\relax]{\refstepcounter{slidei}\section*{#2}}

%% Handle all the maketitle stuff
\let\@cartouche=\@empty
\newcommand{\slideCaption}[1]{\gdef\@cartouche{#1}}
\let\@Subtitle\@empty
\newcommand{\subtitle}[1]{\gdef\@Subtitle{#1}}
\let\Old@Title=\title
\renewcommand{\title}[1]{\gdef\@Title{#1}}

\let\@email\@empty
\newcommand{\email}[1]{\gdef\@email{#1}}
\let\@institution\@empty
\newcommand{\institution}[1]{\gdef\@institution{#1}}

\renewcommand{\author}[1]{\gdef\@author{#1}}

\renewcommand{\maketitle}{
  \thispagestyle{empty}\setcounter{page}{0}
  \refstepcounter{slidei}
  \mbox{}\vfill
  \begin{center}%
    {\LARGE \@Title \par}%
    \ifx\@Subtitle\@empty\else\vskip 2em{\large\@Subtitle\par}\fi%
    \vskip 6em%
    {\large\@author%
    \ifx\@email\@empty\else\vskip 1em\@email\fi%
    \ifx\@institution\@empty\else\vskip 1em\@institution\par\fi}%
  \end{center}%
  \vfill\mbox{}\newpage%
}

%% Definition of the Itemize environment ;)
\let\Itemize=\itemize
\let\endItemize=\enditemize

%% Definition of the itemstep environment to gobble the optional argument.
\newenvironment{itemstep}[1][]%
  {\itemize}
  {\enditemize}

%% Definition of the slide environment
\newsavebox{\@slide@content} % will contain the slide
% Slide counter to be printed on the bottom of each slide
\newcounter{slidei}\setcounter{slidei}{0}
% Slide counter to print just two slides per page (even when there is a
% \part...)
\newcounter{slideii}\setcounter{slideii}{0}

\newenvironment{slide}[1]{%
  \begin{lrbox}{\@slide@content}\begin{minipage}{\linewidth}%
  \subsection*{#1}%
}
{%
  \end{minipage}\end{lrbox}%
  \settoheight{\@size@tmp}{\@slide@content}%
  \fbox{
    \usebox{\@slide@content}%\the\@size@tmp\the\@size@overlay%
    \ifdim\@size@overlay>\@size@tmp%
       \addtolength{\@size@overlay}{\baselineskip}%
       \rule[-\@size@overlay]{1pt}{0pt}
    \fi%
  }%
  \refstepcounter{slidei}\stepcounter{slideii}%
  \ifnoFooter\else%
    \ifhmode\\\fi%
    \mbox{}\hfill%
    {\footnotesize%
      \ifx\@cartouche\@empty\else\@cartouche~---~\fi%
      \slidename~\no\theslidei}%
  \fi%
  \vfill\ifodd\theslideii\else\null\newpage\fi%
  \global\@size@overlay\z@%
}

\AtEndDocument{\ifodd\theslideii\vfill\else\fi}

%% For the \Logo, don't do anything !
\newcommand{\Logo}{%
    \@ifnextchar({\Logo@one}{\Logo@two}%
}
\def\Logo@one(#1)#2{}
\def\Logo@two#1{}

%% For the \Font*, don't do anything !
\newcommand{\FontTitle}[2]{}
\newcommand{\FontText}[2]{}

%% Definition of the whole overlay stuff: a bit annoying...
\newcommand{\overlays}[2]{#2} % We ignore overlays

\def\FromSlide#1{\relax}
\def\UntilSlide#1{\relax}
\def\OnlySlide#1{\relax}

\def\fromSlide@NE#1#2{#2}
\def\untilSlide@NE#1#2{#2}
\def\onlySlide@NE#1#2{#2}

\def\fromSlide@E#1#2{%
    \settoheight{\@size@tmp}{#2}%
    \ifdim\@size@tmp>\@size@overlay\global\@size@overlay\@size@tmp\fi%
    \vbox to 0pt\bgroup#2\egroup\vskip -\baselineskip\ignorespaces%
}
\def\untilSlide@E#1#2{%
  \settoheight{\@size@tmp}{#2}%
  \ifdim\@size@tmp>\@size@overlay\global\@size@overlay\@size@tmp\fi%
  \vbox to 0pt\bgroup#2\egroup\vskip -\baselineskip\ignorespaces%
}
\def\onlySlide@E#1#2{%
  \settoheight{\@size@tmp}{#2}%
%  \the\@size@tmp\the\@size@overlay%
  \ifdim\@size@tmp>\@size@overlay\global\@size@overlay\@size@tmp\fi%
%  \the\@size@tmp\the\@size@overlay%
  \vbox to 0pt\bgroup#2\egroup\vskip -\baselineskip\ignorespaces%
}

\def\fromSlide{\@ifstar\fromSlide@E\def\fromSlide@NE}
\def\untilSlide{\@ifstar\fromSlide@E\def\fromSlide@NE}
\def\onlylide{\@ifstar\fromSlide@E\def\fromSlide@NE}

%% All the things I may have forgotten if I haven't read the docs
%% carefully enough
\def\displayVersion{\relax}
\def\DefaultTransition#1{\relax}
\def\NoFrenchBabelItemize{\relax}

\def\fontTitle#1{#1}
\def\fontText#1{#1}

\newcommand{\myitem}[2]{}

%% Stolen from the prosper.cls code
\newcommand{\PDForPS}{%
  \ifDVItoPS
    \let\prosper@next\@secondoftwo
  \else
    \let\prosper@next\@firstoftwo
  \fi
  \prosper@next}
% #1 appears on the slide only on PS mode
\newcommand{\onlyInPS}{%
  \ifDVItoPS 
    \let\prosper@next\@iden
   \else
    \let\prosper@next\@gobble
  \fi
  \prosper@next}
% #1 appears on the slide only on PDF mode
\newcommand{\onlyInPDF}{
  \ifDVItoPS
    \let\prosper@next\@gobble
  \else
    \let\prosper@next\@iden
  \fi
  \prosper@next}
