/* c4plib.h -- c4p run-time system
   Time-stamp: "97/01/03 18:04:20 mik"

   Copyright (C) 1991, 92, 93, 94, 95, 96, 97
	Christian Schenk  <cschenk@berlin.snafu.de>

   This file is part of MiKTeX.

   MiKTeX is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.
   
   MiKTeX is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with MiKTeX; if not, write to the Free Software Foundation,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  */

#if ! defined (_C4PLIB_H)
#define _C4PLIB_H

#include <time.h>

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <limits.h>

#if defined (_WIN32)
#if defined (MIKTEX_DLL)
#if defined (IN_MIKTEX_DLL)
#define _MIKTEX_1 __declspec (dllexport)
#else /* ! IN_MIKTEX_DLL */
#define _MIKTEX_1 __declspec (dllimport)
#endif /* ! IN_MIKTEX_DLL */
#endif /* MIKTEX_DLL */
#define _MIKTEX_2 __stdcall
#endif /*  _WIN32 */

#if ! defined (_MIKTEX_1)
#define _MIKTEX_1
#endif /* ! _MIKTEX_1 */

#if ! defined (_MIKTEX_2)
#define _MIKTEX_2
#endif /* ! _MIKTEX_2 */

#include <signal.h>
#include <setjmp.h>

#if defined (_WIN32)
#  define WIN32_LEAN_AND_MEAN
#  include <windows.h>
#endif

#define _C4P_FILE(f) (f)._c4p_fp, &(f)._c4p_buf, sizeof ((f)._c4p_buf)
#define _C4P_FP(f) &(f)._c4p_fp, &(f)._c4p_buf, sizeof ((f)._c4p_buf)

typedef int boolean;

#define false ((boolean) 0)
#define true ((boolean) 1)

typedef int integer;
#define maxint INT_MAX

typedef struct
{
  FILE *_c4p_fp;
  char _c4p_buf;
} _c4p_textfile_t;

typedef struct
{
  FILE *_c4p_fp;
  unsigned char _c4p_buf;
} _c4p_bytefile_t;

typedef _c4p_textfile_t text;
typedef float real;
typedef double longreal;

typedef jmp_buf c4pjmpbuf;

#if defined (_WIN32)
typedef signed __int8 _c4p_s8;
typedef unsigned __int8 _c4p_u8;
typedef signed __int16 _c4p_s16;
typedef unsigned __int16 _c4p_u16;
typedef signed __int32 _c4p_s32;
typedef unsigned __int32 _c4p_u32;
#else /* ! _WIN32 */
typedef signed char _c4p_s8;
typedef unsigned char _c4p_u8;
typedef signed short _c4p_s16;
typedef unsigned short _c4p_u16;
typedef signed int _c4p_s32;
typedef unsigned int _c4p_u32;
#endif /* _WIN32 */

#define _C4P_FOR_BEGIN(var, ini, rel, fin)          	\
{                                                       \
  integer _c4p_temp = (fin);                            \
  if ((var = (ini)) rel _c4p_temp)                      \
    for (;;)                                            \
      {

#define _C4P_FOR_END(var, op)                       	\
	if (var op == _c4p_temp)                     	\
	  break;                                        \
      }                                                 \
}

_MIKTEX_1 extern text input;
_MIKTEX_1 extern text output;

_MIKTEX_1 extern integer c4pargc;
_MIKTEX_1 extern char * c4pargv[];
_MIKTEX_1 extern struct tm _c4p_start_time;

_MIKTEX_1 extern integer c4pplen;
_MIKTEX_1 extern char c4ppline[];

#define abs(i) ((i) < 0 ? -(i) : (i))
#define arctan atan
#define _c4p_break(f) fflush ((f)._c4p_fp)
#define chr(i) ((int) (i))
#define dispose _c4p_unimpl
#define eof(f) (feof ((f)._c4p_fp) ? true : false)
#define eoln(f) ((f)._c4p_buf == '\n' ? true : false)
#define get(f) _c4p_fread (_C4P_FILE (f))
#define ln log
#define new _c4p_unimpl
#define odd(i) ((i) & 1 ? true : false)
#define ord(i) (i)
#define pack _c4p_unimpl
#define page _c4p_unimpl
#define pred(i) ((i) - 1)
#define put(f) _c4p_fwrite (_C4P_FILE (f))
#define reset(f) _c4p_reset (_C4P_FILE (f))
#define rewrite(f) rewind ((f)._c4p_fp)
#define round(r) _c4p_round(r)
#define sqr sqrt
#define succ(i) ((i) + 1)
#define trunc(r) ((integer) (r))
#define unpack _c4p_unimpl

#define c4pmget(f, buf, n) _c4p_fread_n (_C4P_FILE (f), (buf), (n))

#define _C4P_READ_BEGIN() {
#define _C4P_READLN_BEGIN() _C4P_READ_BEGIN ()
#define _c4p_read_f(f, f2)
#define _c4p_read_v(v, f) (v) = (f)._c4p_buf; get (f)
#define _c4p_read_c(c, f) c = _c4p_get_char (&(f))
#define _c4p_read_i(i, f) i = _c4p_get_int (&(f))
#define _c4p_read_r(i, f) r = _c4p_get_real (&(f))
#define _C4P_READ_END(f) }
#define _C4P_READLN_END(f) _c4p_skip_to_eoln (&(f)); }
#define _c4p_readln() _c4p_skip_to_eoln (&input)

#define _C4P_WRITE_BEGIN() {
#define _C4P_WRITELN_BEGIN() _C4P_WRITE_BEGIN ()
#define _c4p_write_f(f,f2)
#define _c4p_write_v(v,f) (f)._c4p_buf = (v); put (f)
#define _c4p_write_c(c,f) putc ((c), (f)._c4p_fp)
#define _c4p_write_c1(c,w1,f) putc ((c), (f)._c4p_fp)
#define _c4p_write_i(i,f) fprintf ((f)._c4p_fp, "%ld", (integer) (i))
#define _c4p_write_i1(i,w1,f) fprintf \
	((f)._c4p_fp, "%*ld", (int) (w1), (integer) (i))
#define _c4p_write_i2(i,w1,w2,f) \
	fprintf ((f)._c4p_fp, "%*.*ld", (int) (w1), (int) (w2), (integer) (i))
#define _c4p_write_r(r,f) fprintf ((f)._c4p_fp, "%f", (float) (r))
#define _c4p_write_r2(r,w1,w2,f) \
	fprintf ((f)._c4p_fp, "%*.*f", (int) (w1), (int) (w2), (float) (r))
#define _c4p_write_s(s,f) fputs ((s), (f)._c4p_fp)
#define _C4P_WRITE_END(f) }
#define _C4P_WRITELN_END(f) putc ('\n', (f)._c4p_fp); }
#define _c4p_writeln() putc ('\n', output._c4p_fp)

#define c4pgetc(f) (f)._c4p_buf = getc ((f)._c4p_fp)
#define c4pputc(f) putc ((f)._c4p_buf, (f)._c4p_fp)

#define c4parrcpy(dst, src) memcpy (dst, src, sizeof (dst))
#define c4pmemcpy(dst, src, size) memcpy (dst, src, size)
#define c4pstrcpy(dst, src) strcpy (dst, src)
#define c4pstrlen(str) strlen (str)

#if 1
#define c4pfopen(f, n, m, cmpl) _c4p_fopen (_C4P_FP (f), n, m, cmpl)
#else
#define c4pfopen(f, n, m, cmpl)						\
  ((((f)._c4p_fp = fopen ((n), (m))) == 0)				\
   ? ((cmpl)								\
      ? (fprintf (stderr, "\n_c4p_fopen: can't open %s\n", (n)),	\
	 exit (EXIT_FAILURE),						\
	 false)								\
      : false)								\
   : true)
#endif

#define c4ptryfopen(f, n, m) c4pfopen (f, n, m, false)

#define c4pfclose(f)      	\
{                              	\
  if ((f)._c4p_fp)              \
    fclose ((f)._c4p_fp);       \
}

#define c4pexit(n) exit (n)
#define c4pfseek(f, offs, orig) _c4p_fseek (_C4P_FILE (f), offs, orig)
#define c4pftell(f) ftell ((f)._c4p_fp)
#define c4pbufwrite(f, buf, buf_size) fwrite (buf, buf_size, 1, (f)._c4p_fp)
#define c4pptr(obj) (&(obj))
#define c4psetjmp(buf) setjmp (buf)
#define c4plongjmp(buf,ret) longjmp (buf, ret)
#define c4pincr(lvalue) (lvalue)++
#define c4pdecr(lvalue) (lvalue)--

#define c4pcur SEEK_CUR
#define c4pend SEEK_END
#define c4pset SEEK_SET

#define c4prmode "r"
#define c4pwmode "w"
#define c4prbmode "rb"
#define c4pwbmode "wb"

#define c4pyear ((integer) _c4p_start_time.tm_year + 1900)
#define c4pmonth ((integer) _c4p_start_time.tm_mon+1)
#define c4pday ((integer) _c4p_start_time.tm_mday)
#define c4phour ((integer) _c4p_start_time.tm_hour)
#define c4pminute ((integer) _c4p_start_time.tm_min)
#define c4psec ((integer) _c4p_start_time.tm_sec)

_MIKTEX_1 void _MIKTEX_2 _c4p_proc_entry (unsigned handle);
_MIKTEX_1 void _MIKTEX_2 _c4p_proc_exit (unsigned handle);
_MIKTEX_1 void _MIKTEX_2 _c4p_skip_to_eoln (text *);
_MIKTEX_1 char _MIKTEX_2 _c4p_get_char (text *);
_MIKTEX_1 integer _MIKTEX_2 _c4p_get_int (text *);
_MIKTEX_1 real _MIKTEX_2 _c4p_get_real (text *);

_MIKTEX_1 boolean _MIKTEX_2 _c4p_fopen (FILE **, void *, size_t,
					const char *, const char *, int);

_MIKTEX_1 void _MIKTEX_2 _c4p_fread (FILE *, void *, size_t);
_MIKTEX_1 void _MIKTEX_2 _c4p_fread_n (FILE *, void *,
                                       size_t, void *, size_t);
_MIKTEX_1 void _MIKTEX_2 _c4p_fwrite (FILE *, const void *, size_t);
_MIKTEX_1 void _MIKTEX_2 _c4p_fseek (FILE *, void *, size_t, long, int);
_MIKTEX_1 void _MIKTEX_2 _c4p_reset (FILE *, void *, size_t);
_MIKTEX_1 integer _MIKTEX_2 _c4p_round (double);
_MIKTEX_1 int _MIKTEX_2 _c4p_startup (int, char **);

#if defined (_C4P_DEBUG)
#define _C4P_PROC_ENTRY(handle) _c4p_proc_entry (handle)
#define _C4P_PROC_EXIT(handle) _c4p_proc_exit (handle)
#else /* ! _C4P_DEBUG */
#define _C4P_PROC_ENTRY(handle)
#define _C4P_PROC_EXIT(handle)
#endif /* ! _C4P_DEBUG */

#undef _MIKTEX_1
#undef _MIKTEX_2

#endif /* ! _C4PLIB_H */
