// dvidoc.cpp : implementation of the CDviDoc class
// Time-stamp: "97/01/17 22:34:35 mik"
//
// Copyright (C) 1996, 97
//	Christian Schenk  <cschenk@berlin.snafu.de>
//
// This file is part of MiKTeX.
//
// MiKTeX is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
// 
// MiKTeX is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with MiKTeX; if not, write to the Free Software Foundation,
// 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

#include "stdafx.h"
#include "yap.h"

#include "dvidoc.h"

typedef long boolean;
#define NO_C4P
#include "miktex.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

CString CDviDoc::displaymode;
long CDviDoc::displayres;
long CDviDoc::displayshrinkfactor;
CString CDviDoc::printermode;
long CDviDoc::printerres;
long CDviDoc::pagexshift;
long CDviDoc::pageyshift;

/////////////////////////////////////////////////////////////////////////////
// CDviDoc

IMPLEMENT_DYNCREATE(CDviDoc, CDocument)

BEGIN_MESSAGE_MAP(CDviDoc, CDocument)
	//{{AFX_MSG_MAP(CDviDoc)
		// NOTE - the ClassWizard will add and remove mapping macros here.
		//    DO NOT EDIT what you see in these blocks of generated code!
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDviDoc construction/destruction

CDviDoc::CDviDoc ()

{
  dvifile = 0;
  context = 0;
}

CDviDoc::~CDviDoc ()

{
  if (dvifile)
    {
      dvi::destroy (dvifile);
      dvifile = 0;
    }
}

BOOL
CDviDoc::OnNewDocument ()

{
  if (!CDocument::OnNewDocument())
    return FALSE;
  
  // TODO: add reinitialization code here
  // (SDI documents will reuse this document)
  
  return TRUE;
}

/////////////////////////////////////////////////////////////////////////////
// CDviDoc serialization

void
CDviDoc::Serialize(CArchive& ar)

{
  if (ar.IsStoring())
    {
      // TODO: add storing code here
    }
  else
    {
      // TODO: add loading code here
    }
}

/////////////////////////////////////////////////////////////////////////////
// CDviDoc diagnostics

#ifdef _DEBUG
void
CDviDoc::AssertValid() const

{
  CDocument::AssertValid();
}

void
CDviDoc::Dump(CDumpContext& dc) const

{
  CDocument::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CDviDoc commands

BOOL
CDviDoc::OnOpenDocument(LPCTSTR lpszPathName) 

{
#ifdef USE_DIB
  dvifile = dvi::create (lpszPathName, displaymode, displayres, 0, 0, 4);
#else
  dvifile = dvi::create (lpszPathName, displaymode, displayres, 0, 0, 2);
#endif
  curpageidx = 0;
  return TRUE;
}


const dvi_page *
CDviDoc::curdvipage ()
  
{
  if (dvifile)
    return (&(*dvifile)[curpageidx]);
  else
    return (0);
}

const CSize &
CDviDoc::pagesize ()

{
  int addx = 10;
  int addy = 10;
  if (dvifile == 0)
    return (CSize (100, 100));
  else
    {
      long shrinkfactor = (isprintcontext () ? 1 : this->displayshrinkfactor);
      return (CSize ((dvifile->maxpagewidth () + addx) / shrinkfactor,
		     (dvifile->maxpageheight () + addy) / shrinkfactor));
    }
}

void
CDviDoc::nextpage ()
  
{
  if (dvifile && curpageidx < dvifile->pagecount () - 1)
    curpageidx++;
}

void
CDviDoc::prevpage ()
  
{
  if (dvifile && curpageidx > 0)
    curpageidx--;
}

void
CDviDoc::gotopage (int pageno)
  
{
  if (dvifile)
    {
      if (pageno >= dvifile->pagecount ())
	curpageidx = dvifile->pagecount () - 1;
      else if (pageno >= 0)
	curpageidx = pageno;
    }
}

int
CDviDoc::pagecount ()
  
{
  if (dvifile)
    return (dvifile->pagecount ());
  else
    return (1);
}

int
CDviDoc::pageno ()
  
{
  return (curpageidx);
}

void
CDviDoc::switchcontext (int c)
  
{
  if (dvifile)
    {
      context = c;
      dvifile->switchcontext (c);
    }
}

BOOL
CDviDoc::prepareprinting (const CDC *printer)
  
{
  dvifile->newmode (displaymode, displayres, printermode, printerres);
  return (TRUE);
}

BOOL CDviDoc::isprintcontext()
{
  return (context == 1);
}

void CDviDoc::newmode(const char *displaymode,
		      long displayres)
{
  dvifile->newmode (displaymode, displayres);
  UpdateAllViews (0);
}
