/*
 * Decompiled with CFR 0.152.
 */
package de.nm.ant;

import de.nm.ant.config.ConfigExecute;
import de.nm.ant.execute.ExecuteCmdTask;
import de.nm.file.XFile;
import de.nm.string.XString;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.UnknownElement;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.taskdefs.ExecuteStreamHandler;
import org.apache.tools.ant.taskdefs.LogStreamHandler;
import org.apache.tools.ant.taskdefs.PumpStreamHandler;
import org.apache.tools.ant.types.Environment;
import org.apache.tools.ant.types.Path;

public abstract class AbstractWorkerTask
extends Task {
    private static int runningNumber = 0;
    protected boolean debug = false;
    private boolean deletescriptfile = true;
    protected String encoding = "UTF-8";
    private HashMap<String, String> environment = null;
    protected boolean trim = true;
    private boolean usenewenvironment = false;
    protected boolean verbose = false;
    protected boolean verboseheader = true;

    protected void appendEnvPath(String key, Path value) {
        this.appendEnvPath(key, value.toString());
    }

    protected void appendEnvPath(String key, String value) {
        this.initEnvironment();
        String oldvalue = this.environment.get(key);
        if (oldvalue == null) {
            this.environment.put(key, value);
        } else if (!oldvalue.contains(value)) {
            this.environment.put(key, XString.concat((String[])new String[]{value, File.pathSeparator, oldvalue}));
        }
        this.logDebug(XString.concat((String[])new String[]{"ENVIONMENT append: ", key, "=", this.environment.get(key)}));
    }

    protected void checkMethod(Task task, String method, File value) {
        if (value != null) {
            try {
                Class<?> c = task.getClass();
                Method m = c.getMethod(method, File.class);
                m.invoke((Object)task, value);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    protected void checkMethod(Task task, String method, String value) {
        if (value != null) {
            try {
                Class<?> c = task.getClass();
                Method m = c.getMethod(method, String.class);
                m.invoke((Object)task, value);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    protected Task checkTask(Task task) {
        if (task instanceof UnknownElement) {
            UnknownElement u = (UnknownElement)task;
            u.maybeConfigure();
            return (Task)u.getRealThing();
        }
        task.maybeConfigure();
        return task;
    }

    protected String createBasename(File file) {
        String name = file.getName();
        int idx = name.lastIndexOf(46);
        if (idx >= 0) {
            return name.substring(0, idx);
        }
        return name;
    }

    protected File createDir(File dir, String ... name) {
        if (dir == null || name == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder(255);
        buf.append(dir.getAbsolutePath());
        for (int i = 0; i < name.length; ++i) {
            buf.append(File.separator);
            buf.append(name[i]);
        }
        return new File(buf.toString());
    }

    protected String createExtname(File file) {
        String name = file.getName();
        int idx = name.lastIndexOf(46);
        if (idx >= 0) {
            return name.substring(idx + 1);
        }
        return name;
    }

    protected File createFile(File dir, String name) {
        if (dir == null || name == null) {
            return null;
        }
        return new File(XString.concat((Object[])new Object[]{dir.getAbsoluteFile(), File.separator, name}));
    }

    protected File createFile(File dir, String name, String ext) {
        if (dir == null || name == null) {
            return null;
        }
        return this.createFile(dir, XString.concat((String[])new String[]{name, ".", ext}));
    }

    protected File createFile(String dir, String name) {
        if (dir == null || name == null) {
            return null;
        }
        return this.createFile(new File(dir), name);
    }

    protected File createFile(String dir, String name, String ext) {
        if (dir == null || name == null) {
            return null;
        }
        return this.createFile(dir, XString.concat((String[])new String[]{name, ".", ext}));
    }

    protected String createFileUri(File file) {
        if (file != null) {
            return "file://" + file.getAbsolutePath();
        }
        return null;
    }

    protected void executeCmd(ExecuteStreamHandler esh, Execute exeCmd, List<String> arguments, String baseexecutename) throws IOException {
        String[] argsarray = new String[arguments.size()];
        arguments.toArray(argsarray);
        this.executeCmd(esh, exeCmd, argsarray, baseexecutename);
    }

    protected void executeCmd(ExecuteStreamHandler esh, Execute exeCmd, String[] arguments, String baseexecutename) throws IOException {
        String[] newarguments = null;
        File scriptFile = null;
        ConfigExecute.Entry entry = ExecuteCmdTask.getEntry(baseexecutename);
        if (entry == null) {
            newarguments = new String[arguments.length + 1];
            newarguments[0] = baseexecutename;
            System.arraycopy(arguments, 0, newarguments, 1, arguments.length);
        } else if (entry.isScript()) {
            String scriptname = XString.concat((String[])new String[]{"script_", this.getTaskName(), "_", this.getRunningNumber(), entry.getScriptext()});
            scriptFile = this.createFile(exeCmd.getWorkingDirectory(), scriptname);
            this.logDebug(XString.concat((Object[])new Object[]{"creating ", scriptFile}));
            BufferedWriter out = XFile.getWriter((File)scriptFile, (String)this.encoding);
            Vector env = entry.getEnv().getVariablesVector();
            for (Environment.Variable var : env) {
                if (ExecuteCmdTask.isWindows()) {
                    out.write("set ");
                }
                out.write(var.getContent());
                out.newLine();
            }
            out.write(entry.getText());
            out.newLine();
            String[] parms = entry.getParams();
            if (parms != null && parms.length > 0) {
                for (String s : parms) {
                    out.write(s);
                    out.write(" ");
                }
            } else {
                out.write(baseexecutename);
                out.write(" ");
            }
            for (String s : arguments) {
                out.write(s);
                out.write(" ");
            }
            out.newLine();
            out.close();
            String[] shellcmd = entry.getShellcmd();
            if (shellcmd == null || shellcmd.length == 0) {
                this.throwBuildException((Exception)new BuildException("shellcmd must be set!"));
            }
            newarguments = new String[shellcmd.length + 1];
            System.arraycopy(shellcmd, 0, newarguments, 0, shellcmd.length);
            newarguments[newarguments.length - 1] = scriptFile.getAbsolutePath();
        } else {
            String[] parms = entry.getParams();
            newarguments = new String[parms.length + arguments.length];
            System.arraycopy(parms, 0, newarguments, 0, parms.length);
            System.arraycopy(arguments, 0, newarguments, parms.length, arguments.length);
            Vector env = entry.getEnv().getVariablesVector();
            for (Environment.Variable var : env) {
                this.setEnvEntry(var.getContent());
            }
        }
        this.logDebug(XString.append((char)' ', (String[])newarguments));
        exeCmd.setCommandline(newarguments);
        exeCmd.setAntRun(this.getProject());
        exeCmd.setNewenvironment(this.usenewenvironment);
        exeCmd.setEnvironment(this.getEnvArray());
        int err = exeCmd.execute();
        if (err > 0 && err != Integer.MAX_VALUE) {
            if (esh instanceof SilentStreamHandler) {
                String errors;
                SilentStreamHandler ssh = (SilentStreamHandler)esh;
                String output = ssh.getOutput();
                if (output != null && output.length() > 0) {
                    this.log(output, 0);
                }
                if ((errors = ssh.getErrors()) != null && errors.length() > 0) {
                    this.log(errors, 0);
                }
            }
            throw new BuildException("ERROR (" + err + ") " + XString.append((char)' ', (String[])arguments));
        }
        if (scriptFile != null && this.deletescriptfile) {
            this.logDebug(XString.concat((String[])new String[]{"deleting ", scriptFile.getAbsolutePath()}));
            scriptFile.delete();
        }
        esh.stop();
    }

    protected ExecuteStreamHandler executeStramHandler() {
        if (this.verbose) {
            return new LogStreamHandler((Task)this, 2, 1);
        }
        return new SilentStreamHandler();
    }

    protected ExecuteStreamHandler executeStramHandler(OutputStream stream) {
        return new PumpStreamHandler(stream, stream);
    }

    protected String[] getEnvArray() {
        this.initEnvironment();
        String[] env = new String[this.environment.size()];
        Iterator<String> it = this.environment.keySet().iterator();
        int i = 0;
        while (it.hasNext()) {
            String key = it.next();
            env[i++] = XString.concat((String[])new String[]{key, "=", this.environment.get(key)});
        }
        return env;
    }

    protected String getEnvEntry(String key) {
        this.initEnvironment();
        String value = this.environment.get(key);
        return value == null ? "" : value;
    }

    protected String getExecuteVariable(String name) {
        if (name != null) {
            Vector x = Execute.getProcEnvironment();
            for (String entry : x) {
                if (!entry.startsWith(name)) continue;
                return entry.substring(name.length() + 1);
            }
        }
        return null;
    }

    protected synchronized String getRunningNumber() {
        return XString.createZeroInt((int)runningNumber++, (int)6);
    }

    private void initEnvironment() {
        if (this.environment == null) {
            if (this.usenewenvironment) {
                this.environment = new HashMap();
            } else {
                Vector provEnv = Execute.getProcEnvironment();
                this.environment = new HashMap((int)((double)provEnv.size() * 1.5));
                int pos = -1;
                for (String entry : provEnv) {
                    pos = entry.indexOf("=");
                    if (pos < 0) continue;
                    this.environment.put(entry.substring(0, pos), entry.substring(pos + 1));
                }
            }
        }
    }

    protected void logDebug(String msg) {
        if (this.debug) {
            this.log(msg, 2);
        }
    }

    protected void logVerbose(File file) {
        this.logVerbose(file, false);
    }

    protected void logVerbose(File file, boolean onlyname) {
        if (this.verbose) {
            if (onlyname) {
                this.log(file.getName(), 2);
            } else {
                this.log(file.getAbsolutePath(), 2);
            }
        }
    }

    protected void logVerbose(File src, File dest) {
        if (this.verbose) {
            this.log(src.getAbsolutePath() + " -> " + dest.getAbsolutePath(), 2);
        }
    }

    protected void logVerbose(File src, File dest, boolean onlyname) {
        if (this.verbose) {
            if (onlyname) {
                this.log(src.getName() + " -> " + dest.getName(), 2);
            } else {
                this.log(src.getAbsolutePath() + " -> " + dest.getAbsolutePath(), 2);
            }
        }
    }

    protected void logVerbose(File file, String msg) {
        if (this.verbose) {
            this.log(file.getAbsolutePath() + " " + msg, 2);
        }
    }

    protected void logVerbose(String msg) {
        if (this.verbose) {
            this.log(msg, 2);
        }
    }

    protected void logVerboseHeader(File file) {
        if (this.verboseheader) {
            this.log(file.getName(), 2);
        }
    }

    protected void logVerboseHeader(File src, File dest, boolean onlyname) {
        if (this.verboseheader) {
            if (onlyname) {
                this.log(src.getName() + " -> " + dest.getName(), 2);
            } else {
                this.log(src.getAbsolutePath() + " -> " + dest.getAbsolutePath(), 2);
            }
        }
    }

    protected void logVerboseHeader(File file, String msg) {
        if (this.verboseheader) {
            if (msg == null) {
                this.log(file.getName(), 2);
            } else {
                this.log(XString.concat((String[])new String[]{file.getName(), " <", msg, ">"}), 2);
            }
        }
    }

    protected void logVerboseHeader(File file, String msg, File file2) {
        if (this.verboseheader) {
            if (msg == null) {
                this.log(file.getName(), 2);
            } else {
                this.log(XString.concat((String[])new String[]{file.getName(), " <", msg, "> (", file2.getName(), ")"}), 2);
            }
        }
    }

    protected void logVerboseHeader(String msg) {
        if (this.verboseheader) {
            this.log(msg, 2);
        }
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void setDeletescriptfile(boolean deletescriptfile) {
        this.deletescriptfile = deletescriptfile;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    protected void setEnvEntry(String entry) {
        int pos;
        if (entry != null && (pos = entry.indexOf("=")) >= 0) {
            this.setEnvEntry(entry.substring(0, pos), entry.substring(pos + 1));
        }
    }

    protected void setEnvEntry(String key, String value) {
        this.initEnvironment();
        this.environment.put(key, value);
        this.logDebug(XString.concat((String[])new String[]{"ENVIONMENT set: ", key, "=", value}));
    }

    protected void setExecuteEnvironment(Execute exeCmd, boolean newEnvironment, Environment env) {
        exeCmd.setNewenvironment(newEnvironment);
        String[] environment = env.getVariables();
        if (environment != null) {
            for (int i = 0; i < environment.length; ++i) {
                this.logVerbose("environment: " + environment[i]);
            }
        }
        exeCmd.setEnvironment(environment);
    }

    protected void setExecuteWorkingDir(Execute exeCmd, File workdir) {
        if (workdir != null) {
            this.logVerbose("workdir=" + workdir.getAbsolutePath());
            exeCmd.setWorkingDirectory(workdir);
        }
    }

    public void setTrim(boolean trim) {
        this.trim = trim;
    }

    public void setUsenewenvironment(boolean usenewenvironment) {
        this.usenewenvironment = usenewenvironment;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setVerboseheader(boolean verboseheader) {
        this.verboseheader = verboseheader;
    }

    protected void throwBuildException(Exception e) {
        if (this.debug) {
            e.printStackTrace();
        }
        throw new BuildException(XString.concat((String[])new String[]{((Object)((Object)this)).getClass().getName(), " (", e.getClass().getName(), ") -> ", e.getMessage()}), (Throwable)e);
    }

    protected void appendText(StringBuilder buf, String text, boolean replace, boolean notempty) {
        AbstractWorkerTask.appendText(this.getProject(), buf, text, this.trim, replace, notempty);
    }

    protected void appendText(StringBuilder buf, String text) {
        AbstractWorkerTask.appendText(this.getProject(), buf, text, this.trim, true, true);
    }

    public static void appendText(Project projet, StringBuilder buf, String text, boolean trim, boolean replace, boolean notempty) {
        if (text != null) {
            String newtext = text;
            if (trim) {
                newtext = text.trim();
            }
            if (!notempty || newtext.length() != 0) {
                if (replace) {
                    buf.append(projet.replaceProperties(newtext));
                } else {
                    buf.append(newtext);
                }
                buf.append("\n");
            }
        }
    }

    protected class SilentStreamHandler
    extends PumpStreamHandler {
        public SilentStreamHandler() {
            super((OutputStream)new ByteArrayOutputStream(), (OutputStream)new ByteArrayOutputStream());
        }

        public String getErrors() {
            try {
                ByteArrayOutputStream error = (ByteArrayOutputStream)this.getErr();
                return error.toString();
            }
            catch (Exception e) {
                return "";
            }
        }

        public String getOutput() {
            try {
                ByteArrayOutputStream error = (ByteArrayOutputStream)this.getOut();
                return error.toString();
            }
            catch (Exception e) {
                return "";
            }
        }

        public void stop() {
            super.stop();
            try {
                this.getErr().close();
                this.getOut().close();
            }
            catch (IOException e) {
                throw new BuildException((Throwable)e);
            }
        }
    }
}

