/*
 * Decompiled with CFR 0.152.
 */
package de.nm.ant.ipdf;

import com.itextpdf.text.DocumentException;
import com.itextpdf.text.pdf.PdfDictionary;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfObject;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.PdfRectangle;
import com.itextpdf.text.pdf.PdfStamper;
import de.nm.ant.ipdf.AbstractPagesPdfTask;
import de.nm.string.XString;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.taskdefs.ExecuteStreamHandler;

public class PdfCropPageTask
extends AbstractPagesPdfTask {
    private boolean autocrop = false;
    private boolean useHiRes = false;
    private float llx;
    private float lly;
    private float urx;
    private float ury;
    private boolean addOnePoint = true;
    private final HashMap<Integer, String> pagemap = new HashMap();

    public void execute() {
        File input = this.getInputFile("pdf", this.usesrcfile);
        File output = this.getOutputFile("pdf");
        this.logVerboseHeader(input, this.pages);
        try {
            if (this.autocrop) {
                this.runGhostScript(input);
            }
            PdfReader reader = this.createPdfReaderFromFile(input);
            this.maxPage = reader.getNumberOfPages();
            PdfStamper stamper = new PdfStamper(reader, this.createOutputStream(output), this.version);
            int i = 1;
            while (i <= this.maxPage) {
                if (this.isPageinRange(i)) {
                    PdfDictionary pageDict = reader.getPageN(i);
                    PdfRectangle rect = this.getRectangle(i);
                    if (rect != null) {
                        pageDict.put(PdfName.CROPBOX, (PdfObject)rect);
                    }
                }
                ++i;
            }
            stamper.close();
        }
        catch (IOException e) {
            this.throwBuildException(e);
        }
        catch (DocumentException e) {
            this.throwBuildException((Exception)((Object)e));
        }
    }

    private PdfRectangle getRectangle(int page) {
        PdfRectangle rect = null;
        if (this.autocrop) {
            String boundingbox;
            if (this.addOnePoint) {
                this.llx = 1.0f;
                this.lly = 1.0f;
                this.urx = 1.0f;
                this.ury = 1.0f;
            }
            if ((boundingbox = this.pagemap.get(page)) != null) {
                String[] bbox = boundingbox.trim().split(" ", 4);
                try {
                    float xllx = Float.parseFloat(bbox[0]) - this.llx;
                    float xlly = Float.parseFloat(bbox[1]) - this.lly;
                    float xurx = Float.parseFloat(bbox[2]) + this.urx;
                    float xury = Float.parseFloat(bbox[3]) + this.ury;
                    rect = new PdfRectangle(xllx, xlly, xurx, xury);
                }
                catch (NumberFormatException e) {
                    rect = null;
                }
            }
        } else {
            rect = new PdfRectangle(this.llx, this.lly, this.urx, this.ury);
        }
        this.logDebug(XString.concat((Object[])new Object[]{"page ", String.valueOf(page), "  ", rect}));
        return rect;
    }

    private void parseOutput(ByteArrayOutputStream stream) {
        try {
            String line;
            String bb = this.useHiRes ? "%%HiResBoundingBox:" : "%%BoundingBox:";
            ByteArrayInputStream bin = new ByteArrayInputStream(stream.toByteArray());
            BufferedReader in = new BufferedReader(new InputStreamReader(bin));
            int page = 1;
            while ((line = in.readLine()) != null) {
                if (!line.startsWith(bb)) continue;
                String boundingbox = line.substring(bb.length());
                this.pagemap.put(page++, boundingbox);
            }
            in.close();
            bin.close();
            stream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void runGhostScript(File input) throws IOException {
        ByteArrayOutputStream stream = new ByteArrayOutputStream(this.buffersize);
        ExecuteStreamHandler esh = this.executeStramHandler(stream);
        Execute exeCmd = new Execute(esh, null);
        this.setExecuteWorkingDir(exeCmd, this.workdir);
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add("-sDEVICE=bbox");
        arguments.add("-dBATCH");
        arguments.add("-dNOPAUSE");
        arguments.add("-c");
        arguments.add("save");
        arguments.add("pop");
        arguments.add("-f");
        arguments.add(input.getAbsolutePath());
        this.executeCmd(esh, exeCmd, arguments, "gs");
        this.logDebug(stream.toString());
        this.parseOutput(stream);
    }

    public void setAddOnePoint(boolean addOnePoint) {
        this.addOnePoint = addOnePoint;
    }

    public void setAutocrop(boolean autocrop) {
        this.autocrop = autocrop;
    }

    public void setLlx(float llx) {
        this.llx = llx;
    }

    public void setLly(float lly) {
        this.lly = lly;
    }

    public void setUrx(float urx) {
        this.urx = urx;
    }

    public void setUry(float ury) {
        this.ury = ury;
    }

    public void setUseHiRes(boolean useHiRes) {
        this.useHiRes = useHiRes;
    }
}

