/*
 * Decompiled with CFR 0.152.
 */
package de.nm.ant.parallel;

import de.nm.ant.parallel.IfNewerTask;
import de.nm.file.XCheckSum;
import de.nm.file.XFile;
import java.io.File;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.LinkedList;
import java.util.Properties;
import org.apache.tools.ant.TaskContainer;

public class IfChecksumTask
extends IfNewerTask
implements TaskContainer {
    private static final String CHECHSUMFILE = "checksum.properties";
    private String checksum = "sha-256";
    private String prename = "";
    private final Properties checksumprops = new Properties();

    private void checkChecksum(LinkedList<File> todofiles) {
        this.readsavechecksum(true);
        XCheckSum chsum = null;
        try {
            chsum = new XCheckSum(this.checksum);
        }
        catch (NoSuchAlgorithmException e1) {
            this.throwBuildException(e1);
        }
        int n = todofiles.size();
        for (int i = 0; i < n; ++i) {
            File sf = todofiles.removeFirst();
            if (!sf.exists()) {
                this.log("File " + sf.getAbsoluteFile() + " not exists!", 0);
            }
            File df = new File(this.destdir + File.separator + XFile.getBasename((File)sf) + "." + this.destextname);
            try {
                String srcCheckSum = chsum.getChecksum(sf);
                String oldCheckSUm = this.checksumprops.getProperty(sf.getAbsolutePath());
                if (srcCheckSum.equals(oldCheckSUm)) continue;
                this.checksumprops.setProperty(sf.getAbsolutePath(), srcCheckSum);
                this.logVerboseHeader(sf);
                this.logVerbose(sf.getAbsolutePath() + " -> " + df.getAbsolutePath() + " (" + this.checksum + ": " + srcCheckSum + ")");
                this.runTasks(sf, df);
                continue;
            }
            catch (IOException e) {
                this.throwBuildException(e);
                continue;
            }
            catch (NoSuchAlgorithmException e) {
                this.throwBuildException(e);
            }
        }
        this.readsavechecksum(false);
    }

    @Override
    public void execute() {
        this.checkChecksum(this.tofofiles());
        this.checkThread();
    }

    private void readsavechecksum(boolean read) {
        File csfile = this.createFile(this.destdir, this.prename + CHECHSUMFILE);
        try {
            if (read) {
                if (csfile.exists()) {
                    this.checksumprops.load(XFile.getReader((File)csfile, (String)this.encoding));
                }
            } else {
                this.checksumprops.store(XFile.getWriter((File)csfile, (String)this.encoding), this.checksum);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void setChecksum(String checksum) {
        this.checksum = checksum;
    }

    public void setPrename(String prename) {
        this.prename = prename;
    }
}

