// SPDX-License-Identifier: BSD-3-Clause
package org.islandoftex.arara.core.localization

import org.islandoftex.arara.api.localization.MPPLocale
import org.islandoftex.arara.api.localization.Messages

@Suppress("MaxLineLength")
class GermanLanguage : Messages(
    providedLocale = MPPLocale("de"),
    translators = listOf("Marco Daniel", "Ben Frank", "Gert Fischer"),
    ERROR_BASENAME_NOT_A_FILE = "Die Methode des \"Dateinamens\" (\"basename\") benötigt eine Datei und kein Verzeichnis. Es scheint, als sei \"%s\" keine Datei. Falls du Aufgaben auf ein Verzeichnis bzw. Ordner anwenden willst, kannst du eine Vielzahl von JAVA API-Methoden verwenden.",
    ERROR_CALCULATEHASH_IO_EXCEPTION = "Aus was für einem Grund auch immer kann ich die Prüfziffer (checksum) nicht berechnen. Ich habe keine Idee, warum es fehlschlägt. Vielleicht wurde die Datei bevor oder während der Prüfziffer-Operation bewegt oder gelöscht. Möglicherweise habe ich nicht die geeigneten Rechte, um die Datei zu lesen.",
    ERROR_CHECKBOOLEAN_NOT_VALID_BOOLEAN = "Es scheint, als sei \"%s\" kein logischer Ausdruck (boolean value). Das sollte leicht zu beheben sein. Stelle sicher, dass der Eingabestring ein zugelassener logischer Ausdruck ist (\"yes\" oder \"no\", \"true\" oder \"false\", \"1\" oder \"0\" sowie \"on\" oder \"off\").",
    ERROR_CHECKREGEX_IO_EXCEPTION = "Ich konnte den Inhalt der Datei \"%s\" nicht lesen. Ich erhielt einen IO-Fehler. Ich habe keine Idee für die Fehlerursache, obwohl?. Vielleicht wurde die Datei bevor oder während des Leseprozesses bewegt oder gelöscht. Möglicherweise habe ich nicht die geeigneten Rechte, um die Datei zu lesen.",
    ERROR_CONFIGURATION_GENERIC_ERROR = "Ich konnte die Konfigurationsdatei nicht analysieren, etwas schlechtes passierte. Dieser Teil ist ziemlich knifflig, denn er bezieht das zugrundeliegende Datenserialisierungsformat mit ein. Ich werde mein Bestes tun, um dir in jeglicher Art und Weise zu helfen.",
    ERROR_CONFIGURATION_LOOPS_INVALID_RANGE = "In der Konfigurationsdatei hat der eingegebenen Wert 'loops' zur Festlegung der maximalen Anzahl an Schleifendurchgängen einen ungültigen Bereich. Bitte stelle sicher, dass eine positive Zahl eingetragen wird.",
    ERROR_DISCOVERFILE_FILE_NOT_FOUND = "Ich konnte die vorausgesetzte Datei \"%s\" %s nicht finden. Bitte stelle sicher, dass die Datei existiert und eine gültige Dateiendung hat.",
    ERROR_EVALUATE_COMPILATION_FAILED = "Aus was für einen Grund auch immer kann ich den Ausdruck in der bereitgestellten Bedingung nicht kompilieren. Dieser Teil ist ziemlich knifflig, denn er bezieht die zugrundeliegende Sprache mit ein. Ich werde mein Bestes tun, um dir in jeglicher Art und Weise zu helfen.",
    ERROR_EVALUATE_NOT_BOOLEAN_VALUE = "Die Auswertung der Bedingung (conditional) hat einen boolschen Ausdruck als Ergebnis erwartet. Das sollte leicht zu beheben sein. Stelle einfach sicher, dass die Bedingung einen booleschen Ausdruck ('yes' oder 'no', 'true' oder 'false', '1' oder '0' sowie 'on' oder 'off') als Ergebnis erhält.",
    ERROR_EXTRACTOR_IO_ERROR = "Es gab einen IO-Fehler während ich versuchte, die Direktive zu extrahieren. Ich habe keine Idee, warum es fehlschlug. Vielleicht wurde die Datei bevor oder während der Prüfziffer-Operation bewegt oder gelöscht. Möglicherweise habe ich nicht die geeigneten Rechte, um die Datei zu lesen.",
    ERROR_EXTRACTOR_INTERPOLATION_FAILURE = "Das 'Options'-Feld enthält einen Eintrag, mit dem der MVEL-Parser nicht umgehen kann. Bitte überprüfen Sie alle '@{…}'-Teile im 'Options'-Feld.",
    ERROR_FILETYPE_NOT_A_FILE = "Die Methode der Dateitypen \"filetype\" fordert als Eingabe eine Datei und kein Verzeichnis. Es scheint, als sei \"%s\" keine Datei. Falls du Aufgaben auf ein Verzeichnis bzw. Ordner anwenden willst, kannst du eine Vielzahl von JAVA API-Methoden verwenden.",
    ERROR_FILETYPE_UNKNOWN_EXTENSION = "Ich kann \"%s\" als keine vorgegebene Dateiendung erkennen. Falls du einen neuen Dateitypen definieren möchtest, stelle sich, dass die Dateiendung sowie die entsprechende Struktur bereitgestellt wird. Das sind die vordefinierten Dateiendungen: %s",
    ERROR_GETAPPLICATIONPATH_ENCODING_EXCEPTION = "Es gab ein Kodierungsproblem während ich versuchte den Anwendungspfad zu erhalten. Es gibt leider nicht viel, was ich tun kann.",
    ERROR_INTERPRETER_ARGUMENT_IS_REQUIRED = "Es scheint, als sei \"%s\" eine geforderte Eingabe in der Regel, aber ich kann sie in den Eingabeparametern nicht finden. Bitte stelle sicher, dass der Parameter in deiner Direktive ergänzt wird und versuche es erneut.",
    ERROR_INTERPRETER_COMMAND_RUNTIME_ERROR = "Ich konnte eines der genutzten Kommandos nicht auswerten. Dieser Teil ist ziemlich knifflig, denn er bezieht Aspekte der zugrundeliegenden Sprache mit ein. Ich werde mein Bestes tun, um dir in jeglicher Art und Weise zu helfen.",
    ERROR_INTERPRETER_COMMAND_UNSUCCESSFUL_EXIT = "Das Kommando \"%s\" wurde unerwarteterweise mit einem Nicht-Null-Rückgabewert beendet. Bitte analysieren Sie den Output des Kommandos und ziehen Sie daraus Schlüsse auf mögliche Lösungen des Problems.",
    ERROR_INTERPRETER_EXIT_RUNTIME_ERROR = "Ich kann den Status der Fertigmeldung (exit status) von einer der genutzten Anweisungen nicht auswerten. Dieser Teil ist ziemlich knifflig, denn er bezieht Aspekte der zugrundeliegenden Sprache mit ein. Ich werde mein Bestes tun, um dir in jeglicher Art und Weise zu helfen.",
    ERROR_INTERPRETER_FLAG_RUNTIME_EXCEPTION = "Ich kann den Statusindikator (flag expression) eines Argumentes nicht auswerten. Dieser Teil ist ziemlich knifflig, denn er bezieht Aspekte der zugrundeliegenden Sprache mit ein. Ich werde mein Bestes tun, um dir in jeglicher Art und Weise zu helfen.",
    ERROR_INTERPRETER_RULE_NOT_FOUND = "Ich konnte keine Regel mit dem Namen \"%s\" in den hinterlegten Regelverzeichnissen finden. Vielleicht ein falsch geschriebenes Wort? Ich habe nach dem Dateinamen \"%s.yaml\" in den nachstehenden Verzeichnissen mit entsprechender Priorität gesucht: %s",
    ERROR_INTERPRETER_UNKNOWN_KEYS = "Ich habe folgende unbekannte Keys in der Direktive gefunden: %s. Das sollte leicht zu beheben sein, entferne sie einfach.",
    ERROR_INTERPRETER_USER_REQUESTED_HALT = "arara wird auf Ihren Wunsch gestoppt.",
    ERROR_INTERPRETER_WRONG_EXIT_CLOSURE_RETURN = "Der Ausdruck 'exit' muss immer einen logischen Wert (boolean value) zurückgeben (sogar wenn es keine Berechnung in der Prozedur gibt). Das sollte leicht zu beheben sein: Stelle einen korrekten Rückgabewert sicher und versuche es erneut.",
    ERROR_INTERPRETER_WRONG_RETURN_TYPE = "Eine Regel darf nur entweder einen logischen Wert (boolean value) oder ein Kommando zurückgeben. Andere Rückgaben werden nicht unterstützt.",
    ERROR_LOAD_COULD_NOT_LOAD_XML = "Ich konnte die YAML-Datenbank mit dem Namen \"%s\" nicht laden. Ich habe keine Idee für die Fehlerursache, obwohl? Vielleicht wurde die Datei bevor oder während der Leseoperation bewegt oder gelöscht. Möglicherweise habe ich nicht die geeigneten Rechte, um die Datei zu lesen.",
    ERROR_PARSER_INVALID_PREAMBLE = "Leider konnte die Präambel \"%s\" nicht gefunden werden. Bitte stelle sicher, dass dieser Schlüssel in der Konfigurationsdatei existiert.",
    ERROR_PARSERULE_GENERIC_ERROR = "Ich konnte die Regel nicht auswerten, etwas schlechtes passierte. Dieser Teil ist ziemlich knifflig, denn er bezieht Aspekte der zugrundeliegenden Serialisierung mit ein. Ich werde mein Bestes tun, um dir in jeglicher Art und Weise zu helfen.",
    ERROR_REPLICATELIST_MISSING_FORMAT_ARGUMENTS_EXCEPTION = "Ich konnte die Liste auf Grund eines fehlendes Formatargumentes nicht replizieren. Meine Vermutung ist, dass es weniger (oder mehr) Parameter als erwartet gibt. Stelle sicher, dass die korrekte Anzahl an Parametern übergeben wird und versuche es erneut.",
    ERROR_RULE_IDENTIFIER_AND_PATH = "Ich habe einen Fehler in der Regel \"%s\" an der Stellte \"%s\" entdeckt.",
    ERROR_RUN_GENERIC_EXCEPTION = "Ich konnte das geforderte Systemkommando nicht ausführen, etwas schlechtes passierte. Dieser Teil ist ziemlich knifflig, denn er bezieht Aspekte der zugrundeliegenden Sprache mit ein. Ich werde mein Bestes tun, um dir in jeglicher Art und Weise zu helfen.",
    ERROR_RUN_INTERRUPTED_EXCEPTION = "Das aufgerufene Systemkommando ist plötzlich unterbrochen worden. Vielleicht gab es eine externe Unterbrechung, die das Kommando abrupt zur Beendigung zwang.",
    ERROR_RUN_INVALID_EXIT_VALUE_EXCEPTION = "Das aufgerufene Systemkommando hat einen ungültigen Abschluss gemeldet.",
    ERROR_RUN_IO_EXCEPTION = "Der Aufruf des Systemkommandos misslang auf Grund eines IO-Fehlers. Bist du dir sicher, dass das Systemkommando in deinem Pfad existiert? Es sollte eine gute Idee sein, die Systempfade sowie die Verfügbarkeit des Kommandos zu prüfen.",
    ERROR_RUN_TIMEOUT_EXCEPTION = "Die Ausführung des Systemkommandos hat die Zeitbegrenzung erreicht und wurde abgebrochen. Falls die Zeit etwas zu kurz war, kannst du diese erhöhen.",
    ERROR_SAVE_COULD_NOT_SAVE_XML = "Ich konnte die YAML-Datenbank mit dem Namen \"%s\" nicht speichern. Ich habe keine Idee für die Fehlerursache, obwohl? Möglicherweise habe ich nicht die geeigneten Rechte, um die Datei YAML-Datei auf der Festplatte zu speichern.",
    ERROR_SESSION_OBTAIN_UNKNOWN_KEY = "Die \"get\" Methode hat den unbekannten Eintrag (key) \"%s\" in der Session gefunden. Ich konnte nichts erhalten, was ich nicht bereits habe. Bitte gebe einen gültigen Key ein und versuche es erneut.",
    ERROR_SESSION_REMOVE_UNKNOWN_KEY = "Die \"remove\" Methode hat den unbekannten Eintrag (key) \"%s\" in der Session gefunden. Ich konnte nichts erhalten, was ich nicht bereits habe. Bitte gebe einen gültigen Key ein und versuche es erneut.",
    ERROR_VALIDATE_EMPTY_FILES_LIST = "Ich habe die Direktive %s gelesen und fand heraus, dass die bereitgestellte Dateienliste leer ist. Das sollte leicht zu beheben sein. Bitte stelle sicher, dass die Liste mindestens ein Element hat und versuche es erneut.",
    ERROR_VALIDATE_FILES_IS_NOT_A_LIST = "Ich habe die Direktive %s gelesen und fand heraus, dass der Eintrag \"files\" keine Liste übergeben bekommen hat. Bitte stelle sicher, dass du eine passende Liste verwendest und versuche es erneut.",
    ERROR_VALIDATE_INVALID_DIRECTIVE_FORMAT = "Ich entdecke eine ungültige Direktive namens %s in der bereitgestellten Datei. Stellte sicher, dass die Direktive gültig ist und versuche es erneut.",
    ERROR_VALIDATE_NO_DIRECTIVES_FOUND = "Es sieht so aus, als wurden keine Direktiven in der bereitgestellten Datei gefunden. Bitte stelle sicher, dass wenigstens eine Direktive enthalten ist und versuche es erneut.",
    ERROR_VALIDATE_ORPHAN_LINEBREAK = "Anscheinend gibt es einen verwaisten Zeilenumbruch in der Direktive in der Zeile %s. Ich kann nicht fortfahren. Bitte korrigiere die Direktive und versuche es erneut.",
    ERROR_VALIDATE_REFERENCE_IS_RESERVED = "Ich las die Direktive %s und fand heraus, dass der Key \"reference\" genutzt wurde. Dieser Key ist reserviert, deshalb kannst du ihn nicht nutzen. Aber keine Sorge, das sollte einfach zu beheben sein. Du musst nur einen anderen Namen verwenden.",
    ERROR_VALIDATE_YAML_EXCEPTION = "Es gab ein Problem mit dem bereitgestellten YAML-Ausdruck in der Direktive %s. Dieser Teil ist ziemlich knifflig, denn er bezieht Aspekte der zugrundeliegenden Serialisierung mit ein.",
    ERROR_VALIDATEBODY_ARGUMENT_ID_IS_RESERVED = "Die Argumentenbezeichnung \"%s\" ist reserviert, somit kannst du sie nicht nutzen. Dies sollte einfach zu beheben sein. Du musst nur einen anderen Namen verwenden.",
    ERROR_VALIDATEBODY_DUPLICATE_ARGUMENT_IDENTIFIERS = "Anscheinend hast du Duplikate von Bezeichnern in deiner Regel. Bitte behebe diesen Fehler und versuche es erneut.",
    ERROR_VALIDATEBODY_MISSING_KEYS = "Wenn du ein Argument einer Regel definierst, musst du mindestens 'flag' oder 'default' nutzen. Stelle bitte sicher, dass du mindestens eines nutzt.",
    ERROR_VALIDATEBODY_NULL_ARGUMENT_ID = "Ich habe herausgefunden, dass eines der Argumente keinen Bezeichner hat. Bitte ergänze einen gültigen Bezeichner im Argument und versuche es erneut.",
    ERROR_VALIDATEBODY_NULL_COMMAND = "Ich habe eine Nullanweisung in der vorgegebenen Regel gefunden. Bitte stelle sicher, dass ein gültiges Kommando zur Regel hinzugefügt wird.",
    ERROR_VALIDATEHEADER_NULL_NAME = "Die gewünschte Regel hat keinen Namen. Das sollte leicht zu beheben sein. Ergänze einen gültigen Namen und versuche es erneut.",
    ERROR_VALIDATEHEADER_WRONG_IDENTIFIER = "Die Regel hat einen falschen Bezeichner. Ich erwartete \"%s\" fand aber \"%s\". Das solle leicht zu beheben sein: Ersetze einfach den falschen durch einen korrekten Bezeichner.",
    INFO_DISPLAY_EXCEPTION_MORE_DETAILS = "Es sind mehr Details für diese Ausnahme verfügbar.",
    INFO_DISPLAY_EXECUTION_TIME = "Gesamt: %s Sekunden",
    INFO_DISPLAY_FILE_INFORMATION = "Verarbeitung \"%s\" (Größe: %s, letzte Modifikation: %s), bitte warten.",
    INFO_INTERPRETER_DRYRUN_MODE_BOOLEAN_MODE = "Trotz dry-run Modus wurde dieser Eintrag wahrscheinlich bereits verarbeitet, da er den boolschen Wert %s zurückgegeben hat.",
    INFO_INTERPRETER_DRYRUN_MODE_SYSTEM_COMMAND = "Los geht\"s: %s",
    INFO_LABEL_AUTHOR = "Autor:",
    INFO_LABEL_AUTHORS = "Autoren:",
    INFO_LABEL_CONDITIONAL = "Bedingung:",
    INFO_LABEL_NO_AUTHORS = "Kein Autor berücksichtigt",
    INFO_LABEL_ON_DETAILS = "DETAILS",
    INFO_LABEL_ON_ERROR = "FEHLER",
    INFO_LABEL_ON_FAILURE = "MISSERFOLG",
    INFO_LABEL_ON_SUCCESS = "ERFOLGREICH",
    INFO_LABEL_UNNAMED_TASK = "Namenlose Aufgabe",
    INFO_PARSER_NOTES = "arara ist unter der New BSD license veröffentlicht.",
    LOG_INFO_BEGIN_BUFFER = "BEGIN OUTPUT BUFFER",
    LOG_INFO_BOOLEAN_MODE = "Boolscher Wert: %s",
    LOG_INFO_DIRECTIVES_BLOCK = "DIREKTIVEN",
    LOG_INFO_END_BUFFER = "END OUTPUT BUFFER",
    LOG_INFO_INTERPRET_RULE = "Ich bin bereit, die Regel \"%s\" zu interpretieren.",
    LOG_INFO_INTERPRET_TASK = "Ich bin bereit, die Aufgabe \"%s\" von der Regel \"%s\" zu interpretieren.",
    LOG_INFO_POTENTIAL_PATTERN_FOUND = "Ich habe ein potentielles Muster in der Linie %s gefunden: %s",
    LOG_INFO_RULE_LOCATION = "Verzeichnis der Regel: \"%s\"",
    LOG_INFO_SYSTEM_COMMAND = "Systemkommando: %s",
    LOG_INFO_TASK_RESULT = "Resultat der Aufgabe:",
    LOG_INFO_VALIDATED_DIRECTIVES = "Alle Direktiven sind gültig. Wir sind guter Dinge.",
    LOG_INFO_WELCOME_MESSAGE = "Willkommen bei arara %s!"
)
