{$IFDEF WINDOWS}
{$N-,V-,W-,G+,R-,C MOVEABLE DISCARDABLE}
{$ELSE}
{$N-,E-,V-,O+,F+,R-}
{$ENDIF}

Unit bibWritB;

Interface

Uses
{$IFDEF WINDOWS}
  Wobjects, wbibdisp, wbibbin,
{$ELSE}
  Objects,bibdisp,
{$ENDIF}
  bibstrg, bibvars, bibfile, bibutil, bib8bit, rc_strng;

function WriteBibEntry(dump: PStream; Entry: EntryRecPtr;
                       fields: PFieldArr; Unix: boolean): boolean;


Implementation


function WriteBibEntry(dump: Pstream; Entry: EntryRecPtr;
                       fields: PFieldArr; Unix: boolean): boolean;

procedure DumpString;
var
  ifld : byte;
  line,tmp,tmp1,tmp2 : string;
  flen,i,ii,iii,loffset : longint;
  NotAlNum,firstfield,OK,barequote,IsPreamble : boolean;
  ch: char;
  BTemp: BigTypePtr;
  btlen,CurMaxBig,ind: word;
  SBuffer: array[1..400] of char;
  Delim: string[1];
begin                                { DumpString }
  TimeOutOn:=false;
  Btemp:=Nil;
  WinYield;
  with Entry^ do
  begin
    ifld:=StringIndex;
    IsPreamble:=(EntryType=TypeEntry^[PreambleTypeInd]);
    if index[ifld]>0 then
    begin
      if BigIndex[ifld]=0 then
      begin
        Btemp:=@SBuffer; CurMaxBig:=sizeof(SBuffer);
        btlen:=length(content[index[ifld]]);
        Move(content[index[ifld]][1],Btemp^,btlen);
      end else
      begin
        btemp:=@Big[BigIndex[ifld]]^; CurMaxBig:=MaxBig;
        btlen:=Blen[BigIndex[ifld]];
      end;
      if not OkField(Btemp^,btlen,3,'','',BareQuote) then
      begin
        if btlen>252 then tmp2:=Scopy(btemp,1,252)+'...'
        else tmp2:=Scopy(btemp,1,btlen);
        OK:=AskIf(tmp2,StringRC(Str_UnbalancedSuppressed,''),'OK','');
        btlen:=0;
      end;
      if FWrite7Bit then Conv27bit(Btemp^,btlen,false,CurMaxBig)
      else if FWrite8Bit then
      begin
        if Prog8Bit then
          Prog8ToFile8(BTemp^,btlen,false,CurMaxBig)
        else
          Conv28BitFile(Btemp^,btlen,false,false);
      end;

      { Head }
      Ind:=1;
      if DelimitBrace[true] or BareQuote then Delim:=lbrace
      else Delim:='"';
      tmp:='@'+EntryType+lbrace+' '; StrUpr(tmp);
      flen:=length(tmp)+1; loffset:=flen+1;
      if IsPreamble and (btlen>0) and (BTemp^[1]='@') then
      begin
        Delim:=''; Ind:=2;
      end;
      if not IsPreamble then tmp:=tmp+name+' = ';
      tmp:=tmp+Delim;
      if Delim=lbrace then Delim:=rbrace;
      StreamWrite(dump,tmp);

      { Body }
      line:='';
      repeat
        TeXWordGet(tmp1,BTemp^,BTlen,ind);
        if tmp1<>'' then
        begin
          if length(line)+length(tmp1)+1+loffset>LineWidth[BibTeXFormat] then
          begin
            StreamWriteln(dump,line,Unix); loffset:=0;
            FillChar(tmp2[1],flen,' '); tmp2[0]:=Chr(flen);
            line:=Concat(tmp2,tmp1);
          end else
          begin
            if length(line)>0 then line:=Concat(line,' ',tmp1)
            else line:=tmp1;
          end;
        end;
      until tmp1='';
      StreamWriteln(dump,line+Delim+' '+rbrace,Unix);
    end else if RetainNullFields and not IsPreamble then
    begin
      tmp:='@'+EntryType; StrUpr(tmp);
      tmp:=tmp+lbrace+' '+name+' = '+Delim+Delim+' '+rbrace;
      StreamWriteln(dump,tmp,Unix);
    end;
  end;
  Btemp:=Nil;
  WriteBibEntry:=true;
end;                                  { DumpString }

procedure DumpBibTeXFormat;
var
  ifld : integer;
  line,tmp,tmp1,tmp2 : string;
  flen,i,iaux,ii,iii,loffset : longint;
  NotAlNum,firstfield,OK,BareQuote,FirstStr: boolean;
  ch,Delim: char;
  ind,Btlen: Word;
  Btemp: BigTypePtr;
  CurMaxBig: word;
  SBuffer: array[0..400] of char;
  Empty: boolean;
begin                         { DumpBibTeXFormat }
  Btemp:=Nil;
  with Entry^ do
  begin
    FirstField:=true;
    tmp:=EntryType; StrUpr(tmp);
    StreamWriteln(dump,'@'+tmp+lbrace+name+',',Unix);
    for ifld:=1 to LastField do
    begin
      WinYield;
      if (index[ifld]>0) and ((fields=Nil) or (fields^[ifld])) then  { The field is not empty }
      if content[index[ifld]]<>'' then            { and is also requested. }
      begin
        if not FirstField then StreamWriteln(dump,',',Unix);
        FirstField:=false;
        flen:=length(field[index[ifld]])+5;          
        StreamWrite(dump,'  '+field[index[ifld]]+' = ');

        loffset:=flen+1;
        tmp:=content[index[ifld]];
        if BigIndex[ifld]=0 then
        begin
          Btlen:=length(tmp); Btemp:=@SBuffer;
          Move(tmp[1],Btemp^,Btlen);
          CurMaxBig:=sizeof(SBuffer);
        end else
        begin
          Btemp:=Big[BigIndex[ifld]]; Btlen:=Blen[BigIndex[ifld]];
          CurMaxBig:=MaxBig;
        end;
        if not OkField(Btemp^,Btlen,3,'','',BareQuote) then
        begin
          if btlen>252 then tmp2:=Scopy(btemp,1,252)+'...'
          else tmp2:=Scopy(btemp,1,btlen);
          OK:=AskIf(tmp2,StringRC(Str_UnbalancedSuppressed,''),'OK','');
          btlen:=0; tmp:='';
        end;
        Empty:=false;
        if RetainNullFields and (tmp=EmptyFieldChar) then
        begin
          tmp:=''; NotAlNum:=true; Empty:=true;
        end else NotAlNum:=false;
        if (tmp<>'') and (tmp[1]<>'@') then
        begin
          if (DetectNumeric=AlwaysDetect) or
             (FieldParams^[ifld].Numeric and (DetectNumeric<>NeverDetect)) then
            for i:=1 to length(tmp) do
            begin
              ch:=tmp[i];
              if not (ch in ['0'..'9']) then NotAlNum:=true;
            end
          else NotAlNum:=true;
        end;
        if DelimitBrace[false] or BareQuote then Delim:=lbrace
        else Delim:='"';
        if NotAlNum then StreamWrite(dump,Delim);
        if Delim=lbrace then Delim:=rbrace;
        line:=''; iaux:=1;
        if (tmp<>'') and (tmp[1]='@') then
        begin
          Delete(tmp,1,1); iaux:=2;
        end;
        if tmp<>'' then
        begin
          if FWrite7Bit then
            Conv27bit(Btemp^,Btlen,FieldParams^[ifld].AuthorLike,CurMaxBig)
          else if FWrite8Bit then
          begin
            if Prog8Bit then
              Prog8ToFile8(BTemp^,btlen,FieldParams^[ifld].AuthorLike,CurMaxBig)
            else
              Conv28BitFile(Btemp^,Btlen,FieldParams^[ifld].AuthorLike,false);
          end;
        end;
        ind:=iaux;
        tmp1:='';
        if not Empty then
        repeat
          TeXWordGet(tmp1,Btemp^,Btlen,ind);
          if tmp1<>'' then
          begin
            if length(line)+length(tmp1)+1+loffset>LineWidth[BibTeXFormat] then
            begin
              StreamWriteln(dump,line,Unix); loffset:=0;
              FillChar(tmp2[1],flen,' '); tmp2[0]:=Chr(flen);
              line:=Concat(tmp2,tmp1);
            end else
            begin
              if length(line)>0 then line:=Concat(line,' ',tmp1)
              else line:=tmp1;
            end;
          end;
        until tmp1='';
        if NotAlNum then StreamWrite(dump,line+Delim)
        else StreamWrite(dump,line);
      end;
    end;
{$IFDEF WINDOWS}
                       { Binary fields }
    for ifld:=0 to BinList^.Count-1 do
    begin
      WinYield;
      if not FirstField then StreamWriteln(dump,',',Unix);
      FirstField:=false;
      if DelimitBrace[false] then Delim:=lbrace else Delim:='"';
      tmp:=BinaryFields^+PBinObject(BinList^.at(ifld))^.Name;
      flen:=length(tmp)+6;
      StreamWrite(dump,'  '+tmp+' = '+Delim);
      FirstStr:=true;
      FillChar(tmp2[1],flen,' '); tmp2[0]:=Chr(flen);
      repeat
        tmp:=PBinObject(BinList^.at(ifld))^.GetCodedLine(FirstStr);
        if length(tmp)>1 then
        begin
          if not FirstStr then
          begin
            StreamWriteln(dump,'',Unix);
            StreamWrite(dump,tmp2);
          end;
          StreamWrite(dump,tmp);
        end;
        FirstStr:=false;
      until length(tmp)<Bin_EncodedLineLen;
      if Delim=lbrace then Delim:=rbrace;
      StreamWrite(dump,Delim);
    end;
{$ENDIF}
    StreamWriteln(dump,'',Unix); StreamWriteln(dump,rbrace,Unix);
  end;
  WriteBibEntry:=true;
end;                         { DumpBibTeXFormat }

begin                                  { WriteBibEntry }
  TimeOutOn:=false;
  MaxMemAvail;
  if UseReadEncodingOnly then
  begin
    Fwrite8bit:=File8bit; FWrite7bit:=File7bit;
  end;
  WriteBibEntry:=false;
  if (Entry=Nil) or (Entry^.nentry=0) then Exit;
  if EditOnlyStrings then DumpString
  else DumpBibTeXFormat;
end;                              { WriteBibEntry }

end.
