{$N-,E-,V-,O+,F+}

Unit bibedsrt;

Interface

uses
  bibwindo, objects, Dos, bibCrt, bibstrg, BibMouse, streams, bibstrm, bibwild,
  bibvars, bibfile, bibdisp, bibutil, bibsrtpt, bibsedit, bibedit, bib8bit,
  bibpchec, bibtext, bibselct, rc_strng, bibdialg, bibtmplt, bibcache, lfnunit;

procedure SortOptions(WhichSort: byte; var movedbib: boolean);


implementation


procedure SortOptions(WhichSort: byte; var MovedBib: boolean);
const
  Nlabels = 13;
  NCombinations = 14;
  ModeInd = 1;      CollationInd = 2;  SortOrderInd = 3;   NameOrderInd = 4;
  KeyField1Ind = 5; KeyOrder1Ind = 6;  KeyField2Ind = 7;   KeyOrder2Ind = 8;
  KeyField3Ind = 9; KeyOrder3Ind = 10;
  PatternInd = 11;  PattOrderInd = 12; StringSortInd = 13;
Var
  EditSortMode: ConfigSortType;
  wid,x0,y0,i,j,x,xx,y,yy,MaxWid,Current,OCur,WinHeight,nspec: integer;
  xfirst,att,ListNumber: Byte;
  NSortTypeNumber,NKey,TheInd: Byte;
  FirstKeyLen,SecondKeyLen: array[1..NSortKeys] of Byte;
  labels: array[1..Nlabels] of string[20];
  positions: array[1..Nlabels] of byte;
  OStr: array[1..NCombinations] of string[NSortCriteria];
  UnUsed: array[1..Nlabels] of boolean;
  ch: Char;
  line,tmp,tmp1: string;
  spaces: string[80];
  fname: string;
  Change,Esc,Enter,Space,LoadFile,SaveFile,finish,Bind: boolean;
  pchanged,IsPattern,accept,IsFirst,IsLast,FirstTime: boolean;
  WasModified,ABibFile: boolean;
  DoubleKeys: array[1..NSortKeys] of boolean;
  list,orders,LoadSaveList: ListArrPtr;
  spec: SpecArr;
  f: text;
  D,N,E: string;
  SScr: pointer;
  Pattern: PatRecPtr;

procedure ChooseSortKey(var Key: SortKeyType; y0: byte; prompt: string);
var
  tmp: string;
  accept: boolean;
  nbr: integer;
begin
  tmp:='_none';
  if (Key<>'') then DecompTemplate(tmp,Key);
  repeat
    GetAString(prompt,tmp,y0,255,wid-2,[#0..#31],accept,true);
    nbr:=ChrQty(tmp,lbrace)-ChrQty(tmp,rbrace);
    if nbr<>0 then ErrorMessageRC(Str_UnbalancedBraces,'');
  until nbr=0;
  PrepareTemplate(tmp); Key:=tmp;
end;                                     { ChooseSortKey }

procedure PrintLine(Ind: integer; line: string);
begin
  TpwprintW(y0+positions[Ind],x0+MaxWid+3,line+spaces,DialogNorm);
end;

begin                                    { SortOptions }
  wid:=74; y0:=2;
  x0:=(ScrWidth-wid) div 2 + 1;
  if ScrLen>25 then
  begin
    if ScrLen=28 then y0:=4
    else y0:=5;
  end;

  New(Pattern);
  MovedBib:=false;
  GetMem(list,(NCombinations+1)*sizeof(ListArrRec));
  list^[1] :='Name                        '; OStr[1] :='N';
  list^[2] :='Key, name                   '; OStr[2] :=#1+'N';
  list^[3] :='Key, key, name              '; OStr[3] :=#1#2+'N';
  list^[4] :='Key, key, key, name         '; OStr[4] :=#1#2#3+'N';
  list^[5] :='Pattern, name               '; OStr[5] :='PN';
  list^[6] :='Pattern, key, name          '; OStr[6] :='P'+#1+'N';
  list^[7] :='Key, pattern, name          '; OStr[7] :=#1+'PN';
  list^[8] :='Pattern, key, key, name     '; OStr[8] :='P'+#1#2+'N';
  list^[9] :='Key, pattern, key, name     '; OStr[9] :=#1+'P'+#2+'N';
  list^[10]:='Key, key, pattern, name     '; OStr[10]:=#1#2+'PN';
  list^[11]:='Pattern, key, key, key, name'; OStr[11]:='P'+#1#2#3+'N';
  list^[12]:='Key, pattern, key, key, name'; OStr[12]:=#1+'P'+#2#3+'N';
  list^[13]:='Key, key, pattern, key, name'; OStr[13]:=#1#2+'P'+#3+'N';
  list^[14]:='Key, key, key, pattern, name'; OStr[14]:=#1#2#3+'PN';
             
  labels[ModeInd]      :='Mode:';      positions[ModeInd]      :=2;
  labels[CollationInd] :='Collation:'; positions[CollationInd] :=3;
  labels[SortOrderInd] :='Sorting:';   positions[SortOrderInd] :=4;
  labels[NameOrderInd] :='NameOrder:'; positions[NameOrderInd] :=6;
  labels[KeyField1Ind] :='Key 1:' ;    positions[KeyField1Ind] :=8;
  labels[KeyOrder1Ind] :='Order:';     positions[KeyOrder1Ind] :=9;
  labels[KeyField2Ind] :='Key 2:';     positions[KeyField2Ind] :=11;
  labels[KeyOrder2Ind] :='Order:';     positions[KeyOrder2Ind] :=12;
  labels[KeyField3Ind] :='Key 3:';     positions[KeyField3Ind] :=14;
  labels[KeyOrder3Ind] :='Order:';     positions[KeyOrder3Ind] :=15;
  labels[PatternInd]   :='Pattern:';   positions[PatternInd]   :=17;
  labels[PattOrderInd] :='Order:';     positions[PattOrderInd] :=18;
  labels[StringSortInd]:='Strings:';   positions[StringSortInd]:=20;
  
  MaxWid:=0;
  for i:=1 to Nlabels do if length(labels[i])>MaxWid then
                                 MaxWid:=length(labels[i]);
  ChrFill(spaces,' ',80);
  WinHeight:=positions[Nlabels]+3;
  MakeWindow(y0,x0,WinHeight,wid,DialogNorm,DialogNorm,2,RNorm,Shadow,0);
  TitleWindow(1,DialogNorm,'['+#254+']');
  TitleWindow(6,DialogNorm,'[ok]');
  line:='[Load]'+#205+'[Save]';
  TitleWindow(4,DialogNorm,line);
  TpwAttr(y0+Winheight-1,x0+pos('L',line)+1,1,1,DialogBright);
  TpwAttr(y0+Winheight-1,x0+pos('S',line)+1,1,1,DialogBright);
  if UseMouse then
  begin
    ShowMouseCursor; ShowMouseCursor;
    HideMouseCursor;
  end;
  MaxMemAvail;

  if WhichSort=CSortMode_Default then                          { Default Sort Mode }
  begin
    EditSortMode:=ConfigSortMode^;
    RecallBufferStack(Pattern^,SortPattPosDef);
    Titlewindow(2,DialogBright,'Default sort parameters');
  end else if WhichSort=CSortMode_Current then                 { Current Sort Mode }
  begin
    EditSortMode:=CurrentSortMode^;
    RecallBufferStack(Pattern^,SortPattPosCur);
    Titlewindow(2,DialogBright,'Current sort parameters');
  end else if WhichSort=CSortMode_Export then                  { Export Sort Mode }
  begin
    EditSortMode:=ExportSortMode^;
    RecallBufferStack(Pattern^,SortPattPosExp);
    Titlewindow(2,DialogBright,'Export sort parameters');
  end else ErrorMessage(' Which sort mode is '+num2str(WhichSort)+'?! ');

  for i:=1 to Nlabels do
    Tpwprint(y0+positions[i],x0+maxWid-length(Labels[i])+2,Labels[i],DialogBright);
  Current:=0; change:=true; FirstTime:=true;

  WasModified:=true;
  with EditSortMode do
  repeat
    if change then 
    begin
      if (WhichSort<>CSortMode_Default) and (not SortingOn) then
      begin
        UnUsed[ModeInd]:=false;
        for i:=1 to Nlabels do
          if (i<>ModeInd) and (i<>StringSortInd) then UnUsed[i]:=true;
      end else
      begin
        for i:=1 to Nlabels do UnUsed[i]:=false;
        UnUsed[ModeInd]:=(WhichSort=CSortMode_Default);
        UnUsed[KeyField1Ind]:=(Pos(#1,SortTypeOrder)=0);
        UnUsed[KeyOrder1Ind]:=UnUsed[KeyField1Ind];
        UnUsed[KeyField2Ind]:=(Pos(#2,SortTypeOrder)=0);
        UnUsed[KeyOrder2Ind]:=UnUsed[KeyField2Ind];
        UnUsed[KeyField3Ind]:=(Pos(#3,SortTypeOrder)=0);
        UnUsed[KeyOrder3Ind]:=UnUsed[KeyField3Ind];
        UnUsed[PatternInd]:=(Pos('P',SortTypeOrder)=0);
        UnUsed[PattOrderInd]:=UnUsed[PatternInd];
      end;
      
      IsPattern:=(Pos('P',SortTypeOrder)>0);
      for i:=1 to NSortKeys do
      if not IsPattern then DoubleKeys[i]:=false
      else DoubleKeys[i]:=(Pos(Chr(i),SortTypeOrder)>Pos('P',SortTypeOrder));
      NSortTypeNumber:=1;
      while (NSortTypeNumber<NCombinations) and
            (SortTypeOrder<>Ostr[NSortTypeNumber]) do inc(NSortTypeNumber);

      if UnUsed[ModeInd] then tmp:='<unused>'
      else if SortingOn  then tmp:='Sorted'
      else                    tmp:='Unsorted';
      PrintLine(ModeInd,tmp);

      if UnUsed[CollationInd] then tmp:='<unused>'
      else if MixedCollation then tmp:='Mixed case'
      else tmp:='ASCII';
      PrintLine(CollationInd,tmp);

      ListNumber:=NSortTypeNumber;
      if UnUsed[SortOrderInd] then PrintLine(SortOrderInd,'<unused>')
      else PrintLine(SortOrderInd,List^[ListNumber]);

      if UnUsed[NameOrderInd] then tmp:='<unused>'
      else if IsPattern then
      begin
        if NameAsc[true] then  tmp:='Patt. true - ascending, '
        else                   tmp:='Patt. true - descending, ';
        if NameAsc[false] then tmp:=tmp+'Patt. false - ascending'
        else                   tmp:=tmp+'Patt. false - descending';
      end else
      begin
        if NameAsc[true] then tmp:='ascending'
        else                  tmp:='descending';
      end;
      PrintLine(NameOrderInd,tmp);

      for Nkey:=1 to NSortKeys do
      begin
        FirstKeyLen[NKey]:=0; SecondKeyLen[NKey]:=0;
        if Nkey=1 then TheInd:=KeyField1Ind
        else if Nkey=2 then TheInd:=KeyField2Ind
        else if Nkey=3 then TheInd:=KeyField3Ind;
        if UnUsed[TheInd] then tmp:='<unused>'
        else begin
          tmp:='_none';
          if (SortKey[NKey,true]<>'') then
          begin
            DecompTemplate(tmp,SortKey[NKey,true]);
            EncapsulateTemplate(tmp);
          end;
          FirstKeyLen[NKey]:=length(tmp);
          if DoubleKeys[NKey] then
          begin
            tmp1:='_none';
            if (SortKey[NKey,false]<>'') then
            begin
              DecompTemplate(tmp1,SortKey[NKey,false]);
              EncapsulateTemplate(tmp1);
            end;
            while (length(tmp)+length(tmp1)+2 > wid-MaxWid-4) do
            begin
              if length(tmp)>length(tmp1) then Delete(tmp,length(tmp),1)
              else Delete(tmp1,length(tmp1),1);
            end;
            FirstKeyLen[NKey]:=length(tmp);
            tmp:=tmp+', '+tmp1;
            SecondKeyLen[NKey]:=length(tmp);
          end;
        end;
        PrintLine(TheInd,tmp);

        if Nkey=1 then TheInd:=KeyOrder1Ind
        else if Nkey=2 then TheInd:=KeyOrder2Ind
        else if Nkey=3 then TheInd:=KeyOrder3Ind;
        if UnUsed[TheInd] then tmp:='<unused>'
        else if DoubleKeys[NKey] then
        begin
          if KeyAsc[NKey,true] then tmp:='ascending, '
          else                      tmp:='descending, ';
          if NullKeyFirst[NKey,true] then tmp:=tmp+'nulls first'
          else                            tmp:=tmp+'nulls last';
          if KeyAsc[NKey,false] then tmp:=tmp+'; ascending, '
          else                       tmp:=tmp+'; descending, ';
          if NullKeyFirst[NKey,false] then tmp:=tmp+'nulls first'
          else                             tmp:=tmp+'nulls last';
        end else
        begin
          if KeyAsc[NKey,true] then tmp:='ascending, '
          else                      tmp:='descending, ';
          if NullKeyFirst[NKey,true] then tmp:=tmp+'nulls first'
          else                            tmp:=tmp+'nulls last';
        end;
        PrintLine(TheInd,tmp);
      end;

      if UnUsed[PatternInd] then tmp:='<unused>'
      else if not IsPattern then tmp:='<none>'
      else begin
        if UsePatternFile then
        begin
          if SortPatternFile='' then tmp:='In file '+'<undefined>'
          else tmp:='In file '+SortPatternFile;
        end else
        begin
          if Pattern^.noper=0 then tmp:='<undefined>'
          else tmp:='<explicit>';
        end;
      end;
      PrintLine(PatternInd,tmp);

      if UnUsed[PattOrderInd] then tmp:='<unused>'
      else if PattFirst then    tmp:='Put pattern-conforming entries first'
      else                      tmp:='Put pattern-conforming entries last';
      PrintLine(PattOrderInd,tmp);

      if UnUsed[StringSortInd] then tmp:='<unused>'
      else
        case StringNameSort of
          StrSortOff:     tmp:='Unsorted                     ';
          StrSortAscend:  tmp:='Sort in ascending name order ';
          StrSortDescend: tmp:='Sort in descending name order';
        end;
      PrintLine(StringSortInd,tmp);

      change:=false;
    end;
    OCur:=Current;
    Esc:=False; Enter:=false; Space:=false;
    LoadFile:=false; SaveFile:=false;
    if not FirstTime then
    begin
      if UseMouse then
      begin
        WaitForRelease(255);
        ShowMouseCursor;
      end;
      ch:=ReadKeyMouse;
      if UseMouse then HideMouseCursor;
    end;
    if FirstTime then
    begin
      repeat
        inc(Current); if Current>Nlabels then Current:=1;
      until not UnUsed[Current];
      FirstTime:=false;
    end else if Event.mpress then                      { Mouse }
    begin
      x:=Event.x-x0; y:=Event.y-y0;
      yy:=0;
      if (y>0) and (x>0) and (x<60) then
        for i:=1 to Nlabels do
          if (y=positions[i]) and (not UnUsed[i]) then yy:=i;
      if yy>0 then
      begin
        if x>MaxWid then Space:=true;
        current:=yy;
      end else if (y>=0) and (y<=WinHeight) and (x>=0) and (x<=Wid) then
      begin
        tmp:='';
        ReadScrStr(tmp,x+x0,y+y0,xfirst,att,
                      ['[','o','k','S','a','v','e','L','d',#254,']'] );
        if tmp='[ok]' then Enter:=true
        else if tmp=Concat('[',#254,']') then Esc:=true
        else if tmp='[Load]' then LoadFile:=true
        else if tmp='[Save]' then SaveFile:=true;
      end;
    end else if ch=#0 then           { Arrows and Alt keys }
    begin
      ch:=ReadKey;
      if (ch=#72) then
        repeat
          Dec(Current); if Current=0 then Current:=Nlabels;
        until not UnUsed[Current]
      else if (ch=#80) then
        repeat
          Inc(Current); if Current>Nlabels then Current:=1;
        until not UnUsed[Current]
      else if ch=#38 then LoadFile:=true
      else if ch=#31 then SaveFile:=true
      else if (ch=#59) then ContextHelp('Sort Options Screen');
      if Current=0 then Current:=Nlabels
      else if Current=Nlabels+1 then Current:=1;
    end else                         { Others }
    begin
      if ch=#27 then Esc:=true
      else if ch=#13 then Enter:=true
      else if ch=' ' then Space:=true
      else if (ch='l') or (ch='L') then LoadFile:=true
      else if (ch='s') or (ch='S') then SaveFile:=true
    end;
    if Current<>OCur then
    begin
      if OCur>0 then
        Tpwattr(y0+positions[OCur],x0+maxWid-length(Labels[OCur])+2,1,
              length(labels[OCur]),DialogBright);
      Tpwattr(y0+positions[current],x0+maxWid-length(Labels[current])+2,1,
              length(labels[current]),DialogRev);
    end;
    if LoadFile then
    begin
      GetMem(LoadSaveList,6*sizeof(ListArrRec));
      LoadSaveList^[1]:='Default sort mode';
      LoadSaveList^[2]:='Current sort mode';
      LoadSaveList^[3]:='Export  sort mode';
      LoadSaveList^[4]:='Current database ';
      LoadSaveList^[5]:='Other file       ';      
      nspec:=0; Spec[1]:=WhichSort;
      FieldChoose(LoadSaveList^,5,1,length(LoadSaveList^[1])+1,Spec,nspec,
                  true,false,1,0,true,true);
      FreeMem(LoadSaveList,6*sizeof(ListArrRec));
      if nspec>0 then
      begin
        if Spec[1]=1 then
        begin
          EditSortMode:=ConfigSortMode^;
          RecallBufferStack(Pattern^,SortPattPosDef);
        end else if Spec[1]=2 then
        begin
          EditSortMode:=CurrentSortMode^;
          RecallBufferStack(Pattern^,SortPattPosCur);
        end else if Spec[1]=3 then
        begin
          EditSortMode:=ExportSortMode^;
          RecallBufferStack(Pattern^,SortPattPosExp);
        end else if Spec[1]=4 then
        begin
          ResetBibFile(bib,bibname^);
          finish:=false; i:=0;
          while (not eof(bib)) and (not finish) and (i<=MaxLookForSort) do
          begin
            tmp:='';
            readline(bib,tmp,UnixBib); ChrDel(tmp,' '); StrLwr(tmp);
            inc(i);
            if tmp='\sort'+lbrace then
            begin
              LoadSortMode(bib,Nil,EditSortMode,Pattern);
              finish:=true;
            end;
          end;
          movedbib:=true;
        end else if Spec[1]=5 then
        begin
          fname:='';
          FileChoose(fname,DefExtension[BibTeXFormat]^,TexInputList,
                     AnyFile and (not (Directory or SysFile)),
                     true,true,false,Nil,'Load from File:','',accept);
          if not accept then fname:=''
          else begin
            i:=0;
            tmp:='';
            CanonicalFname(fname);
            LFNfsplit(fname,@D,@N,@E);
            LFNNew(f,true); LFNAssign(f,fname);
            LFNReset(f,0);
            while (tmp<>'\sort'+lbrace) and (not eof(f)) and
               ((i<MaxLookForSort) or (E='.cfg')) do
            begin
              ReadLine(f,tmp,true); StrRepl(tmp,#9,' ',1,255,255); ChrDel(tmp,' ');
              StrLwr(tmp);
              inc(i);
            end;
            if tmp='\sort'+lbrace then
            begin
              LoadSortMode(f,Nil,EditSortMode,Pattern);
              Change:=true;
            end;
            LFNDispose(f);
          end;
        end;
        change:=true;
      end;
    end else if SaveFile then
    begin
      GetMem(LoadSaveList,6*sizeof(ListArrRec));
      LoadSaveList^[1]:='Default sort mode';
      LoadSaveList^[2]:='Current sort mode';
      LoadSaveList^[3]:='Export  sort mode';
      LoadSaveList^[4]:='Current database ';
      LoadSaveList^[5]:='Other file       ';      
      nspec:=0; Spec[1]:=0;
      FieldChoose(LoadSaveList^,5,1,length(LoadSaveList^[1])+1,Spec,nspec,
                  false,false,1,0,true,true);
      FreeMem(LoadSaveList,6*sizeof(ListArrRec));
      for i:=1 to nspec do
        if Spec[i]=1 then
        begin
          ConfigSortMode^:=EditSortMode;
          PushBufferStack(Pattern^,sizeof(PatRec),SortPattModeDef,SortPattPosDef);
        end else if Spec[i]=2 then
        begin
          CurrentSortMode^:=EditSortMode;
          PushBufferStack(Pattern^,sizeof(PatRec),SortPattModeCur,SortPattPosCur);
        end else if Spec[i]=3 then
        begin
          ExportSortMode^:=EditSortMode;
          PushBufferStack(Pattern^,sizeof(PatRec),SortPattModeExp,SortPattPosExp);
        end else if Spec[i]=4 then
        begin
          CloseFile(bib);
          WaitingMessage('Saving...');
          EntryCache^.Clear;
          SaveSortMode(bibname^,EditSortMode,Pattern);
          WaitingOff;
          movedbib:=true;
          CheckForIndexFile(bib,bibname);
        end else if Spec[i]=5 then
        begin
          fname:='';
          FileChoose(fname,DefExtension[BibTeXFormat]^,TexInputList,
                     AnyFile and (not (Directory or SysFile)),
                     true,false,false,Nil,'Save to File:','',accept);
          if not accept then fname:=''
          else begin
            CanonicalFname(fname);
            ABibFile:=false;
            if Linked then
            begin
              for i:=1 to MaxBibFiles do
                ABibFile:=ABibFile or
                     (StrCmpI(BibFiles^[i].name,fname,1,1,255)=0);
            end else ABibFile:=(StrCmpI(fname,bibname^,1,1,255)=0);
            if ABibFile and Linked then
              ErrorMessageRC(Str_EditInLinkMode,'')
            else if ABibFile and BibReadOnly then
              ErrorMessageRC(Str_ChangeROAttrib,'')
            else begin
              EntryCache^.Clear;
              LFNClose(bib);
              WaitingMessage('Saving...');
              SaveSortMode(fname,EditSortMode,Pattern);
              WaitingOff;
              movedbib:=true;
              if StrCmpI(fname,bibname^,1,1,255)=0 then CheckForIndexFile(bib,bibname);
            end;
          end;      
        end;
    end else if space then
    begin
      if Current=ModeInd then                                   { Sorting on/off }
      begin
        if WhichSort<>CSortMode_Default then SortingOn:=not SortingOn;
      end else if Current=CollationInd then                     { Collation }
        MixedCollation:=not MixedCollation
      else if Current=SortOrderInd then   { Sort criterion }
      begin
        i:=0;
        Spec[1]:=ListNumber;
        FieldChoose(list^,NCombinations,1,length(list^[NCombinations])+1,Spec,i,
                    true,false,1,0,true,true);
        if i>0 then SortTypeOrder:=OStr[Spec[1]];
      end else if current=NameOrderInd then                     { Name Order }
      begin
        if IsPattern then
        begin
          getmem(orders,5*sizeof(ListArrRec));
          MaxMemAvail;
          orders^[1] :='ascending, ascending  ';
          orders^[2] :='ascending, descending ';
          orders^[3] :='descending, ascending ';
          orders^[4] :='descending, descending';
          Spec[1]:=1;
          if not NameAsc[true] then  Spec[1]:=Spec[1]+2;
          if not NameAsc[false] then Spec[1]:=Spec[1]+1;
          i:=0;
          FieldChoose(orders^,4,1,23,Spec,i,true,false,1,0,true,true);
          freemem(orders,5*sizeof(ListArrRec));
          if i>0 then
          begin
            NameAsc[true]:=(Spec[1]<3);
            NameAsc[false]:=(Spec[1]=1) or (Spec[1]=3);
          end;
        end else
        begin
          NameAsc[true]:=not NameAsc[true];
          NameAsc[false]:=NameAsc[true];
        end;
      end else if current in [KeyField1Ind,KeyField2Ind,KeyField3Ind] then
      begin                                                     { Key<n> Fields }
        if current=KeyField1Ind then NKey:=1
        else if current=KeyField2Ind then NKey:=2
        else if current=KeyField3Ind then NKey:=3;

        if Pos(Chr(NKey),SortTypeOrder)>0 then
        begin
          xx:=x-MaxWid-2;
          if (not Event.mpress) or (not DoubleKeys[NKey])
                              or ((xx>0) and (xx<=FirstKeyLen[NKey])) then
          begin
            ChooseSortKey(SortKey[NKey,true],y0+positions[current]+1,
              'Key '+num2str(Nkey)+' true: ');
            if not DoubleKeys[NKey] then
              SortKey[NKey,false]:=SortKey[NKey,true];
          end;
          if DoubleKeys[NKey] and ((not Event.mpress)
              or ((xx>FirstKeyLen[NKey]+2) and (xx<=SecondKeyLen[NKey]))) then
          begin
            ChooseSortKey(SortKey[NKey,false],y0+positions[current]+1,
              'Key '+num2str(Nkey)+' false: ');
          end;
        end;
      end else if current in [KeyOrder1Ind,KeyOrder2Ind,KeyOrder3Ind] then
      begin                                                      { Key<n> order }
        if current=KeyOrder1Ind then NKey:=1
        else if current=KeyOrder2Ind then NKey:=2
        else if current=KeyOrder3Ind then NKey:=3;
        if Pos(Chr(NKey),SortTypeOrder)>0 then
        begin
          if DoubleKeys[Nkey] then
          begin
            getmem(orders,17*sizeof(ListArrRec));
            MaxMemAvail;
            orders^[1] :='ascend,  null first; ascend,  null first';
            orders^[2] :='descend, null first; ascend,  null first';
            orders^[3] :='ascend,  null last;  ascend,  null first';
            orders^[4] :='descend, null last;  ascend,  null first';
            orders^[5] :='ascend,  null first; descend, null first';
            orders^[6] :='descend, null first; descend, null first';
            orders^[7] :='ascend,  null last;  descend, null first';
            orders^[8] :='descend, null last;  descend, null first';
            orders^[9] :='ascend,  null first; ascend,  null last ';
            orders^[10]:='descend, null first; ascend,  null last ';
            orders^[11]:='ascend,  null last;  ascend,  null last ';
            orders^[12]:='descend, null last;  ascend,  null last ';
            orders^[13]:='ascend,  null first; descend, null last ';
            orders^[14]:='descend, null first; descend, null last ';
            orders^[15]:='ascend,  null last;  descend, null last ';
            orders^[16]:='descend, null last;  descend, null last ';
            Spec[1]:=1;
            if not KeyAsc[NKey,true] then Spec[1]:=Spec[1]+1;
            if not NullKeyFirst[NKey,true] then Spec[1]:=Spec[1]+2;
            if not KeyAsc[NKey,false] then Spec[1]:=Spec[1]+4;
            if not NullKeyFirst[NKey,false] then Spec[1]:=Spec[1]+8;
            i:=0;
            FieldChoose(orders^,16,1,41,Spec,i,true,false,1,0,true,true);
            freemem(orders,17*sizeof(ListArrRec));
            if i>0 then
            begin
              Spec[1]:=Spec[1]-1;
              KeyAsc[NKey,true]:=(Spec[1] and 1)=0;
              NullKeyFirst[NKey,true]:=(Spec[1] and 2)=0;
              KeyAsc[NKey,false]:=(Spec[1] and 4)=0;
              NullKeyFirst[NKey,false]:=(Spec[1] and 8)=0;
            end;
          end else
          begin
            getmem(orders,5*sizeof(ListArrRec));
            MaxMemAvail;
            orders^[1] :='ascending,  nulls first';
            orders^[2] :='descending, nulls first';
            orders^[3] :='ascending,  nulls last ';
            orders^[4] :='descending, nulls last ';
            Spec[1]:=1;
            if not KeyAsc[NKey,true] then Spec[1]:=Spec[1]+1;
            if not NullKeyFirst[NKey,true] then Spec[1]:=Spec[1]+2;
            i:=0;
            FieldChoose(orders^,4,1,24,Spec,i,true,false,1,0,true,true);
            freemem(orders,5*sizeof(ListArrRec));
            if i>0 then
            begin
              Spec[1]:=Spec[1]-1;
              KeyAsc[NKey,true]:=(Spec[1] and 1)=0;
              NullKeyFirst[NKey,true]:=(Spec[1] and 2)=0;
              KeyAsc[NKey,false]:=(Spec[1] and 1)=0;
              NullKeyFirst[NKey,false]:=(Spec[1] and 2)=0;
            end;
          end;
        end;
      end else if (current=PatternInd) and IsPattern and
          (Pos('P',SortTypeOrder)>0) then                 { Edit pattern }
      begin
        UsePatternFile:=not AskIf(' Use an explicit pattern or a pattern file ',
                              '','Explicit','File');
        if not UsePatternFile then
        begin
          PushBufferStack(Videobuf^,MaxX*MaxY*2,EnoughMem(MaxX*MaxY*2),0);
          PatternGet(Pattern,pchanged);
          PopBufferStack(Videobuf^);
        end else
        begin
          FileChoose(SortPatternFile,PatternExt,TexInputList,
                     AnyFile and (not (Directory or SysFile)),
                     true,true,false,Nil,'Pattern file:','',accept);
        end;
      end else if (current=PattOrderInd) and (NSortTypeNumber>3)
          and (Pos('P',SortTypeOrder)>0)then
          PattFirst:=not PattFirst
      else if current=StringSortInd then
      begin
        case StringNameSort of
          StrSortOff,StrSortAscend: StringNameSort:=Succ(StringNameSort);
          StrSortDescend: StringNameSort:=StrSortOff;
        end;
      end;
      change:=true;
    end;
    if change then WasModified:=true;
  until Enter or Esc;
  if Enter then
  begin
    SortWorkOut(EditSortMode,Pattern);
    if WhichSort=CSortMode_Default then
    begin
      ConfigSortMode^:=EditSortMode;
      PushBufferStack(Pattern^,sizeof(PatRec),SortPattModeDef,SortPattPosDef);
      if WasModified then OptionsModified.Sort:=true;
    end else if WhichSort=CSortMode_Current then
    begin
      CurrentSortMode^:=EditSortMode;
      PushBufferStack(Pattern^,sizeof(PatRec),SortPattModeCur,SortPattPosCur);
    end else if WhichSort=CSortMode_Export then
    begin
      ExportSortMode^:=EditSortMode;
      PushBufferStack(Pattern^,sizeof(PatRec),SortPattModeExp,SortPattPosExp);
    end;
  end;
  RemoveWindow;
  if UseMouse then WaitForRelease(255);
  FreeMem(list,(NCombinations+1)*sizeof(ListArrRec));
  Dispose(Pattern);
end;                                    { SortOptions }


end.
