{$N-,W-,G+,V-,C MOVEABLE DISCARDABLE}

Unit wbibinit;

Interface

Uses
  WinDos, wobjects, WinTypes, WinProcs, strings, wbibdisp, wbibgui,
  wbibabv1,wbibabv2, wbibtbar, commdlg, wbibole, shellapi,wbibbmp,
  bibstrg, bibinit2, bibvars, bibfile, bib8bit,
  bibutil, rc_strng, rc_id, lfnunit;

var

  { Section names in the .INI file }
  { Moved to bibvars
  GeneralSec,ColorsSec,FontsSec,PositionsSec,HyperlinkSec: PChar;
  NameClickSec,PrintingSec,AbbrevSec,ToolbarSec,ObjectsSec,ImagesSec: PChar;
  HeirarchySec: PChar;
  }

  { WWW Browsers }
  BrowserNameN,    BrowserPathN, DDEServiceN, LoadURLStringN,
  LoadFileStringN, SendsURLReturnN, RegistrationKeyN: PChar;

procedure WinDefaults;
procedure WinParamsConfig(var VersionSpecified: boolean;
                          var ConfigFileVersion: string);
procedure UploadBrowserInfo(H: HWnd; List: PChar);
procedure SaveWinOptions;


Implementation

var
  { General }
  ConfigFileVersionN, VersionN,        SaveWinOptionsN, CoffeeWhileYouWaitN,
  EntryListColWidthN, PatternIndentN,  BibTeXHelpN,     Use3dN,
  Win95_3dN,          BackgroundProcN: PChar;

  { Abbreviations }
  ExpandAbbrevsN, ExpandStringsN, AbbrevsBIBFileN, AbbrevsBSTFileN: PChar;

  { Positions }
  MainWinSizeN,   EditEntrySizeN, EditFieldSizeN,   EntryListSizeN,   OverviewSizeN,
  PattEditSizeN,  PattFieldSizeN, FindFileSizeN,    WhichFieldsSizeN, OneFieldSizeN,
  EdStringsSizeN, EdAbbrevsSizeN, ViewAbbrevsSizeN, BrowseFilesSizeN,
  DispDupsSizeN,  InsertAbbrevSizeN, EdShowFormSizeN: PChar;

  { Printing }
  MarginsN, EntrySeparationN, PrintToFileN, PrintPageHeaderN, DeviceN,
  PrintEntryHeaderN: PChar;

  { ENameClick }
  ControlN, ShiftN, ShiftControlN, MenuStringN: PChar;

  { Colors }
  TagColorN,FilenameColorN,DupEntriesColorN,ENameBackColorN: PChar;

  { Fonts }
  PatternTextN, PatternOpsN, PatternFieldN, FieldEditN,LabelN,
  NormalN, BoldN, PageHeaderN, StatusBarN, HyperN, SFormatFontN: PChar;

  { Toolbar }
  VisibleN, ButtonSizeN, ButtonOrderN : Pchar;

  { Hyperlinks }
  ResolveHyperN, HyperSyntaxN, WWWDownloadDirN, WWWBrowserN, UseMAPIN: PChar;

  { Objects }
  ObjectsOnN, ObjectTeXMacroN, LockOleServersN, CompressObjectsN: PChar;

  { Images }
  ImageTeXMacroN, RenderExternalN, GraphicsFiltersN, HTMLImagesN,
  CompressImagesN,IconizeImagesN : PChar;



procedure LoadParamNames;
var
  F: array[0..255] of char;

procedure LoadOneName(var Param: PChar; id: integer);
begin
  Param:=Nil;
  LoadString(HInstance,id,F,255);
  Param:=StrNew(F);
end;

begin
  { Classes }
  LoadOneName(BibDBMainWinClass,  Class_MainWin);
  LoadOneName(BibDBEdPattClass,   Class_EdPatt);
  LoadOneName(BibDBEdWinClass,    Class_EdWin);
  LoadOneName(BibDBToolbarClass,  Class_Toolbar);
  LoadOneName(BiBDBStatusBoxClass,Class_StatusBox);
  LoadOneName(BibDBHelpBarClass,  Class_HelpBar);
  LoadOneName(BibDBDispArea,      Class_DispArea);
  LoadOneName(BibDBDispAreaDblClk,Class_DispAreaDblClk);
  LoadOneName(BibDBENameCPass,    Class_ENameCPass);
  LoadOneName(BibDBENameNoCPass,  Class_ENameNoPass);
  LoadOneName(BibDBTestObjClass,  Class_TestObj);
  LoadOneName(BibDBEditWindowClass,Class_EditWindow);

  { Section names in the .INI file }
  LoadOneName(GeneralSec,  IniStr_GeneralSec);
  LoadOneName(ColorsSec,   IniStr_ColorsSec);
  LoadOneName(FontsSec,    IniStr_FontsSec);
  LoadOneName(PositionsSec,IniStr_PositionsSec);
  LoadOneName(NameClickSec,IniStr_NameClickSec);
  LoadOneName(PrintingSec, IniStr_PrintingSec);
  LoadOneName(AbbrevSec,   IniStr_AbbrevSec);
  LoadOneName(ToolbarSec,  IniStr_ToolbarSec);
  LoadOneName(HyperlinkSec,IniStr_HyperSec);
  LoadOneName(ObjectsSec,  IniStr_ObjectsSec);
  LoadOneName(ImagesSec,   IniStr_ImagesSec);
  LoadOneName(HeirarchySec,IniStr_HeirarchySec);

  { General }
  LoadOneName(ConfigFileVersionN, IniStr_ConfigFileVersion);
  LoadOneName(VersionN,           IniStr_Version);
  LoadOneName(SaveWinOptionsN,    IniStr_SaveWinOptions);
  LoadOneName(CoffeeWhileYouWaitN,IniStr_CoffeeWhileYouWait);
  LoadOneName(EntryListColWidthN, IniStr_EntryListColWidth);
  LoadOneName(PatternIndentN,     IniStr_PatternIndent);
  LoadOneName(BibTeXHelpN,        IniStr_BibTeXHelp);
  LoadOneName(Use3dN,             IniStr_Dialog3DLook);
  LoadOneName(Win95_3dN,          IniStr_Win95_3DLook);
  LoadOneName(BackgroundProcN,    IniStr_BackgroundProc);

  { Abbreviations }
  LoadOneName(ExpandAbbrevsN, IniStr_ExpandAbbrevs);
  LoadOneName(ExpandStringsN, IniStr_ExpandStrings);
  LoadOneName(AbbrevsBIBFileN,IniStr_AbbrevsBIBFile);
  LoadOneName(AbbrevsBSTFileN,IniStr_AbbrevsBSTFile);

  { Positions }
  LoadOneName(MainWinSizeN,    IniStr_MainWinPos);
  LoadOneName(EditEntrySizeN,  IniStr_EditEntryPos);
  LoadOneName(EditFieldSizeN,  IniStr_EditFieldPos);
  LoadOneName(EntryListSizeN,  IniStr_EntryListPos);
  LoadOneName(OverviewSizeN,   IniStr_OverviewPos);
  LoadOneName(PattEditSizeN,   IniStr_PattEditPos);
  LoadOneName(PattFieldSizeN,  IniStr_PattFieldPos);
  LoadOneName(FindFileSizeN,   IniStr_FindFilePos);
  LoadOneName(WhichFieldsSizeN,IniStr_WhichFieldsPos);
  LoadOneName(OneFieldSizeN,   IniStr_OneFieldPos);
  LoadOneName(EdStringsSizeN,  IniStr_EdStringsPos);
  LoadOneName(EdAbbrevsSizeN,  IniStr_EdAbbrevsPos);
  LoadOneName(ViewAbbrevsSizeN,IniStr_ViewAbbrevsPos);
  LoadOneName(InsertAbbrevSizeN,IniStr_InsertAbbrevPos);
  LoadOneName(BrowseFilesSizeN,IniStr_BrowseFilesPos);
  LoadOneName(DispDupsSizeN,   IniStr_DispDupsPos);
  LoadOneName(EdShowFormSizeN, IniStr_EdShowFormPos);

  { Printing }
  LoadOneName(MarginsN,         IniStr_Margins);
  LoadOneName(EntrySeparationN, IniStr_EntrySeparation);
  LoadOneName(PrintToFileN,     IniStr_PrintToFile);
  LoadOneName(PrintPageHeaderN, IniStr_PrintPageHeader);
  LoadOneName(PrintEntryHeaderN,IniStr_PrintEntryHeader);
  LoadOneName(DeviceN,          IniStr_Device);

  { ENameClick }
  LoadOneName(ControlN,     IniStr_Control);
  LoadOneName(ShiftN,       IniStr_Shift);
  LoadOneName(ShiftControlN,IniStr_ShiftControl);
  LoadOneName(MenuStringN,  IniStr_MenuString);

  { Colors }
  LoadOneName(TagColorN,        IniStr_TagColor);
  LoadOneName(FilenameColorN,   IniStr_FilenameColor);
  LoadOneName(ENameBackColorN,  IniStr_ENameBackColor);
  LoadOneName(DupEntriesColorN, IniStr_DupEntriesColor);

  { Fonts }
  LoadOneName(PatternTextN, IniStr_PatternText);
  LoadOneName(PatternOpsN,  IniStr_PatternOps);
  LoadOneName(PatternFieldN,IniStr_PatternField);
  LoadOneName(FieldEditN,   IniStr_FieldEdit);
  LoadOneName(LabelN,       IniStr_Label);
  LoadOneName(NormalN,      IniStr_Normal);
  LoadOneName(BoldN,        IniStr_Bold);
  LoadOneName(PageHeaderN,  IniStr_PageHeader);
  LoadOneName(StatusBarN,   IniStr_StatusBar);
  LoadOneName(HyperN,       IniStr_HyperlinksFont);
  LoadOneName(SFormatFontN, IniStr_ShowFormatFont);

  { Toolbar }
  LoadOneName(VisibleN,     IniStr_Visible);
  LoadOneName(ButtonSizeN,  IniStr_ButtonSize);
  LoadOneName(ButtonOrderN, IniStr_ButtonOrder);

  { Hyperlinks }
  LoadOneName(ResolveHyperN,   IniStr_ResolveHyper);
  LoadOneName(HyperSyntaxN,    IniStr_HyperSyntax);
  LoadOneName(WWWBrowserN,     IniStr_WWWBrowser);
  LoadOneName(WWWDownloadDirN, IniStr_WWWUploadDir);
  LoadOneName(UseMAPIN,        IniStr_UseMAPI);

  { Objects }
  LoadOneName(ObjectsOnN,      IniStr_ObjectsOn);
  LoadOneName(ObjectTeXMacroN, IniStr_ObjectTeXMacro);
  LoadOneName(LockOleServersN, IniStr_LockOleServers);
  LoadOneName(CompressObjectsN,IniStr_CompressObjects);

  { Images }
  LoadOneName(ImageTeXMacroN,  IniStr_ImageTeXMacro);
  LoadOneName(RenderExternalN, IniStr_RenderExternal);
  LoadOneName(GraphicsFiltersN,IniStr_GraphicsFilters);
  LoadOneName(HTMLImagesN,     IniStr_HTMLImages);
  LoadOneName(CompressImagesN, IniStr_CompressImages);
  LoadOneName(IconizeImagesN,  IniStr_IconizeImages);

  { WWW Browsers }
  LoadOneName(BrowserNameN,    IniStr_BrowserName);
  LoadOneName(BrowserPathN,    IniStr_BrowserPath);
  LoadOneName(DDEServiceN,     IniStr_BrowserDDEService);
  LoadOneName(LoadURLStringN,  IniStr_WWWLoadURL);
  LoadOneName(LoadFileStringN, IniStr_WWWLoadFile);
  LoadOneName(SendsURLReturnN, IniStr_SendsURLReturn);
  LoadOneName(RegistrationKeyN,IniStr_RegistrationKey);

  { Pattern Heirarchies }
  LoadOneName(PattHeirNameN,IniStr_PattHeirName);
end;                            { LoadParamNames }

procedure WinDefaults;
var
  i: integer;
  D,N,E: string;

procedure FillFontInfo(PointSize: integer; var T: TLogFont);
begin
  with T do
  begin
    lfHeight:=-MulDiv(PointSize,ScreenResY,720);
    lfWidth:=0; LfEscapement:=0; lfOrientation:=0;  { Size }
    lfWeight:=fw_Normal;
    lfItalic:=fw_DontCare;
    lfUnderline:=fw_DontCare;
    lfStrikeout:=fw_DontCare;
    lfCharSet:=ANSI_CharSet;
    lfOutPrecision:=Out_Default_Precis;
    lfClipPrecision:=Clip_Default_Precis;
    lfQuality:=Default_Quality;
    lfPitchAndFamily:=Fixed_Pitch+ff_Modern;
    StrCopy(@lfFaceName,'Courier');
  end;
end;                { FillFontInfo }

begin
                                       { Ini file }
  GetMem(IniFile,257); IniFile[0]:=#0;
  GetMem(PattHeirFile,257); PattHeirFile[0]:=#0;
  LoadParamNames;
                                       { Window positions and sizes }
  With MainWinSize do
  begin X:=10; Y:=10; W:=600; H:=450; end;
  With EdEnSize do
  begin X:=10; Y:=10; W:=600; H:=450; end;
  with EdFieldSize      do begin X:=0; Y:=0; W:=0; H:=0; end;
  with EntryListSize    do begin X:=0; Y:=0; W:=0; H:=0; end;
  with OverviewSize     do begin X:=0; Y:=0; W:=0; H:=0; end;
  with PattEditSize     do begin X:=0; Y:=0; W:=0; H:=0; end;
  with PattFieldSize    do begin X:=0; Y:=0; W:=0; H:=0; end;
  with FindFileSize     do begin X:=0; Y:=0; W:=0; H:=0; end;
  with WhichFieldsSize  do begin X:=0; Y:=0; W:=0; H:=0; end;
  with OneFieldSize     do begin X:=0; Y:=0; W:=0; H:=0; end;
  with EdStringsSize    do begin X:=0; Y:=0; W:=0; H:=0; end;
  with EdAbbrevsSize    do begin X:=0; Y:=0; W:=0; H:=0; end;
  with ViewAbbrevsSize  do begin X:=0; Y:=0; W:=0; H:=0; end;
  with InsertAbbrevSize do begin X:=0; Y:=0; W:=0; H:=0; end;
  with BrowseFilesSize  do begin X:=0; Y:=0; W:=0; H:=0; end;
  with DispDupsSize     do begin X:=0; Y:=0; W:=0; H:=0; end;
  with EdShowFormSize   do begin X:=0; Y:=0; W:=0; H:=0; end;
                                       { Fonts }
  New(Fonts);
  for i:=FirstFontIndex to LastFontIndex do
    with Fonts^[i] do
    begin
      PointSize:=10;
      FillFontInfo(PointSize,LogFont);
      Font:=0;
      Color:=RGB(0,0,0);
      Height:=0;
      Initialized:=false; Default:=true;
    end;
    
  with Fonts^[StatusBarFont] do
  begin
    FillChar(LogFont,sizeof(LogFont),0);
    PointSize:=8;
    with LogFont do
    begin
      lfHeight        := -MulDiv(PointSize*10,ScreenResY,720);
      lfWidth         := 0;
      lfWeight        := fw_Bold;
      lfEscapement    := 0;
      lfCharSet       := Ansi_CharSet;
      lfOutPrecision  := Out_Default_Precis;
      lfClipPrecision := Clip_Default_Precis;
      lfQuality       := Default_Quality;
      lfPitchAndFamily:= Variable_Pitch or ff_Swiss;
      StrLCopy(@lfFaceName,'MS Sans Serif',lf_FaceSize-1);
    end;
  end;
  
  HMainW:=0;

  TagColor       :=RGB(0,0,0);
  FilenameColor  :=RGB(0,0,255);
  DupEntriesColor:=RGB(255,0,0);

  ENameBackColor:=GetSysColor(Color_Menu);
  ENameBackBrush:=0;

  EListColWidthStr^:='abcd';

  LFNFSplit(LFNLongName(LFNFExpand(ParamStr(0))),@D,@N,@E);
  GetMem(HelpFile,length(D)+length(N)+5);
  StrPCopy(HelpFile,D+N+'.HLP');
  SaveWinOptsOnExit:=true;
  UseCoffeeCup:=true;
  UseToolbar:=true;
  DispEncoding:=-1; FReadEncoding:=-1; FWriteEncoding:=-1;
  NameClickCtrl.S     :=Nil; NameClickCtrl.action     :=ENameClick_Copy;
  NameClickShift.S    :=Nil; NameClickShift.action    :=ENameClick_Copy;
  NameClickCtrlShift.S:=Nil; NameClickCtrlShift.action:=ENameClick_CopyEx;
  NameClickMenuString :=NewStr('#1');
  TopMargin:=0; BottomMargin:=0; LeftMargin:=0; RightMargin:=0;
  PrintToFile:=false;
  EntrySeparation:=10;
  PrintEntryHeader:=true; PrintPageHeader:=true;
  for i:=0 to MaxField+1 do PrintingFields^[i]:=true;
  PrintUndecFields:=true;
  ExpandIniAbbrevs:=false; ExpandStrings:=false; ExpandMacros:=false;
  LargeTBarBtns:=TBtnSize_Auto;
  HPDevMode:=0; HPDevNames:=0;

  UseCtl3d:=true; Win95_3d:=false;
  WinYieldStep:=1;

  { Hyperlinks }
  for i:=1 to Hyper_User-1 do HyperTypesArr^[i].Htype:=i;
  with HyperTypesArr^[Hyper_cite] do
  begin
    pre:=NewStr('cite'); TeXMacro:=NewStr('\Cite'); Flags:=HClass_on;
  end;
  with HyperTypesArr^[Hyper_run ] do
  begin
    pre:=NewStr('run'); TeXMacro:=NewStr('\Run');
    Flags:=HClass_on or Hrun_Verify;
  end;
  with HyperTypesArr^[Hyper_DDE ] do
  begin
    pre:=NewStr('dde'); TeXMacro:=NewStr('\DDE'); Flags:=HClass_on;
  end;
  with HyperTypesArr^[Hyper_Help] do
  begin
    pre:=NewStr('help'); TeXMacro:=NewStr('\Help'); Flags:=HClass_on;
  end;
  with HyperTypesArr^[Hyper_Href] do
  begin
    pre:=NewStr('href'); TeXMacro:=NewStr('\Href'); Flags:=HClass_on;
  end;
  with HyperTypesArr^[Hyper_FTP] do
  begin
    pre:=NewStr('ftp'); TeXMacro:=NewStr('\Ftp'); Flags:=HClass_on;
  end;
  with HyperTypesArr^[Hyper_Mail] do
  begin
    pre:=NewStr('mail'); TeXMacro:=NewStr('\Mail'); Flags:=HClass_on;
  end;
  NHyperTypes:=Hyper_User-1;
  MaxHyperTypeLen:=5;
  with HyperlinkFlags do
  begin
    on:=true; LaTeX:=true; HTML:=true;
  end;

  { WWW }
  WWWBrowserList:=Nil;
  with WWWBrowser do
  begin
    Active:=false; SendsURLReturn:=false;
    Path:=Nil; Name:=Nil;
    DDEService:=Nil; LoadURLString:=Nil; LoadFileString:=Nil;
  end;
  WWWUploadDir:=Nil;
  { EMail }
  UseMAPI:=true;

  { Objects }
  ObjectTeXMacro :=Nil;
  ResolveObjects :=true;
  LockOleServers :=false;
  CompressObjects:=false;

  { Images }
  ImageTeXMacro     :=Nil;
  UseGraphicsFilters:=true;
  HTMLImages        :=Nil;
  CompressImages    :=false;
end;                          { WinDefaults }

procedure WinParamsConfig(var VersionSpecified: boolean;
                          var ConfigFileVersion: string);
var
  Ind2: byte;
  Nfound,i,j,k,icode: integer;
  F: array[0..1024] of char;
  F1: array[0..255] of char;
  S,tmp: string;
  Numbers: array[1..20] of LongInt;
  D: string;
  N: string;
  E: string;
  PrinterFont,btmp,o_k: boolean;
  PF,PF2: PChar;
  DevNames: PDevNames;
  ch: Char;

function GetNumbers(var S: string; var Ind2: byte; N: integer): integer;
var
  i,Nfound,icode: integer;
begin
  for i:=1 to 20 do Numbers[i]:=0; Nfound:=0;
  if (S<>'') and (Ind2>0) and (N>0) then
  repeat
    tmp:=''; icode:=1; WrdToken(tmp,S,' ,',Ind2);
    if S<>'' then
    begin
      Val(tmp,Numbers[Nfound+1],icode);
      if icode=0 then inc(Nfound);
    end;
  until (icode<>0) or (Nfound>=N);
  GetNumbers:=NFound;
end;                           { GetNumbers }

procedure ParseFontData(F: PChar; var FontRec: FontTypesType);
var
  i: integer;
begin
  with FontRec do
  begin 
    S:=StrPas(F);
    Ind2:=1;
    tmp:=''; WrdToken(tmp,S,'"',Ind2);
    if tmp<>''then StrPCopy(@LogFont.lfFaceName,tmp)
    else FatalErrorRC(Str_ErrorInFonts,'');
    if GetNumbers(S,Ind2,14)=14 then
    begin
      with LogFont do
      begin
        if Numbers[1]>0 then
        begin
          PointSize:=Numbers[1];
          lfHeight:=-MulDiv(PointSize,ScreenResY,720);
        end else
        begin
          lfHeight:=Numbers[1];
          PointSize:=-MulDiv(lfHeight,720,ScreenResY);
        end;
        lfWidth:=Numbers[2];        lfWeight:=Numbers[3];
        lfItalic:=Numbers[4];       lfUnderline:=Numbers[5];
        lfStrikeout:=Numbers[6];    lfCharSet:=Numbers[7];
        lfOutPrecision:=Numbers[8]; lfClipPrecision:=Numbers[9];
        lfQuality:=Numbers[10];     lfPitchAndFamily:=Numbers[11];
      end;
      Color:=RGB(Numbers[12],Numbers[13],Numbers[14]);
      Height:=0; Initialized:=false;
    end else FatalErrorRC(Str_ErrorInFonts,'');
  end;
end;                        { ParseFontData }

procedure GetSizeInfo(name: PChar; var SizeRec: InitialSizeRec);
begin
  i:=GetPrivateProfileString(PositionsSec,Name,'def',F,63,IniFile);
  if (i>0) and (StrComp(F,'def')<>0) then
  begin
    S:=StrPas(F);
    Ind2:=1;
    if GetNumbers(S,Ind2,4)=4 then
    with SizeRec do
    begin
      X:=Numbers[1]; Y:=Numbers[2]; W:=Numbers[3]; H:=Numbers[4];
    end
    else FatalErrorRC(Str_ErrorInPos,'');
  end;
end;                             { GetSizeInfo }

procedure GetEnameClick(name: PChar; var rec: EnameClickRec);
begin
  i:=GetPrivateProfileString(NameClickSec,Name,'',F,255,IniFile);
  if StrLen(F)>0 then
  begin
    S:=StrPas(F); StrLwr(S);
    if S='copy' then rec.action:=ENameClick_Copy
    else if S='copyselection' then rec.action:=ENameClick_CopyEx
    else begin
      rec.action:=ENameClick_String;
      rec.S:=NewStr(StrPas(F));
    end;
  end;
end;                       { GetEnameClick }

procedure LoadBoolean(Sec,name: PChar; var b: boolean);
var
  i: integer;
  F: array[0..6] of char;
begin
  i:=GetPrivateProfileString(Sec,name,'',F,6,IniFile);
  if (i>0) then b:=IsOn(StrPas(F));
end;

procedure LoadColor(Name: PChar; var Color: TColorRef);
begin
  if GetPrivateProfileString(ColorsSec,Name,'',F,63,IniFile)>0 then
  begin
    S:=StrPas(F);
    Ind2:=1;
    if GetNumbers(S,Ind2,3)=3 then
       Color:=RGB(Numbers[1],Numbers[2],Numbers[3])
    else FatalErrorRC(Str_ErrInColor,'');
  end;
end;                 { LoadColor }

begin                   { WinParamsConfig }
  { Version }
  i:=GetPrivateProfileString(GeneralSec,VersionN,'',F,63,IniFile);
  S:=StrPas(F); StrLwr(S);
  if S<>'' then
  begin
    if S<>ProgramVersion then OptionsModified.WindowsParams:=true;
    VersionSpecified:=true;
  end;

  { Config file version }
  i:=GetPrivateProfileString(GeneralSec,ConfigFileVersionN,'',F,63,IniFile);
  ConfigFileVersion:=StrPas(F); StrLwr(ConfigFileVersion);

  { General }
  LoadBoolean(GeneralSec,SaveWinOptionsN,    SaveWinOptsOnExit);
  LoadBoolean(GeneralSec,CoffeeWhileYouWaitN,UseCoffeeCup);
  LoadBoolean(GeneralSec,Use3dN,             UseCtl3d);
  LoadBoolean(GeneralSec,Win95_3dN,          Win95_3d);

  if GetPrivateProfileString(GeneralSec,EntryListColWidthN,'',F,63,IniFile)>0 then
    EListColWidthStr^:=StrPas(F);

  PattIndLen:=GetPrivateProfileInt(GeneralSec,PatternIndentN,16,IniFile);

  GetPrivateProfileString(GeneralSec,BackgroundProcN,'on',F,6,IniFile);
  if IsOff(StrPas(F)) then WinYieldStep:=0
  else if IsOn(StrPas(F)) then WinYieldStep:=1
  else begin
    Val(StrPas(F),i,j);
    if (j=0) then WinYieldStep:=i;
    if WinYieldStep<0 then WinYieldStep:=0;
  end;

  { BibTeX Help }
  BibTeXHelpMode:=0;
  i:=GetPrivateProfileString(GeneralSec,BibTeXHelpN,'yes',F,256,IniFile);
  S:='';
  if (i>0) then
  begin
    S:=StrPas(F);
    if IsOff(S) then S:=''
    else begin
      if IsOn(S) then
      begin
        S:=ProgramDir^+BibTeXHelpName+'.HLP'; BibTeXHelpMode:=1;
      end else
      begin
        LFNFSplit(LFNFExpand(StrPas(F)),@D,@N,@E);
        if D='' then D:=ProgramDir^;
        if E='' then E:='.HLP';
        S:=D+N+E;
        BibTeXHelpMode:=2;
      end;
    end;
  end;
  if (S<>'') and LFNFileExist(S) then
  begin
    StrPCopy(F,S);
    BibTeXHelpFile:=StrNew(F);
  end else BibTeXHelpMode:=0;

  { Startup Positions }
  GetSizeInfo(MainWinSizeN,     MainWinSize);
  GetSizeInfo(EditEntrySizeN,   EdEnSize);
  GetSizeInfo(EditFieldSizeN,   EdFieldSize);
  GetSizeInfo(EntryListSizeN,   EntryListSize);
  GetSizeInfo(OverviewSizeN,    OverviewSize);
  GetSizeInfo(PattEditSizeN,    PattEditSize);
  GetSizeInfo(PattFieldSizeN,   PattFieldSize);
  GetSizeInfo(FindFileSizeN,    FindFileSize);
  GetSizeInfo(WhichFieldsSizeN, WhichFieldsSize);
  GetSizeInfo(OneFieldSizeN,    OneFieldSize);
  GetSizeInfo(EdStringsSizeN,   EdStringsSize);
  GetSizeInfo(EdAbbrevsSizeN,   EdAbbrevsSize);
  GetSizeInfo(InsertAbbrevSizeN,InsertAbbrevSize);
  GetSizeInfo(ViewAbbrevsSizeN, ViewAbbrevsSize);
  GetSizeInfo(BrowseFilesSizeN, BrowseFilesSize);
  GetSizeInfo(DispDupsSizeN,    DispDupsSize);
  GetSizeInfo(EdShowFormSizeN,  EdShowFormSize);

                          { Fonts }
  for j:=FirstFontIndex to LastFontIndex do
  begin
    PrinterFont:=(j>=PrintLabelFont) and (j<PrintNormalFont+17);
    if PrinterFont then k:=j-PrintNormalFont+NormalFont
    else k:=j;
    if      k=PattTextFont   then StrCopy(F1,PatternTextN)
    else if k=PattOpFont     then StrCopy(F1,PatternOpsN)
    else if k=PattFieldFont  then StrCopy(F1,PatternFieldN)
    else if k=FieldEditFont  then StrCopy(F1,FieldEditN)
    else if k=StatusBarFont  then StrCopy(F1,StatusBarN)
    else if k=LabelFont      then StrCopy(F1,LabelN)
    else if k=NormalFont     then StrCopy(F1,NormalN)
    else if k=BoldFont       then StrCopy(F1,BoldN)
    else if k=HyperFont      then StrCopy(F1,HyperN)
    else if k=ShowFormatFont then StrCopy(F1,SFormatFontN)
    else if k=PageHeaderFont then
    begin
      StrCopy(F1,PageHeaderN); PrinterFont:=true;
    end else if k<=10       then StrPCopy(F1,'Font'+num2str(k))
    else                         StrPCopy(F1,'Font'+Chr(Ord('A')-10+k));
    if PrinterFont then
      i:=GetPrivateProfileString(PrintingSec,F1,'',F,127,IniFile)
    else
      i:=GetPrivateProfileString(FontsSec,F1,'',F,127,IniFile);
    if (i>0) then
    begin
      ParseFontData(F,Fonts^[j]);
      Fonts^[j].Default:=false;
    end;
  end;

  { Colors }
  LoadColor(TagColorN,TagColor);
  LoadColor(FilenameColorN,FilenameColor);
  LoadColor(ENameBackColorN,ENameBackColor);
  LoadColor(DupEntriesColorN,DupEntriesColor);

  { Clicking on the entry name }
  GetENameClick(ControlN,NameClickCtrl);
  GetENameClick(ShiftN,NameClickShift);
  GetENameClick(ShiftControlN,NameClickCtrlShift);
  i:=GetPrivateProfileString(NameClickSec,MenuStringN,'',F,255,IniFile);
  if StrLen(F)>0 then
  begin
    DisposeStr(NameClickMenuString);
    NameClickMenuString:=NewStr(StrPas(F));
  end;

  { Printing }
  i:=GetPrivateProfileString(PrintingSec,DeviceN,'0',F,255,IniFile);
  if (i>0) and (StrComp(F,'0')<>0) then
  begin
    S:=StrPas(F);
    if ChrQty(S,',')=2 then
    begin
      UnTabify(S); ChrDelL(S,' '); ChrDelR(S,' ');
      HPDevNames:=GlobalAlloc(GHND,sizeof(TDevNames)+length(S)+10);
      DevNames:=GlobalLock(HPDevNames);
      DevNames^.wDriverOffset:=Sizeof(TDevNames);
      PF:=PChar(DevNames)+DevNames^.wDriverOffset;
      i:=Pos(',',S);
      StrPCopy(PF,Copy(S,1,i-1)); Delete(S,1,i);
      DevNames^.wDeviceOffset:=DevNames^.wDriverOffset+i;
      PF:=PChar(DevNames)+DevNames^.wDeviceOffset;
      i:=Pos(',',S); tmp:=Copy(S,1,i-1);
      StrPCopy(PF,tmp); Delete(S,1,i);
      DevNames^.wOutputOffset:=DevNames^.wDeviceOffset+i;
      PF:=PChar(DevNames)+DevNames^.wOutputOffset;
      StrPCopy(PF,S);
      GlobalUnlock(HPDevNames);
      { Check validity }
      GetMem(PF,$7FF0);
      GetProfileString('devices',Nil,'',PF,$7FF0);
      PF2:=PF;
      btmp:=false;
      while (not btmp) and (StrLen(PF2)>0) do
      begin
        if StrCmpI(tmp,StrPas(PF2),1,1,255)=0 then btmp:=true;
        PF2:=PF2+StrLen(PF2)+1;
      end;
      if not btmp then
      begin
        ErrorMessageRC(Str_InvalidPrinter,tmp);
        OptionsModified.WindowsParams:=true;
        GlobalFree(HPDevNames); HPDevNames:=0;
      end;
      FreeMem(PF,$7FF0);
    end;
  end;

  i:=GetPrivateProfileString(PrintingSec,MarginsN,'',F,255,IniFile);
  if (i>0) then
  begin
    S:=StrPas(F); ChrDel(S,' ');
    i:=Pos(',',S);
    if i>0 then
    begin
      Val(Copy(S,1,i-1),LeftMargin,i); Delete(S,1,i);
    end;
    i:=Pos(',',S);
    if i>0 then
    begin
      Val(Copy(S,1,i-1),RightMargin,i); Delete(S,1,i);
    end;
    i:=Pos(',',S);
    if i>0 then
    begin
      Val(Copy(S,1,i-1),TopMargin,i); Delete(S,1,i);
    end;
    i:=Pos(',',S);
    if i>0 then
    begin
      Val(Copy(S,1,i-1),BottomMargin,i); Delete(S,1,i);
    end;
  end;
  i:=GetPrivateProfileString(PrintingSec,EntrySeparationN,'',F,10,IniFile);
  if i>0 then
  begin
    Val(StrPas(F),EntrySeparation,i);
    if i<>0 then EntrySeparation:=10;
    if EntrySeparation<0 then EntrySeparation:=-1;
  end;
  LoadBoolean(PrintingSec,PrintToFileN,PrintToFile);
  LoadBoolean(PrintingSec,PrintPageHeaderN,PrintPageHeader);
  LoadBoolean(PrintingSec,PrintEntryHeaderN,PrintEntryHeader);

  { Abbreviations }
  LoadBoolean(GeneralSec,ExpandAbbrevsN,ExpandIniAbbrevs);
  LoadBoolean(GeneralSec,ExpandStringsN,ExpandStrings);
  ExpandMacros:=ExpandStrings or ExpandIniAbbrevs;

  i:=GetPrivateProfileString(GeneralSec,AbbrevsBIBFileN,'',F,255,IniFile);
  if i>0 then BIBAbbrevsFile^:=StrPas(F);
  i:=GetPrivateProfileString(GeneralSec,AbbrevsBSTFileN,'',F,255,IniFile);
  if i>0 then BSTAbbrevsFile^:=StrPas(F);

  { Toolbar }
  LoadBoolean(ToolbarSec,VisibleN,UseToolbar);
  i:=GetPrivateProfileString(ToolbarSec,ButtonSizeN,'',F,10,IniFile);
  if i>0 then
  begin
    tmp:=StrPas(F); StrLwr(tmp); ChrDel(tmp,' ');
    if tmp='large' then LargeTBarBtns:=TBtnSize_Large
    else if tmp='small' then LargeTBarBtns:=TBtnSize_Small
    else LargeTBarBtns:=TBtnSize_Auto;
  end;
  Btmp:=false;
  if GetPrivateProfileString(ToolbarSec,ButtonOrderN,'',F,255,IniFile)>10 then
  begin
    S:=StrPas(F); 
    i:=1; Ind2:=1;
    while (Ind2>0) and (i<=TBar_LastBtn) do
    begin
      WrdToken(tmp,S,' ,',Ind2); if tmp='' then tmp:='0';
      Val(tmp,j,icode); if icode<>0 then j:=0;
      ToolBtns[i].Order:=j;
      if j<>0 then Btmp:=true;
      inc(i);
    end;
  end;
  UseToolbar:=UseToolbar and Btmp;

  { Objects }
  LoadBoolean(ObjectsSec,ObjectsOnN,ResolveObjects);
  GetPrivateProfileString(ObjectsSec,ObjectTeXMacroN,'\Object',F,254,IniFile);
  if F[0]<>'\' then StrPCopy(F,'\'+StrPas(F));
  ObjectTeXMacro:=NewStr(StrPas(F));
  LoadBoolean(ObjectsSec,LockOleServersN,LockOleServers);
  LoadBoolean(ObjectsSec,CompressObjectsN,CompressObjects);

  { Graphics }
  GetPrivateProfileString(ImagesSec,ImageTeXMacroN,'\Image',F,254,IniFile);
  if F[0]<>'\' then StrPCopy(F,'\'+StrPas(F));
  ImageTeXMacro:=NewStr(StrPas(F));

  LoadBoolean(ImagesSec,GraphicsFiltersN,UseGraphicsFilters);
  LoadBoolean(ImagesSec,CompressImagesN, CompressImages);
  LoadBoolean(ImagesSec,IconizeImagesN,  IconizeImages);

  GetPrivateProfileString(ImagesSec,RenderExternalN,'',F,255,IniFile);
  StrLower(F); tmp:=StrPas(F);
  ChrDel(tmp,'.'); ChrDel(tmp,'*'); ChrDel(tmp,' ');
  StrRepl(tmp,',',';',1,255,255);
  StrPCopy(F,tmp); if tmp[length(tmp)]<>';' then StrCat(F,';');
  PF:=@F;
  while (PF<>Nil) and (PF^<>#0) do
  begin
    PF2:=StrScan(PF,';'); if PF2<>Nil then PF2^:=#0;
    for i:=1 to GrExt_Last do
    with IntGraphList[i] do
      if (Ext<>Nil) and (Ext+2=PF) then on:=false;
    if PF2=Nil then PF:=Nil else PF:=PF2+1;
  end;
  for i:=1 to GrExt_Last do
  with IntGraphList[i] do
  begin
    LoadString(HInstance,DescID,F,255); Desc:=StrNew(F);
  end;

  if GetPrivateProfileString(ImagesSec,HTMLImagesN,'',F,1000,IniFile)>2 then
  begin
    StrLower(F); PF:=@F; tmp:='';
    while (PF^ in [';',',',' ','.',#9]) do inc(PF);
    while PF^<>#0 do
    begin
      PF2:=PF;
      while not (PF2^ in [#0,';',',',' ','.',#9]) do inc(PF2);
      ch:=PF2^; PF2^:=#0;
      tmp:=tmp+'.'+StrPas(PF)+';';
      PF2^:=ch;
      PF:=PF2; while (PF^ in [';',',',' ','.',#9]) do inc(PF);
    end;
    if tmp<>'' then HTMLImages:=NewStr(tmp);
  end;

  { Hyperlinks }
  LoadBoolean(HyperlinkSec,ResolveHyperN,HyperlinkFlags.on);
  if GetPrivateProfileString(HyperlinkSec,WWWBrowserN,'',F,255,IniFile)>1 then
  begin
    WWWBrowserList:=StrNew(F);
    UploadBrowserInfo(0,WWWBrowserList);
  end;
  if GetPrivateProfileString(HyperlinkSec,WWWDownloadDirN,'',F,254,IniFile)>0 then
    WWWUploadDir:=StrNew(F);
  LoadBoolean(HyperlinkSec,UseMAPIN,UseMAPI);

  GetPrivateProfileString(HyperlinkSec,HyperSyntaxN,'1',F,40,IniFile);
  tmp:=StrPas(F); StrLwr(tmp);
  with HyperlinkFlags do
  begin
    LaTeX:=Pos('latex',tmp)>0;
    HTML:=Pos('html',tmp)>0;
    if not (LaTeX or HTML) then
    begin
      LaTeX:=true; HTML:=true;
    end;
  end;
  GetMem(PF,32*K1);
  GetPrivateProfileString(HyperlinkSec,Nil,'',PF,32*K1-2,IniFile);
  PF2:=PF;
  while StrLen(PF2)>0 do
  begin
    if (StrIComp(PF2,ResolveHyperN)  <>0) and
       (StrIComp(PF2,HyperSyntaxN)   <>0) and
       (StrIComp(PF2,WWWDownloadDirN)<>0) and
       (StrIComp(PF2,UseMAPIN)       <>0) and
       (StrIComp(PF2,WWWBrowserN)    <>0) then
    begin
      o_k:=true;
      { Define new class or detect old one }
      S:=StrPas(PF2); StrLwr(S); ChrDel(S,' '); k:=0;
      for j:=1 to NHyperTypes do if S=HyperTypesArr^[j].pre^ then k:=j;
      if (k=0) and (NHyperTypes<MaxHyperTypes) then
      begin
        inc(NHyperTypes); k:=NHyperTypes;
        HyperTypesArr^[k].pre:=NewStr(S);
      end;
      { read }
      GetPrivateProfileString(HyperlinkSec,PF2,'',F,1000,IniFile);
      { Flags }
      i:=0; tmp:='';
      while (F[i]<>#0) and (F[i]<>',') do
      begin
        tmp:=tmp+F[i]; inc(i);
      end;
      if (tmp='') or (F[i]=#0) or (F[i+1]=#0) then o_k:=false
      else begin
        Val(tmp,HyperTypesArr^[k].flags,icode); if icode<>0 then o_k:=false;
      end;
      { Macro name }
      if o_k then
      begin
        inc(i); tmp:='';
        while (F[i]<>#0) and (F[i]<>',') do
        begin
          tmp:=tmp+F[i]; inc(i);
        end;
        if (tmp='') or ((k>=Hyper_User) and ((F[i]=#0) or (F[i+1]=#0))) then o_k:=false
        else begin
          if tmp[1]<>'\' then tmp:='\'+tmp;
          if HyperTypesArr^[k].TeXMacro<>Nil then DisposeStr(HyperTypesArr^[k].TeXMacro);
          HyperTypesArr^[k].TeXMacro:=NewStr(tmp);
        end;
      end;
      { User-defined }
      if o_k and (k>=Hyper_User) then
      begin
        inc(i); tmp:='';
        while (F[i]<>#0) and (F[i]<>',') do
        begin
          tmp:=tmp+F[i]; inc(i);
        end;
        StrLwr(tmp); ChrDel(tmp,' ');
        HyperTypesArr^[k].Htype:=Hyper_run;
        for j:=1 to Hyper_User-1 do
          if tmp=HyperTypesArr^[j].pre^ then HyperTypesArr^[k].Htype:=j;
        inc(i); tmp:='';
        while (F[i]<>#0) {and (F[i]<>',')} do
        begin
          tmp:=tmp+F[i]; inc(i);
        end;
        if (tmp='') then o_k:=false
        else begin
          if HyperTypesArr^[k].app<>Nil then DisposeStr(HyperTypesArr^[k].app);
          HyperTypesArr^[k].app:=NewStr(tmp);
        end;
      end;
    end;
    PF2:=PF2+StrLen(PF2)+1;
  end;
  for i:=1 to NHyperTypes do
    if length(HyperTypesArr^[i].pre^)>MaxHyperTypeLen then
      MaxHyperTypeLen:=length(HyperTypesArr^[i].pre^);

  FreeMem(PF,32*K1);
end;                  { WinParamsConfig }

procedure UploadBrowserInfo(H: HWnd; List: PChar);
var
  F,F1,PF,PF2: PChar;
  S,tmp: PString;
  Filters: string[40];
  T: TOpenFileName;
  i: longint;
  AppInd,ProtInd,OleInd: HKey;
  Ind: byte;
  UsedRegKey: boolean;
begin
  with WWWBrowser do
  begin
    StrDispose(Name);           Name:=Nil;
    StrDispose(Path);           Path:=Nil;
    StrDispose(DDEService);     DDEService:=Nil;
    StrDispose(RegKey);         RegKey:=Nil;
    DisposeStr(LoadURLString);  LoadURLString:=Nil;
    DisposeStr(LoadFileString); LoadFileString:=Nil;
    Active:=false;              SendsURLReturn:=false;
    if (List=Nil) or (StrLen(List)=0) then Exit;

    GetMem(F,256); GetMem(F1,256);
    {
    i:=0;
    Res:=RegEnumKey(hKey_Classes_Root,i,F,255);
    while (Res=Error_Success) do
    begin
      messagebox(0,F,'',mb_ok);
      inc(i); Res:=RegEnumKey(hKey_Classes_Root,i,F,255);
    end;
    }
    F[0]:=#0; StrLCat(F,List,255);
    PF:=StrScan(F,'*'); if PF<>Nil then inc(PF) else PF:=F;
    PF2:=StrScan(PF,','); if PF2<>Nil then PF2^:=#0; PF2:=Nil;
    if StrPos(PF,'<def')<>Nil then { Read from registry association to .HTM }
    begin
      F[0]:=#0; PF:=F; i:=255;
      if RegQueryValue(hKey_Classes_Root,'.htm',F1,i)=Error_Success then
      begin
        New(S); New(tmp); S^:=StrPas(List);
        Ind:=1;
        Repeat      { Look for appropriate section via the RegistrationKey }
          WrdToken(tmp^,S^,', *',Ind); tmp^[length(tmp^)+1]:=#0;
          if (tmp^<>'') and (tmp^[1]<>'<') then
          begin
            if (GetPrivateProfileString(PChar(@tmp^[1]),
                  RegistrationKeyN,'',F,255,IniFile)<=1) or
             (StrIComp(F,F1)<>0) then F[0]:=#0
             else StrPCopy(F,tmp^);
          end;
        until (Ind=0) or (F[0]<>#0);
      end;
    end;
    if GetPrivateProfileString(PF,BrowserNameN,'',F1,255,IniFile)>1 then
    begin
      { Read it in }
      Name:=StrNew(F1);
      if GetPrivateProfileString(PF,RegistrationKeyN,'',F1,255,IniFile)>0
        then RegKey:=StrNew(F1);
      if GetPrivateProfileString(PF,BrowserPathN,'',F1,255,IniFile)>0
        then Path:=StrNew(F1);
      if GetPrivateProfileString(PF,DDEServiceN,'',F1,255,IniFile)>0
        then DDEService:=StrNew(F1);
      if GetPrivateProfileString(PF,LoadURLStringN,'',F1,255,IniFile)>0 then
      begin
        PF2:=F1; if PF2[0]='\' then PF2:=PF2+1;
        LoadURLString:=NewStr(StrPas(PF2));
      end;
      if GetPrivateProfileString(PF,LoadFileStringN,'',F1,255,IniFile)>0 then
      begin
        PF2:=F1; if PF2[0]='\' then PF2:=PF2+1;
        LoadFileString:=NewStr(StrPas(PF2));
      end;
      if GetPrivateProfileString(PF,SendsURLReturnN,'0',F1,6,IniFile)>0 then
                SendsURLReturn:=IsOn(StrPas(F1));

      { Process }
      Active:=false; UsedRegKey:=false;

      { Try the registry to look for OLE server path }
      if (RegKey<>Nil) and FindOleExe('.htm',Nil,F1,255) then
      begin
        if Path<>Nil then StrDispose(Path);
        Path:=StrNew(F1);
        UsedRegKey:=true;
      end;
      if not UsedRegKey then   { Can't use the registry }
      begin
        if (Path<>Nil) then { Is it correct? }
        begin
          if not LFNFileExist(StrPas(Path)) then { Supplied path is incorrect }
          begin
            StrDispose(Path); Path:=Nil;
          end;
        end;
        if Path=Nil then   { Prompt the user }
        begin
          FillChar(T,SizeOf(T),0);
          Filters:='Program files'#0'*.exe'#0+AnyFileFilter;
          F1[0]:=#0;
          StrPCopy(F,'Location of '+StrPas(Name));
          with T do
          begin
            lStructSize:=SizeOf(T);
            hWndOwner:=H;
            lpstrFilter:=@Filters[1]; nFilterIndex:=1;
            lpstrFile:=F1;
            nMaxFile:=255;
            lpstrTitle:=F;
            flags:=Ofn_FileMustExist or ofn_NoChangeDir or ofn_HideReadOnly;
            if LFNAble then flags:=flags or ofn_LongNames;
          end;
          if GetOpenFileName(T) then
          begin
            Path:=StrNew(F1);
            WritePrivateProfileString(PF,BrowserPathN,F1,IniFile);
          end;
        end;
      end;
      if Path<>Nil then Active:=true; 
      if not Active then ErrorMessageRC(Str_CantFindBrowser,StrPas(Name));

      if (LoadURLString=Nil) or (LoadURLString^='') or
         (LoadFileString=Nil) or (LoadFileString^='') then Active:=false;

    end;
    FreeMem(F1,256); FreeMem(F,256);
  end;
end;                       { UploadBrowserInfo }

procedure SaveWinOptions;
var
  F: array[0..260] of char;
  F2: array[0..31] of char;
  i,j: integer;
  S: string;
  PrinterFont: boolean;
  PF,PF2: PChar;
  DevNames: PDevNames;

procedure SaveFont(FontRec: FontTypesType; Name: PChar; PrinterFont: boolean);
begin
  S:='';
  with FontRec do
  begin
    with LogFont do
      S:='"'+StrPas(lfFaceName) +'",'+ num2str(PointSize)        +','+
         num2str(lfWidth)        +','+ num2str(lfWeight)         +','+
         num2str(lfItalic)       +','+ num2str(lfUnderline)      +','+
         num2str(lfStrikeout)    +','+ num2str(lfCharSet)        +','+
         num2str(lfOutPrecision) +','+ num2str(lfClipPrecision)  +','+
         num2str(lfQuality)      +','+ num2str(lfPitchAndFamily);
    S:=S+','+num2str(GetRValue(Color)) +','+
             num2str(GetGValue(Color)) +','+
             num2str(GetBValue(Color));
  end;
  StrPCopy(F,S);
  if PrinterFont then
    WritePrivateProfileString(PrintingSec,Name,F,IniFile)
  else
    WritePrivateProfileString(FontsSec,Name,F,IniFile);
end;                                  { SaveFont }

procedure SavePos(Where: PChar; var P: InitialSizeRec);
begin
  with P do
    StrPCopy(F,num2str(x)+','+num2str(y)+','+num2str(w)+','+num2str(h));
  WritePrivateProfileString(PositionsSec,Where,F,IniFile);
end;

procedure SaveClick(Name: PChar; var R: ENameClickRec);
begin
  StrPCopy(F,'Copy');
  case R.Action of
    EnameClick_Copy:   StrPCopy(F,'Copy');
    EnameClick_CopyEx: StrPCopy(F,'CopySelection');
    ENameClick_String: if R.S<>Nil then StrPCopy(F,'"'+R.S^+'"');
  end;
  WritePrivateProfileString(NameClickSec,Name,F,IniFile);
end;                { SaveClick }

procedure SaveBoolean(Sec,Name: PChar; on: boolean);
begin
  if on then StrPCopy(F,'yes') else StrPCopy(F,'no');
  WritePrivateProfileString(Sec,Name,F,IniFile);
end;

procedure SaveColor(Name: PChar; Color: TColorRef);
begin
  StrPCopy(F,num2str(GetRValue(Color)) +','+
             num2str(GetGValue(Color)) +','+
             num2str(GetBValue(Color)));
  WritePrivateProfileString(ColorsSec,Name,F,IniFile);
end;

begin                { SaveWinOptions }
      { Positions }
  SavePos(MainWinSizeN,     MainWinSize);
  SavePos(EditEntrySizeN,   EdEnSize);
  SavePos(EditFieldSizeN,   EdFieldSize);
  SavePos(EntryListSizeN,   EntryListSize);
  SavePos(OverviewSizeN,    OverviewSize);
  SavePos(PattEditSizeN,    PattEditSize);
  SavePos(PattFieldSizeN,   PattFieldSize);
  SavePos(FindFileSizeN,    FindFileSize);
  SavePos(WhichFieldsSizeN, WhichFieldsSize);
  SavePos(OneFieldSizeN,    OneFieldSize);
  SavePos(EdStringsSizeN,   EdStringsSize);
  SavePos(EdAbbrevsSizeN,   EdAbbrevsSize);
  SavePos(ViewAbbrevsSizeN, ViewAbbrevsSize);
  SavePos(InsertAbbrevSizeN,InsertAbbrevSize);
  SavePos(BrowseFilesSizeN, BrowseFilesSize);
  SavePos(DispDupsSizeN,    DispDupsSize);
  SavePos(EdShowFormSizeN,  EdShowFormSize);

                                      { Fonts }
  for i:=FirstFontIndex to LastFontIndex do
  if not Fonts^[i].Default then
  begin
    PrinterFont:=(i>=PrintLabelFont) and (i<PrintNormalFont+17);
    if PrinterFont then j:=i-PrintNormalFont+NormalFont
    else j:=i;
    if      j=PattTextFont   then StrCopy(F2,PatternTextN)
    else if j=PattOpFont     then StrCopy(F2,PatternOpsN)
    else if j=PattFieldFont  then StrCopy(F2,PatternFieldN)
    else if j=FieldEditFont  then StrCopy(F2,FieldEditN)
    else if j=StatusBarFont  then StrCopy(F2,StatusBarN)
    else if j=LabelFont      then StrCopy(F2,LabelN)
    else if j=NormalFont     then StrCopy(F2,NormalN)
    else if j=BoldFont       then StrCopy(F2,BoldN)
    else if j=HyperFont      then StrCopy(F2,HyperN)
    else if j=ShowFormatFont then StrCopy(F2,SFormatFontN)
    else if j=PageHeaderFont then
    begin
      StrCopy(F2,PageHeaderN); PrinterFont:=true;
    end else if j<=10       then StrPCopy(F2,'Font'+num2str(j))
    else                         StrPCopy(F2,'Font'+Chr(Ord('A')-10+j));
    SaveFont(Fonts^[i],F2,PrinterFont);
  end;

  { Colors }
  SaveColor(TagColorN,TagColor);
  SaveColor(FilenameColorN,FilenameColor);
  SaveColor(ENameBackColorN,ENameBackColor);
  SaveColor(DupEntriesColorN,DupEntriesColor);

  { Entry name click }
  SaveClick(ControlN,NameClickCtrl);
  SaveClick(ShiftN,NameClickShift);
  SaveClick(ShiftControlN,NameClickCtrlShift);
  StrPCopy(F,'');
  if NameClickMenuString<>Nil then StrPCopy(F,'"'+NameClickMenuString^+'"');
  WritePrivateProfileString(NameClickSec,MenuStringN,F,IniFile);

  { General }

  StrPCopy(F,ProgramVersion);
  WritePrivateProfileString(GeneralSec,VersionN,F,IniFile);

  SaveBoolean(GeneralSec,SaveWinOptionsN,    SaveWinOptsOnExit);
  SaveBoolean(GeneralSec,CoffeeWhileYouWaitN,UseCoffeeCup);
  SaveBoolean(GeneralSec,Use3dN,             UseCtl3d);

  if WinYieldStep<=0 then StrPCopy(F,'off')
  else if WinYieldStep=1 then StrPCopy(F,'on')
  else StrPCopy(F,num2str(WinYieldStep));
  WritePrivateProfileString(GeneralSec,BackgroundProcN,F,IniFile);

  { Abbreviations }
  SaveBoolean(GeneralSec,ExpandAbbrevsN,     ExpandIniAbbrevs);
  SaveBoolean(GeneralSec,ExpandStringsN,     ExpandStrings);

  StrPCopy(F,BIBAbbrevsFile^);
  WritePrivateProfileString(GeneralSec,AbbrevsBIBFileN,F,IniFile);
  StrPCopy(F,BSTAbbrevsFile^);
  WritePrivateProfileString(GeneralSec,AbbrevsBSTFileN,F,IniFile);

  StrPCopy(F,'yes');
  if BibTeXHelpMode=0 then StrPCopy(F,'no')
  else if BibTeXHelpMode=2 then StrCopy(F,BibTeXHelpFile);
  WritePrivateProfileString(GeneralSec,BibTeXHelpN,F,IniFile);

  { Printing }
  S:='0';
  if HPDevNames<>0 then
  begin
    DevNames:=GlobalLock(HPDevNames);
    if DevNames^.wDefault and dn_DefaultPrn=0 then
    begin
      PF:=PChar(DevNames)+DevNames^.wDriverOffset;
      S:=StrPas(PF);
      PF:=PChar(DevNames)+DevNames^.wDeviceOffset;
      S:=S+','+StrPas(PF);
      PF:=PChar(DevNames)+DevNames^.wOutputOffset;
      S:=S+','+StrPas(PF);
    end;
    GlobalUnlock(HPDevNames);
  end;
  StrPCopy(F,S);
  WritePrivateProfileString(PrintingSec,DeviceN,F,IniFile);

  StrPCopy(F,num2str(LeftMargin)+','+num2str(RightMargin)+','+
             num2str(TopMargin) +','+num2str(BottomMargin));
  WritePrivateProfileString(PrintingSec,MarginsN,F,IniFile);

  StrPCopy(F,num2str(EntrySeparation));
  WritePrivateProfileString(PrintingSec,EntrySeparationN,F,IniFile);

  SaveBoolean(PrintingSec,PrintToFileN,     PrintToFile);
  SaveBoolean(PrintingSec,PrintPageHeaderN, PrintPageHeader);
  SaveBoolean(PrintingSec,PrintEntryHeaderN,PrintEntryHeader);

  { Toolbar }
  SaveBoolean(ToolbarSec,VisibleN,UseToolbar);
  if LargeTBarBtns=TBtnSize_Large then StrPCopy(F,'large')
  else if LargeTBarBtns=TBtnSize_Small then StrPCopy(F,'small')
  else StrPCopy(F,'autosize');
  WritePrivateProfileString(ToolbarSec,ButtonSizeN,F,IniFile);

  F[0]:=#0;
  for i:=1 to TBar_LastBtn do
  with ToolBtns[i] do
  begin
    StrPCopy(F2,','+num2str(Order)); StrCat(F,F2);
  end;
  WritePrivateProfileString(ToolbarSec,ButtonOrderN,F+1,IniFile);

  { Hyperlinks }
  GetMem(PF,32*K1);
  GetPrivateProfileString(HyperlinkSec,Nil,'',PF,32*K1-2,IniFile);
  PF2:=PF;
  while StrLen(PF2)>0 do
  begin
    StrLower(PF2);
    if (StrIComp(PF2,ResolveHyperN)  <>0) and
       (StrIComp(PF2,HyperSyntaxN)   <>0) and
       (StrIComp(PF2,WWWDownloadDirN)<>0) and
       (StrIComp(PF2,UseMAPIN)       <>0) and
       (StrIComp(PF2,WWWBrowserN)    <>0) then
    begin
      j:=0;
      for i:=1 to Hyper_User-1 do
      begin
        StrPCopy(F,HyperTypesArr^[i].pre^); StrLower(F);
        if StrComp(PF2,F)=0 then j:=i;
      end;
      if j=0 then
        WritePrivateProfileString(HyperlinkSec,PF2,Nil,IniFile);
    end;
    PF2:=PF2+StrLen(PF2)+1;
  end;
  FreeMem(PF,32*K1);

  SaveBoolean(HyperlinkSec,ResolveHyperN,HyperlinkFlags.on);
  StrPCopy(F,'verify');
  S:='';
  if HyperlinkFlags.LaTeX then S:='LaTeX';
  if HyperlinkFlags.HTML  then
  begin
    if S<>'' then S:=S+',';
    S:=S+'HTML';
  end;
  if S='' then S:='LaTeX,HTML';
  StrPCopy(F,S);
  WritePrivateProfileString(HyperlinkSec,HyperSyntaxN,F,IniFile);
  if WWWBrowserList<>Nil then
    WritePrivateProfileString(HyperlinkSec,WWWBrowserN,WWWBrowserList,IniFile);
  if WWWUploadDir<>Nil then
    WritePrivateProfileString(HyperlinkSec,WWWDownloadDirN,WWWUploadDir,IniFile);
  SaveBoolean(HyperlinkSec,UseMAPIN,UseMAPI);

  GetMem(PF,1024);
  for i:=1 to NHyperTypes do
  with HyperTypesArr^[i] do
  if HType>0 then
  begin
    StrPCopy(F,pre^);
    StrPCopy(PF,num2str(Flags)+','+TeXMacro^);
    if i>=Hyper_User then
    begin
      PF2:=PF+StrLen(PF); StrPCopy(PF2,','+HyperTypesArr^[HType].pre^);
      PF2:=PF+StrLen(PF); StrPCopy(PF2,','+App^);
    end;
    WritePrivateProfileString(HyperlinkSec,F,PF,IniFile);
  end;
  FreeMem(PF,1024);

  { Objects }
  SaveBoolean(ObjectsSec,ObjectsOnN,ResolveObjects);
  StrPCopy(F,ObjectTeXMacro^);
  WritePrivateProfileString(ObjectsSec,ObjectTeXMacroN,F,IniFile);
  SaveBoolean(ObjectsSec,LockOleServersN,LockOleServers);
  SaveBoolean(ObjectsSec,CompressObjectsN,CompressObjects);

  { Images }
  StrPCopy(F,ImageTeXMacro^);
  WritePrivateProfileString(ImagesSec,ImageTeXMacroN,F,IniFile);
  if HTMLImages<>Nil then
  begin
    StrPCopy(F,HTMLImages^);
    WritePrivateProfileString(ImagesSec,HTMLImagesN,F,IniFile);
  end;
  SaveBoolean(ImagesSec,GraphicsFiltersN,UseGraphicsFilters);

  F[0]:=#0;
  for i:=1 to GrExt_Last do
    with IntGraphList[i] do
      if not on then StrLCat(F,Ext,255); StrLCat(F,';',255);
  if (F[0]<>#0) and (F[StrLen(F)-1]=';') then F[StrLen(F)-1]:=#0;
  WritePrivateProfileString(ImagesSec,RenderExternalN,F,IniFile);
  SaveBoolean(ImagesSec,CompressImagesN,CompressImages);
  SaveBoolean(ImagesSec,IconizeImagesN, IconizeImages);
end;                               { SaveWinOptions }


end.
