{$W-,R+,V-,G+}
unit wbibseps;

interface

Uses
  WinTypes,WinProcs,WObjects,strings;

const
  { Callback messages }
  GSDLL_STDIN  = 1;   { get count characters to str from stdin  }
                      {   return number of characters read      }
  GSDLL_STDOUT = 2;   { put count characters from str to stdout }
                      {   return number of characters written   }
  GSDLL_DEVICE = 3;   { device = str has been opened if count=1 }
                      {                    or closed if count=0 }
  GSDLL_SYNC   = 4;   { sync_output for device str              } 
  GSDLL_PAGE   = 5;   { output_page for device str              }
  GSDLL_SIZE   = 6;   { resize for device str                   }
                      {   LOWORD(count) is new xsize            }
                      {   HIWORD(count) is new ysize            }
  GSDLL_POLL   = 7;   { Called from gp_check_interrupt          }
			  { Can be used by caller to poll the message queue       }
			  { Normally returns 0                                    }
			  { To abort gsdll_execute_cont(), return a               }
			  { non zero error code until gsdll_execute_cont()        }
			  { returns                                               }

  { gsdll_init return codes }
  GSDLL_INIT_IN_USE = 100;    { DLL is in use                       }
  GSDLL_INIT_QUIT   = 101;    { quit or EOF during init             }
                              {    This is not an error.            }
                              {    gsdll_exit() must not be called. }

type
  TGSCallback = function(Message: integer; S: PChar;
                                         count : longint): integer;
  PPchar = ^PChar;
  TPCharArr = array[0..255] of PChar;
  PPCharArr = ^TPCharArr;

var
  GsInitStr,GsDir: PChar;
  GSCallback: TFarProc;

function  gsdll_revision(Product,Copyright: PPChar;
                         gs_revision,gs_revisiondate: Plongint): integer;
function  gsdll_init(Callback: TGSCallback; Wnd: HWnd; argc: integer;
                     argv: PPCharArr): integer;
function  gsdll_execute_begin: integer;
function  gsdll_execute_cont(S: PChar; len: integer): integer;
function  gsdll_execute_end: integer;
function  gsdll_exit: integer;
function  gsdll_lock_device(Device: PChar; flag: integer): integer;

function  gsdll_copy_DIB(Device: PChar): THandle;
function  gsdll_copy_palette(Device: PChar): HPalette;
procedure gsdll_draw(Device: PChar; DC: hDC; dest,src: PRect);
function  gsdll_get_bitmap_row(Device: PChar; pbmih: PBitmapInfoHeader): integer;

procedure UnloadEpsDLL;


implementation

const
  Lib = 'c:\gs\gsdll16.dll';

function  gsdll_revision; external lib;
function  gsdll_init; external lib;
function  gsdll_execute_begin; external lib;
function  gsdll_execute_cont; external lib;
function  gsdll_execute_end; external lib;
function  gsdll_exit; external lib;
function  gsdll_lock_device; external lib;

function  gsdll_copy_DIB; external lib;
function  gsdll_copy_palette; external lib;
procedure gsdll_draw; external lib;
function  gsdll_get_bitmap_row; external lib;

var
  OldExitProc: Pointer;




procedure UnloadEpsDLL;
begin
    if GSCallback<>Nil then
    begin
      FreeProcInstance(GSCallback); GSCallback:=Nil;
    end;
end;                  { UnloadEpsDLL }

procedure GSExitProc; far;
begin
  ExitProc:=OldExitProc;
  UnloadEpsDLL;
end;

begin
  OldExitProc:=ExitProc; ExitProc:=@GSExitProc;
  GSInitStr:=Nil;
  GsDir:=Nil;
  GSCallback:=Nil;
end.