/*
 * A BibtexStringReference references a BibtexStringDefinition
 * 
 * Created on Mar 17, 2003
 *
 * @author henkel@cs.colorado.edu
 * 
 */
package bibtex.dom;

import java.io.PrintWriter;
import java.io.Serializable;

/**
 * A BibtexStringReference either references a BibtexStringDefinition.
 * 
 * @author	henkel
 * @author	Yann-Gal Guhneuc
 */
public class BibtexStringReference
	extends BibtexAbstractValue
	implements Serializable {

	private String key;

	protected BibtexStringReference(final String key) {
		this.key = key;
	}

	/**
	 * @return String
	 */
	public String getValue() {
		return key;
	}

	/**
	 * Sets the key.
	 * @param key The key to set
	 */
	public void setKey(final String key) {
		this.key = key;
	}

	public void print(final PrintWriter writer) {
		writer.print(this.key);
	}
}
