#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include "catdoc.h"
int unknown_as_hex=0;
/************************************************************************/
/* performs paragraph formatting if wrap_margin is non-zero             */
/* gets character sequence and appends it to buffer. If buffer is long  */
/* enough, prints its beginning out                                     */
/************************************************************************/
static char buffer[LINE_BUF_SIZE]="";
void out_char(const char *chunk) {
    if (!wrap_margin) {
       fputs(chunk,stdout);
       return;
    }
    strcat(buffer,chunk); /* This strcat is safe. wrap margin setting
                             code in main.c ensures that wrap_margin is 
			     less than LINE_BUF_SIZE-strlen(largest chunk)
			   */  
    if (strchr(chunk,'\n')) {
      /* End of paragraph */
      char *q = map_subst(spec_chars,'\n');
      fputs(buffer,stdout);
      *buffer=0;
      if (q) fputs(q,stdout);
    } else if (strlen(buffer)>wrap_margin) {
        char *q=buffer,*p=buffer+wrap_margin;
        while (p>buffer&&!isspace(*p)) p--;
        if (p==buffer) {
        /*worst case - nowhere to wrap. Will use brute force */
            fwrite(buffer,wrap_margin,1,stdout);
            fputc('\n',stdout);
            p=buffer+wrap_margin;
        } else {
            *p=0;p++;
	    fputs(buffer,stdout);
	    fputc('\n',stdout);
        }
	for(q=buffer;*p;p++,q++) *q=*p;
	*q=0;
     }
}
/**************************************************************************/
/*  Converts unicode char to output charset sequence. Coversion have      */
/*  three steps: 1. Replacement map is searched for the character in case */
/* it is not allowed for output format (% in TeX, < in HTML               */
/* 2. target charset is searched for this unicode char, if it wasn't      */
/*  replaced. If not found, then 3. Substitution map is searched          */
/**************************************************************************/
char *convert_char(int uc) {
    static char plain_char[]="a"; /*placeholder for one-char sequences */
    static char bad_char[]={UNKNOWN_CHAR,0};
    static char hexbuf[8];
    char *mapped;
    int c;
    if ((mapped=map_subst(spec_chars,uc))) return mapped;
    c =from_unicode(target_charset,uc);
    if (c>=0) {
        *plain_char=c;
        return plain_char;
    }
    if ((mapped = map_subst(replacements,uc))) return mapped;
    if (unknown_as_hex) {
       sprintf(hexbuf,"\\x%04X",(unsigned)uc);
       /* This sprintf is safe, becouse uc is unicode character code,
          which cannot be greater than 0xFFFE. It is ensured by routines
	  in reader.c
	*/
       return hexbuf;
    }   
    return  bad_char;
}
void output_paragraph(unsigned short int *buffer) {
    unsigned short int *p;
    for (p=buffer;*p;p++) {
        out_char(convert_char(*p));
    }
    out_char("\n");
}
