/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.uninstaller.console;

import com.izforge.izpack.uninstaller.Destroyer;
import com.izforge.izpack.uninstaller.event.DestroyerListener;
import com.izforge.izpack.util.Console;
import java.io.File;

public class ConsoleUninstaller {
    private final Destroyer destroyer;
    private final Console console;

    public ConsoleUninstaller(Destroyer destroyer, DestroyerListener listener, Console console) {
        this.destroyer = destroyer;
        this.console = console;
        destroyer.setProgressListener(listener);
    }

    public void uninstall(boolean force) {
        this.console.println("Force deletion: " + force);
        this.destroyer.setForceDelete(force);
        this.destroyer.run();
        if (!this.destroyer.getFailedToDelete().isEmpty()) {
            this.console.println("WARNING: The following files could not be removed: ");
            for (File file : this.destroyer.getFailedToDelete()) {
                this.console.println(file.getPath());
            }
        }
    }
}

