.TH GO 1L "4/23/92" "University of Michigan"
.SH NAME
go \- generate LaTeX document
.SH SYNOPSIS
.B go
[-c] [-f] [-g] [-h] [-i] [-p] [-ps] [-pv] [-pvc] [lpr_options] [page_options] [filename[.tex]]
.SH DESCRIPTION
.I Go
completely automates the process of generating a LaTeX document.
Essentially, it is a highly specialized relative of the general \fImake\fR
utility. 
Given the source files for a document, \fIgo\fR issues the appropriate
sequence of commands to generate a .dvi, .ps, or hardcopy version of
the document.  \fIGo\fR looks for default information about source file
dependencies and processing modes in a ".gorc" file in the user's
current directory or home directory.  The \fB-i\fR option can be used to
automatically generate a .gorc tailored to a particular document.
Alternatively, a user may simply edit a .gorc and set the desired flags.
For instance, putting the line
.br
.in +1in
$root_filename='filename';
.br
.in
in a local .gorc will set the default root filename for a directory, 
so the user can run \fIgo\fR without retyping the filename.
Note that \fIgo\fR assumes that only one LaTeX document is present in
a directory: this minor restriction is good directory management style anyways.
However, if more than one version of a paper is kept in a single directory, the
user can switch the local .gorc between versions by re-running with the
\fB-i\fR option and the appropriate root filename.
.PP
Options which \fIgo\fR does not recognize are passed to \fIlpr\fR if the
user has specified printed output with the \fB-p\fR option.  
\fIGo\fR will also automatically run \fIdviselect\fR to choose only a 
subset of the
pages in a document.  The user may specify a space-separated list of 
single page numbers, as well as colon- or dash-separated page ranges.  
The .dvi and .ps files containing only parts of documents are
stored with the filename root 'root_filename_partial', so that the 
processing involved in generating the complete document is not lost.
The \fB-c\fR option rapidly cleans up unneeded files.
.PP
\fIGo\fR recognizes the commands that are unique to SliTeX documents; 
the \fB-i\fR
option will automatically turn on the slide mode in the .gorc when it finds
a \\colorslides or \\blackandwhite include command.
When the user selects specific pages of a slide document, \fIgo\fR
actually produces a dummy root file and selects those pages using a
\\onlyslides command, so that any overlay headers will appear correctly in
the selected subset of slides.
.PP
\fIGo\fR has two different previewing options.  In the simple \fB-pv\fR
option, a postscript previewer such as \fIgs\fR is automatically run after
generating the postscript version of the document.  When a document is
reaching the final stages of editing, the user frequently wants to make
small changes to the source files and examine the effects in a previewer;
for this phase, \fIgo\fR provides the powerful \fB-pvc\fR option (mnemonic:
"preview continuously").  With this option, \fIgo\fR forks a child process
to run an \fIxtex\fR previewer on the document, and then \fIgo\fR
repeatedly monitors the source files of the document to see if any changes
have been mades since the last .dvi file was produced.  When changes
are detected, \fIgo\fR runs the appropriate LaTeX commands to regenerate
the .dvi file, and then sends a signal to the \fIxtex\fR job, indicating
that the previewer should update its display.  Thus the user can simply
edit a file and, when the changes are written to disk, \fIgo\fR completely
automates the cycle of updating the .dvi and refreshing the previewer's
display.  It's not quite WYSIWYG, but LaTeX has never been closer.
.PP
\fIGo\fR also detects the RTCL 'landscapemode' documentstyle, setting a flag
in the .gorc which the postscript previewer \fIgp\fR will observe,
so that \fIgp\fR will automatically create a landscape previewing window.
.SH GO OPTIONS
.TP 
.B -c
Clean up (remove) all unnecessary files generated by \fIlatex\fR, \fIbibtex\fR,
and \fIbibextract\fR.
.TP
.B -f
Force \fIgo\fR to continue document processing despite errors.
Normally, when \fIgo\fR detects that \fIlatex\fR has found an error which will
not be resolved by further processing, the program terminates.
.TP
.B -g
Force \fIgo\fR to process document, disregarding the timestamps of the 
source files.
This option is particularly useful when updating style files, which are not
included in the file dependency information.
.TP
.B -h
Print help information.
.TP
.B -i
Scan source files for all included files, putting the resulting dependency 
information into the .gorc initialization file in the current directory.
This option allows the user to essentially leave all the work to \fIgo\fR.
The program will find all LaTeX \\include, \\input, \\psfig, \\epsfbox, 
\\blackandwhite,
and \\colorslides commands which input other source files.  When \fIgo\fR
is run thereafter, it will examine the timestamps on those files and run
the various LaTeX processing programs as necessary, if any of the source
files has been changed since the last document generation.
The root filename of the document is also stored in the .gorc, so
after a single pass with the \fB-i\fR option, the user need not specify
the root filename again.  If the dependencies of the document are changed
(e.g., by adding or removing a \\include command), an additional pass of
\fIgo -i\fR will update the .gorc as necessary.
.TP
.B -p
Print document using lpr, after generating postscript file.
.TP
.B -ps
Generate postscript version of document.
.TP
.B -pv
Run a postscript previewer after generating postscript file.
.TP
.B -pvc
Run a dvi-previewer and continually update the .dvi file whenever changes
are made to source files (see the Description above).
Note that if \fIgo\fR dies because it encounters an error, 
the forked previewer will continue to run.  Successive invocations with
the \fB-pvc\fR option will not fork new previewers, but will find
the existing previewer and send it the signals indicating the .dvi has
been updated.
.SH .GORC VARIABLES
.PP
These variables may be set in the .gorc file as illustrated above.  Some are set
automatically by the \fB-i\fR option.  Default values are indicated in brackets.
.TP
.B $bibdb_mode [0]
If nonzero, the document has a bibliography extracted from the BibDb
bibliographic database using \fIbibextract\fR (UM only).
.TP
.B $bibtex ['bibtex']
The BibTeX processing program.
.TP
.B $bibtex_mode [0]
If nonzero, the document has a bibtex bibliography.  Set by the \fB-i\fR option.
.TP
.B $dvips ['ndvips']
The program to convert a .dvi file to a .ps file.
.TP
.B $dviselect ['dviselect']
The program to select given pages from a .dvi file.
.TP
.B $dvi_previewer ['xtex']
The dvi-previewer to run with the \fB-pvc\fR option.
.TP
.B $force_mode [0]
If nonzero, continue processing past minor \fIlatex\fR errors 
including unrecognized cross references.
.TP
.B $index_mode [0]
If nonzero, run \fImakeindex\fR to produce index of document.  Set by
the \fB-i\fR option.
.TP
.B $latex ['latex']
The LaTeX processing program.
.TP
.B $lpr ['lpr']
The printing program.
.TP
.B $lpr_options ['']
A string which is passed to \fIlpr\fR when the \fB-p\fR option is 
used.  Usually set on the command line, as illustrated in examples below.
.TP
.B $makeindex ['makeindex']
The index processing program.
.TP
.B $page_options ['']
A string which is passed to \fIdviselect\fR when the \fB-ps\fR or \fB-p\fR
options are used.  Usually set on the command line, as illustrated 
in examples below.
.TP
.B $postscript_mode [0]
If nonzero, generate a postscript version of the document.  
Set by the \fB-i\fR option if $slide_mode is set.
.TP
.B $preview_continuous_mode [0]
If nonzero, run the \fB$dvi_previewer\fR to preview the document, and
continue running \fIgo\fR to keep .dvi up-to-date, as in the \fB-pvc\fR
option.
.TP
.B $preview_mode [0]
If nonzero, run the \fB$ps_previewer\fR to preview the document, as in
the \fB-pv\fR option.  
.TP
.B $print_mode [0]
If nonzero, print the document using \fIlpr\fR.
.TP
.B $ps_previewer ['gs']
The postscript previewer to run with the \fB-pv\fR option.
.TP
.B $root_filename ['main']
The default filename for the root .tex document file.  Set by the \fB-i\fR
option.
.TP
.B $sleep_time [2]
The time to sleep (in seconds) between checking for source file 
changes when running the \fB-pvc\fR option.
.TP
.B $slide_mode [0]
If nonzero, document is a Slitex document.  Set by the \fB-i\fR option.
.TP
.B $slitex ['slitex']
The SLiTeX processing program for slides.
.SH EXAMPLES
.nf
.ta 2in
% \fBgo -i thesis\fR	\fI# scan for includes, setup initial .gorc\fR

% \fBgo\fR	\fI# normal use after running with \fB-i\fI once\fR

% \fBgo -p -Prtcl 1 3-5\fR	\fI# print pages 1, 3, 4, and 5 to printer rtcl\fR

% \fBgo -c\fR	\fI# remove .aux, .log, .bbl, .blg, .dvi, .ps & .bbe files\fR
.SH FILES
.gorc
.SH SEE ALSO
latex(1), bibtex(1), bibextract(1L), gp(1L).
.SH FEATURES NOT YET IMPLEMENTED
.PP
Processing of \\includeonly.
.SH BUGS
.PP
I'm sure you'll let me know.
.SH IDENTIFICATION
David J. Musliner
.br
djm@eecs.umich.edu
.br
Real-Time Computing Lab
.br
University of Michigan, Ann Arbor, MI  48109
.br
RCS $Revision: 3.2 $ ; Release Date: 4/9/92.
