package com.dickimawbooks.jmakepdfx;

import java.awt.*;
import java.io.*;
import java.net.*;
import java.awt.event.*;
import javax.swing.*;

public class JpdfxResources
{
    public static synchronized void error(Component parent, String message)
    {
       Jmakepdfx.debug("Error: '"+message+"'");

       errorPanel.updateMessage(message);

       JOptionPane.showMessageDialog(parent, errorPanel,
          Jmakepdfx.getLabelWithAlt("error.title", "Error"),
          JOptionPane.ERROR_MESSAGE);
    }

    public static synchronized void error(Component parent, Exception e)
    {
       String message = e.getMessage();

       if (message == null)
       {
          message = e.getClass().getName();
       }

       error(parent, message, e);
    }

    public static void error(Component parent, String message, Exception e)
    {
       Jmakepdfx.debug("Exception: "+e.getClass().toString()+" '"+message+"'");

       errorPanel.updateMessage(message, e);

       JOptionPane.showMessageDialog(parent, errorPanel,
          Jmakepdfx.getLabelWithAlt("error.title", "Error"),
         JOptionPane.ERROR_MESSAGE);

       e.printStackTrace();
    }

    public static void warning(Component parent, String message)
    {
       Jmakepdfx.debug("Warning: '"+message+"'");

       JOptionPane.showMessageDialog(parent,
          message,
          Jmakepdfx.getLabelWithAlt("error.warning", "Warning"),
          JOptionPane.WARNING_MESSAGE);
    }

    public static JButton createContinueButton(ActionListener listener)
    {
       return createContinueButton(listener, null);
    }

    public static JButton createContinueButton(ActionListener listener, String tooltipText)
    {
       return createActionButton(
          Jmakepdfx.getLabel("button.continue"),
          Jmakepdfx.getMnemonic("button.continue"),
          "okay", listener,
          KeyStroke.getKeyStroke(KeyEvent.VK_ENTER, 0), tooltipText);
    }

    public static JButton createOkayButton(ActionListener listener)
    {
       return createOkayButton(listener, null);
    }

    public static JButton createOkayButton(ActionListener listener, String tooltipText)
    {
       return createActionButton(
          Jmakepdfx.getLabel("button.okay"),
          Jmakepdfx.getMnemonic("button.okay"),
          "okay", listener,
          KeyStroke.getKeyStroke(KeyEvent.VK_ENTER, 0), tooltipText);
    }

    public static JButton createCloseButton(ActionListener listener)
    {
       return createCloseButton(listener, null);
    }

    public static JButton createCloseButton(ActionListener listener, String tooltipText)
    {
       return createActionButton(
          Jmakepdfx.getLabel("button.close"),
          Jmakepdfx.getMnemonic("button.close"),
          "okay", listener,
          KeyStroke.getKeyStroke(KeyEvent.VK_ENTER, 0), tooltipText);
    }

    public static JButton createCancelButton(ActionListener listener)
    {
       return createCancelButton(listener, null);
    }

    public static JButton createCancelButton(ActionListener listener, String tooltipText)
    {
       return createActionButton(
          Jmakepdfx.getLabel("button.cancel"),
          Jmakepdfx.getMnemonic("button.cancel"),
          "cancel", listener,
          KeyStroke.getKeyStroke(KeyEvent.VK_ESCAPE, 0), tooltipText);
    }

    public static JButton createActionButton(String label, char mnemonic,
      String actionCommand, ActionListener listener, KeyStroke keyStroke, 
      String tooltipText)
    {
       JButton button = new JButton(label);
       button.setMnemonic(mnemonic);

       if (listener != null)
       {
          button.addActionListener(listener);

          if (actionCommand != null)
          {
             button.setActionCommand(actionCommand);

             if (keyStroke != null)
             {
                button.registerKeyboardAction(listener, actionCommand, keyStroke,
                  JComponent.WHEN_IN_FOCUSED_WINDOW);
             }
          }
       }

       if (tooltipText != null)
       {
          button.setToolTipText(tooltipText);
       }

       return button;
    }

    private static ErrorPanel errorPanel = new ErrorPanel();
}
