/* Font.h
 *
 * Anything having to do with changing the style, family, or size of the
 * fonts is handled through this Font class.
 *
 * Copyright 1992 Jonathan Monsarrat. Permission given to freely distribute,
 * edit and use as long as this copyright statement remains intact.
 *
 */

#include <fstream.h>

const MAXFONTS = 100;
/* The list of what fonts are used, and in what order and with what
 * characters
 */
class FontUsed {
   char _style[MAXSTRING];   // combines font style and font size
   char _petname[MAXSTRING];  // The name we use for this font
   int _charused[256];
   int _font;

 public:
   FontUsed(char *, char *, int);
   void used(char *);
   int font();
   int match(char *);
   char *petname();
   void dump(ofstream &);
};


/* Any change to the font type, size, or style */
class Font : public Param {
 public:
   enum FontTypes {
      // Base Sizes
      Base10pt,
      Base11pt,
      Base12pt,

      // Font Styles
      Bold,
      Italic,
      Roman,
      SansSerif,
      Slant,
      SmallCaps,
      Typewriter,

      // Font Sizes
      Tiny,
      Scriptsize, 
      Footnotesize,
      Small,
      Normalsize,
      large,
      Large,
      LARGE,
      huge,
      Huge,

      // Font Commands
      Base,
      Currentused,
      FunnyPrint,
      Pending,
      Size,
      Style,
      ShutDown,
      Used
   };

   Font();
   Font(Font *);
   ~Font();
   Param *copy();
   int set(int, float, char*);
   float get(int, char*);
   static FontUsed *_fonts_used[MAXFONTS];
   static int _num_fonts_used;
   int do_command(char *, char *, int, int);
   void postscript_set(int);
   void revert(Param *);
   void shutdown();
   void use_command(char *, char *, int);
 private:
   int _basesize;
   int _fontsize;
   char _fontstyle[3];
   char _fontsizecmd[15];
   int _currentused;
   int _pending;
   int _pending_whitespace;
   void newsize(float);
   void set_fontstyle(char *);
};
