/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util.file.types.selectors;

import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.util.file.types.Parameter;
import com.izforge.izpack.util.file.types.selectors.BaseExtendSelector;
import java.io.File;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public class TypeSelector
extends BaseExtendSelector {
    private FileType type;
    public static final String TYPE_KEY = "type";

    public String toString() {
        StringBuffer buf = new StringBuffer("{typeselector type: ");
        buf.append(this.type.getAttribute());
        buf.append("}");
        return buf.toString();
    }

    public void setType(FileType fileType) {
        this.type = fileType;
    }

    @Override
    public void setParameters(Parameter[] parameters) {
        super.setParameters(parameters);
        if (parameters != null) {
            for (Parameter parameter : parameters) {
                String paramname = parameter.getName();
                if (TYPE_KEY.equalsIgnoreCase(paramname)) {
                    FileType type = FileType.getFromAttribute(parameter.getValue());
                    if (type != null) {
                        this.setType(type);
                        continue;
                    }
                    this.setError("Invalid type setting " + parameter.getValue());
                    continue;
                }
                this.setError("Invalid parameter " + paramname);
            }
        }
    }

    @Override
    public void verifySettings() {
        if (this.type == null) {
            this.setError("The type attribute is required");
        }
    }

    @Override
    public boolean isSelected(InstallData idata, File basedir, String filename, File file) throws Exception {
        this.validate();
        if (file.isDirectory()) {
            return this.type.equals((Object)FileType.DIR);
        }
        return this.type.equals((Object)FileType.FILE);
    }

    public static enum FileType {
        FILE("file"),
        DIR("dir");

        private static Map<String, FileType> lookup;
        private String attribute;

        private FileType(String attribute) {
            this.attribute = attribute;
        }

        public String getAttribute() {
            return this.attribute;
        }

        public static FileType getFromAttribute(String attribute) {
            if (attribute != null && lookup.containsKey(attribute)) {
                return lookup.get(attribute);
            }
            return null;
        }

        static {
            lookup = new HashMap<String, FileType>();
            for (FileType mapperType : EnumSet.allOf(FileType.class)) {
                lookup.put(mapperType.getAttribute(), mapperType);
            }
        }
    }
}

