/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.text.AbstractDocument;

public class MEPer
extends JFrame {
    static int initWidth = 1000;
    static int initHeight = 618;
    boolean ispc;
    JToolBar toolbar;
    JTextPane editor;
    JLabel graph;
    JLabel statusLabel;
    JButton saveButton;
    JButton previewButton;
    JButton helpButton;
    Action saveAction;
    Action previewAction;
    Action helpAction;
    JDialog helpWindow = null;
    EditorFilter editorFilter;
    String workingDir;
    static String helpTitle = "Metapost Editor and Previewer v1.0";
    static String dirName = "MetaPostPreview";
    static String metapost = "mpost -interaction=nonstopmode preview.mp end";
    static String convert = "convert preview.eps preview.png";
    static String ghostscript = " -dBATCH -dNOPAUSE -dQUIET -dEPSCrop -dEPSFitPage -dGraphicsAlphaBits=4 -dTextAlphaBits=4 -sDEVICE=pngalpha -sOutputFile=preview.png preview.eps";

    private void saveFile() {
        try {
            FileWriter fileWriter = new FileWriter(this.workingDir + File.separator + "preview.mp");
            fileWriter.write(this.editor.getText());
            fileWriter.close();
            this.saveButton.setEnabled(false);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void consumeRuntime(Process process) {
        final BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
        final BufferedReader bufferedReader2 = new BufferedReader(new InputStreamReader(process.getInputStream()));
        Thread thread = new Thread(){

            @Override
            public void run() {
                try {
                    String string;
                    while ((string = bufferedReader.readLine()) != null) {
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        };
        Thread thread2 = new Thread(){

            @Override
            public void run() {
                try {
                    String string;
                    while ((string = bufferedReader2.readLine()) != null) {
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        };
        thread.start();
        thread2.start();
    }

    private void createActions() {
        this.saveAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MEPer.this.saveFile();
                MEPer.this.statusLabel.setText("preview.mp saved in directory: " + MEPer.this.workingDir);
                MEPer.this.editor.requestFocus();
            }
        };
        this.previewAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MEPer.this.saveFile();
                SwingUtilities.invokeLater(new Runnable(){

                    /*
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     */
                    @Override
                    public void run() {
                        try {
                            File file = new File(MEPer.this.workingDir + File.separator + "preview.mp");
                            File file2 = new File(MEPer.this.workingDir + File.separator + "preview.1");
                            File file3 = new File(MEPer.this.workingDir + File.separator + "preview.eps");
                            File file4 = new File(MEPer.this.workingDir + File.separator + "preview.png");
                            new File(MEPer.this.workingDir + File.separator + "preview.1").delete();
                            new File(MEPer.this.workingDir + File.separator + "preview.eps").delete();
                            new File(MEPer.this.workingDir + File.separator + "preview.png").delete();
                            File file5 = new File(MEPer.this.workingDir);
                            Process process = null;
                            if (!file.exists()) {
                                MEPer.this.statusLabel.setText("Can't find file: preview.mp");
                                return;
                            }
                            MEPer.this.statusLabel.setText("Generating preview image...");
                            process = Runtime.getRuntime().exec(metapost, null, file5);
                            if (process == null) {
                                MEPer.this.statusLabel.setText("Error on running metapost.");
                                return;
                            }
                            MEPer.this.consumeRuntime(process);
                            process.waitFor();
                            process = null;
                            if (!file2.exists()) {
                                MEPer.this.statusLabel.setText("Cant' find file: preview.1");
                                return;
                            }
                            file2.renameTo(file3);
                            MEPer.this.statusLabel.setText("preview.1 renamed to preview.eps.");
                            if (!file3.exists()) {
                                MEPer.this.statusLabel.setText("Can't find file: preview.eps");
                                return;
                            }
                            process = Runtime.getRuntime().exec(convert, null, file5);
                            if (process != null) {
                                MEPer.this.consumeRuntime(process);
                                process.waitFor();
                                process = null;
                            } else {
                                MEPer.this.statusLabel.setText("Error on running ImageMagick.Try ghostscript...");
                            }
                            if (!file4.exists()) {
                                process = Runtime.getRuntime().exec(ghostscript, null, file5);
                                if (process == null) {
                                    MEPer.this.statusLabel.setText("Error on running ghostscript.");
                                    return;
                                }
                                MEPer.this.consumeRuntime(process);
                                process.waitFor();
                                process = null;
                            }
                            if (!file4.exists()) {
                                MEPer.this.statusLabel.setText("Can't find file: preview.png");
                                return;
                            }
                            MEPer.this.statusLabel.setText("Reloading preview image...");
                            ((ImageIcon)MEPer.this.graph.getIcon()).getImage().flush();
                            ImageIcon imageIcon = new ImageIcon(MEPer.this.workingDir + File.separator + "preview.png");
                            MEPer.this.graph.setIcon(imageIcon);
                            MEPer.this.graph.repaint();
                            MEPer.this.statusLabel.setText(" preview.[mp|eps|png] saved in directory: " + MEPer.this.workingDir);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        MEPer.this.editor.requestFocus();
                    }
                });
            }
        };
        this.helpAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object object;
                if (MEPer.this.helpWindow == null) {
                    Object object2;
                    Object object3;
                    MEPer.this.helpWindow = new JDialog();
                    JTextArea jTextArea = new JTextArea();
                    jTextArea.setEditable(false);
                    jTextArea.setAlignmentX(0.5f);
                    try {
                        object = this.getClass().getResourceAsStream("README.txt");
                        object3 = new InputStreamReader((InputStream)object);
                        BufferedReader bufferedReader = new BufferedReader((Reader)object3);
                        object2 = bufferedReader.readLine();
                        jTextArea.getDocument().insertString(jTextArea.getDocument().getLength(), (String)object2, null);
                        while (!((String)(object2 = bufferedReader.readLine())).equals(null)) {
                            jTextArea.getDocument().insertString(jTextArea.getDocument().getLength(), "\n" + (String)object2, null);
                        }
                        bufferedReader.close();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    object2 = MEPer.this.helpWindow.getContentPane();
                    ((Container)object2).setLayout(new BoxLayout((Container)object2, 1));
                    object = new JLabel(helpTitle);
                    ((JComponent)object).setAlignmentX(0.5f);
                    ((Container)object2).add((Component)object);
                    jTextArea.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 10));
                    ((Container)object2).add(jTextArea);
                    object3 = new JButton(new AbstractAction(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            MEPer.this.helpWindow.setVisible(false);
                            MEPer.this.editor.requestFocus();
                        }
                    });
                    ((AbstractButton)object3).setText("Close");
                    ((JComponent)object3).setAlignmentX(0.5f);
                    ((Container)object2).add((Component)object3);
                    MEPer.this.helpWindow.addWindowListener(new WindowAdapter(){

                        @Override
                        public void windowClosing(WindowEvent windowEvent) {
                            MEPer.this.helpWindow.setVisible(false);
                            MEPer.this.editor.requestFocus();
                        }
                    });
                    MEPer.this.helpWindow.pack();
                }
                int n = (MEPer.this.getWidth() - MEPer.this.helpWindow.getWidth()) / 2;
                int n2 = (MEPer.this.getHeight() - MEPer.this.helpWindow.getHeight()) / 3;
                object = MEPer.this.getLocation();
                ((Point)object).translate(n, n2);
                MEPer.this.helpWindow.setLocation((Point)object);
                MEPer.this.helpWindow.setVisible(true);
            }
        };
    }

    public MEPer() {
        Object object;
        Object object2;
        String string = System.getProperty("os.name").toLowerCase();
        this.ispc = string.indexOf("win") != -1;
        ghostscript = (this.ispc ? "gsWin32" : "gs") + ghostscript;
        this.workingDir = System.getProperty("user.dir");
        File file = new File(System.getProperty("user.home") + File.separator + dirName);
        if (file.exists() || file.mkdir()) {
            this.workingDir = file.getAbsolutePath();
            System.setProperty("user.dir", this.workingDir);
        }
        this.toolbar = new JToolBar();
        this.createActions();
        this.saveButton = new JButton(this.saveAction);
        this.saveButton.setText("Save");
        this.saveButton.setToolTipText("Ctr+S");
        this.toolbar.add(this.saveButton);
        this.previewButton = new JButton(this.previewAction);
        this.previewButton.setText("Preview");
        this.previewButton.setToolTipText("Ctr+P");
        this.toolbar.add(this.previewButton);
        this.toolbar.add(Box.createHorizontalGlue());
        this.helpButton = new JButton(this.helpAction);
        this.helpButton.setText("Help");
        this.toolbar.add(this.helpButton);
        this.statusLabel = new JLabel();
        this.statusLabel.setText("Working directory: " + System.getProperty("user.dir"));
        this.statusLabel.setFont(new Font("Serif", 0, 12));
        this.editor = new JTextPane();
        this.editorFilter = new EditorFilter(this.editor, this.saveButton);
        ((AbstractDocument)this.editor.getDocument()).setDocumentFilter(this.editorFilter);
        this.editor.getInputMap().put(KeyStroke.getKeyStroke("ctrl S"), "save");
        this.editor.getInputMap().put(KeyStroke.getKeyStroke("ctrl P"), "preview");
        this.editor.getActionMap().put("save", this.saveAction);
        this.editor.getActionMap().put("preview", this.previewAction);
        String string2 = this.workingDir + File.separator + "preview.mp";
        try {
            BufferedReader bufferedReader;
            boolean bl = false;
            if (new File(string2).exists()) {
                bufferedReader = new BufferedReader(new FileReader(string2));
            } else {
                this.statusLabel.setText("Can't load preview.mp; using template instead.");
                bl = true;
                object2 = this.getClass().getResourceAsStream("template.mp");
                object = new InputStreamReader((InputStream)object2);
                bufferedReader = new BufferedReader((Reader)object);
            }
            object2 = bufferedReader.readLine();
            this.editor.getDocument().insertString(this.editor.getDocument().getLength(), (String)object2, null);
            while ((object2 = bufferedReader.readLine()) != null) {
                this.editor.getDocument().insertString(this.editor.getDocument().getLength(), "\n" + (String)object2, null);
            }
            bufferedReader.close();
            if (bl) {
                this.editor.setCaretPosition(this.editor.getDocument().getLength() - 12);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.saveButton.setEnabled(false);
        JScrollPane jScrollPane = new JScrollPane(this.editor);
        this.graph = new JLabel();
        this.graph.setOpaque(true);
        this.graph.setBackground(Color.WHITE);
        object2 = new ImageIcon(this.workingDir + File.separator + "preview.png");
        this.graph.setIcon((Icon)object2);
        this.graph.setHorizontalAlignment(0);
        this.graph.setVerticalAlignment(0);
        object = new JScrollPane(this.graph);
        jScrollPane.setPreferredSize(new Dimension(initWidth / 2, initHeight));
        JSplitPane jSplitPane = new JSplitPane(1, jScrollPane, (Component)object);
        this.getContentPane().add((Component)this.toolbar, "First");
        this.getContentPane().add((Component)jSplitPane, "Center");
        this.getContentPane().add((Component)this.statusLabel, "Last");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent windowEvent) {
                MEPer.this.editor.requestFocus();
            }

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                int n;
                if (MEPer.this.saveButton.isEnabled() && (n = JOptionPane.showConfirmDialog(MEPer.this, "Save file before exit?", "Closing...", 0)) == 0) {
                    MEPer.this.saveFile();
                }
            }
        });
    }

    private static void initialize() {
        int n;
        MEPer mEPer = new MEPer();
        mEPer.setTitle("MetaPost Editor and Previewer");
        mEPer.setDefaultCloseOperation(3);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n2 = (int)((dimension.getWidth() - (double)initWidth) / 2.0);
        if (n2 < 0) {
            n2 = 0;
        }
        if ((n = (int)((dimension.getHeight() - (double)initHeight) / 3.0)) < 0) {
            n = 0;
        }
        mEPer.setPreferredSize(new Dimension(initWidth, initHeight));
        mEPer.setLocation(n2, n);
        mEPer.pack();
        mEPer.setVisible(true);
    }

    public static void main(String[] stringArray) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MEPer.initialize();
            }
        });
    }
}

