/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.texlipse.model;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.List;
import net.sourceforge.texlipse.TexlipsePlugin;
import net.sourceforge.texlipse.builder.KpsewhichRunner;
import net.sourceforge.texlipse.model.OutlineNode;
import net.sourceforge.texlipse.texparser.TexParser;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TexProjectParser {
    private IProject currentProject;
    private IFile file;
    private TexParser parser;
    private static final String TEX_FILE_ENDING = ".tex";

    public TexProjectParser(IProject currentProject) {
        this.currentProject = currentProject;
    }

    public IFile findIFile(String fileName, IFile referringFile) {
        return TexProjectParser.findIFile(fileName, referringFile, this.currentProject);
    }

    public static IFile findIFile(String fileName, IFile referringFile, IProject currentProject) {
        if (fileName.indexOf(46) == -1 || fileName.lastIndexOf(47) > fileName.lastIndexOf(46)) {
            fileName = String.valueOf(fileName) + TEX_FILE_ENDING;
        }
        IPath path = referringFile.getFullPath();
        IFile file = currentProject.getFile(path = path.removeFirstSegments(1).removeLastSegments(1).append(fileName));
        if (!file.exists()) {
            KpsewhichRunner filesearch = new KpsewhichRunner();
            try {
                String fName = filesearch.getFile((IResource)currentProject, fileName, "latex");
                if (fName.length() > 0) {
                    Path p = new Path(fName);
                    file.createLink((IPath)p, 0, null);
                }
            }
            catch (CoreException e) {
                TexlipsePlugin.log("Can't run Kpathsea", e);
            }
        }
        return file.exists() ? file : null;
    }

    public List<OutlineNode> parseFile(IFile file) throws IOException {
        this.file = file;
        return this.parseFile();
    }

    private List<OutlineNode> parseFile() throws IOException {
        String inputContent = this.readFile(this.file);
        this.parseDocument(inputContent);
        if (this.parser.isFatalErrors()) {
            throw new IOException("Unable to parse document successfully");
        }
        return this.parser.getOutlineTree();
    }

    private void parseDocument(String input) throws IOException {
        if (this.parser == null) {
            this.parser = new TexParser(null);
        }
        this.parser.parseDocument(input, false);
    }

    private String readFile(IFile file) throws IOException {
        StringBuilder inputContent = new StringBuilder("");
        try {
            BufferedReader buf = new BufferedReader(new InputStreamReader(file.getContents()));
            int read = 10000;
            char[] fileData = new char[10000];
            while (read == 10000) {
                read = buf.read(fileData, 0, 10000);
                if (read <= 0) continue;
                inputContent.append(fileData, 0, read);
            }
            buf.close();
        }
        catch (CoreException e) {
            throw new IOException(e.getMessage());
        }
        return inputContent.toString();
    }
}

